/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.thread.ApplyStepOperation;
import org.optaplanner.core.impl.heuristic.thread.DestroyOperation;
import org.optaplanner.core.impl.heuristic.thread.MoveEvaluationOperation;
import org.optaplanner.core.impl.heuristic.thread.MoveThreadOperation;
import org.optaplanner.core.impl.heuristic.thread.OrderByMoveIndexBlockingQueue;
import org.optaplanner.core.impl.heuristic.thread.SetupOperation;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveThreadRunner<Solution_>
implements Runnable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String logIndentation;
    private final int moveThreadIndex;
    private final boolean evaluateDoable;
    private final BlockingQueue<MoveThreadOperation<Solution_>> operationQueue;
    private final OrderByMoveIndexBlockingQueue<Solution_> resultQueue;
    private final CyclicBarrier moveThreadBarrier;
    private final boolean assertMoveScoreFromScratch;
    private final boolean assertExpectedUndoMoveScore;
    private final boolean assertStepScoreFromScratch;
    private final boolean assertExpectedStepScore;
    private final boolean assertShadowVariablesAreNotStaleAfterStep;
    private InnerScoreDirector<Solution_> scoreDirector = null;
    private AtomicLong calculationCount = new AtomicLong(-1L);

    public MoveThreadRunner(String logIndentation, int moveThreadIndex, boolean evaluateDoable, BlockingQueue<MoveThreadOperation<Solution_>> operationQueue, OrderByMoveIndexBlockingQueue<Solution_> resultQueue, CyclicBarrier moveThreadBarrier, boolean assertMoveScoreFromScratch, boolean assertExpectedUndoMoveScore, boolean assertStepScoreFromScratch, boolean assertExpectedStepScore, boolean assertShadowVariablesAreNotStaleAfterStep) {
        this.logIndentation = logIndentation;
        this.moveThreadIndex = moveThreadIndex;
        this.evaluateDoable = evaluateDoable;
        this.operationQueue = operationQueue;
        this.resultQueue = resultQueue;
        this.moveThreadBarrier = moveThreadBarrier;
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
        this.assertStepScoreFromScratch = assertStepScoreFromScratch;
        this.assertExpectedStepScore = assertExpectedStepScore;
        this.assertShadowVariablesAreNotStaleAfterStep = assertShadowVariablesAreNotStaleAfterStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block20: {
                MoveThreadOperation<Solution_> operation;
                int stepIndex = -1;
                Score lastStepScore = null;
                while (true) {
                    try {
                        operation = this.operationQueue.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break block20;
                    }
                    if (operation instanceof SetupOperation) {
                        SetupOperation setupOperation = (SetupOperation)operation;
                        this.scoreDirector = setupOperation.getScoreDirector().createChildThreadScoreDirector(ChildThreadType.MOVE_THREAD);
                        stepIndex = 0;
                        lastStepScore = this.scoreDirector.calculateScore();
                        this.logger.trace("{}            Move thread ({}) setup: step index ({}), score ({}).", new Object[]{this.logIndentation, this.moveThreadIndex, stepIndex, lastStepScore});
                        try {
                            this.moveThreadBarrier.await();
                            continue;
                        }
                        catch (InterruptedException | BrokenBarrierException e) {
                            Thread.currentThread().interrupt();
                            break block20;
                        }
                    }
                    if (operation instanceof DestroyOperation) {
                        this.logger.trace("{}            Move thread ({}) destroy: step index ({}).", new Object[]{this.logIndentation, this.moveThreadIndex, stepIndex});
                        this.calculationCount.set(this.scoreDirector.getCalculationCount());
                        break block20;
                    }
                    if (operation instanceof ApplyStepOperation) {
                        ApplyStepOperation applyStepOperation = (ApplyStepOperation)operation;
                        if (stepIndex + 1 != applyStepOperation.getStepIndex()) {
                            throw new IllegalStateException("Impossible situation: the moveThread's stepIndex (" + stepIndex + ") is not followed by the operation's stepIndex (" + applyStepOperation.getStepIndex() + ").");
                        }
                        stepIndex = applyStepOperation.getStepIndex();
                        Move<Solution_> step = applyStepOperation.getStep().rebase(this.scoreDirector);
                        Score score = applyStepOperation.getScore();
                        step.doMove(this.scoreDirector);
                        this.predictWorkingStepScore(step, score);
                        lastStepScore = score;
                        this.logger.trace("{}            Move thread ({}) step: step index ({}), score ({}).", new Object[]{this.logIndentation, this.moveThreadIndex, stepIndex, lastStepScore});
                        try {
                            this.moveThreadBarrier.await();
                            continue;
                        }
                        catch (InterruptedException | BrokenBarrierException e) {
                            Thread.currentThread().interrupt();
                            break block20;
                        }
                    }
                    if (!(operation instanceof MoveEvaluationOperation)) break;
                    MoveEvaluationOperation moveEvaluationOperation = (MoveEvaluationOperation)operation;
                    int moveIndex = moveEvaluationOperation.getMoveIndex();
                    if (stepIndex != moveEvaluationOperation.getStepIndex()) {
                        throw new IllegalStateException("Impossible situation: the moveThread's stepIndex (" + stepIndex + ") differs from the operation's stepIndex (" + moveEvaluationOperation.getStepIndex() + ") with moveIndex (" + moveIndex + ").");
                    }
                    Move<Solution_> move = moveEvaluationOperation.getMove().rebase(this.scoreDirector);
                    if (this.evaluateDoable && !move.isMoveDoable(this.scoreDirector)) {
                        this.logger.trace("{}            Move thread ({}) evaluation: step index ({}), move index ({}), not doable.", new Object[]{this.logIndentation, this.moveThreadIndex, stepIndex, moveIndex});
                        this.resultQueue.addUndoableMove(this.moveThreadIndex, stepIndex, moveIndex, move);
                        continue;
                    }
                    Score score = this.scoreDirector.doAndProcessMove(move, this.assertMoveScoreFromScratch);
                    if (this.assertExpectedUndoMoveScore) {
                        this.scoreDirector.assertExpectedUndoMoveScore(move, lastStepScore);
                    }
                    this.logger.trace("{}            Move thread ({}) evaluation: step index ({}), move index ({}), score ({}).", new Object[]{this.logIndentation, this.moveThreadIndex, stepIndex, moveIndex, score});
                    this.resultQueue.addMove(this.moveThreadIndex, stepIndex, moveIndex, move, score);
                }
                throw new IllegalStateException("Unknown operation (" + operation + ").");
            }
            this.logger.trace("{}            Move thread ({}) finished.", (Object)this.logIndentation, (Object)this.moveThreadIndex);
        }
        catch (Error | RuntimeException throwable) {
            this.logger.trace("{}            Move thread ({}) exception that will be propagated to the solver thread.", new Object[]{this.logIndentation, this.moveThreadIndex, throwable});
            this.resultQueue.addExceptionThrown(this.moveThreadIndex, throwable);
        }
        finally {
            if (this.scoreDirector != null) {
                this.scoreDirector.close();
            }
        }
    }

    protected void predictWorkingStepScore(Move<Solution_> step, Score score) {
        this.scoreDirector.getSolutionDescriptor().setScore(this.scoreDirector.getWorkingSolution(), score);
        if (this.assertStepScoreFromScratch) {
            this.scoreDirector.assertPredictedScoreFromScratch(score, step);
        }
        if (this.assertExpectedStepScore) {
            this.scoreDirector.assertExpectedWorkingScore(score, step);
        }
        if (this.assertShadowVariablesAreNotStaleAfterStep) {
            this.scoreDirector.assertShadowVariablesAreNotStale(score, step);
        }
    }

    public long getCalculationCount() {
        long calculationCount = this.calculationCount.get();
        if (calculationCount == -1L) {
            this.logger.info("{}Score calculation speed will be too low because move thread ({})'s destroy wasn't processed soon enough.", (Object)this.logIndentation);
            return 0L;
        }
        return calculationCount;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.moveThreadIndex;
    }
}

