/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.executor;

import java.util.ArrayList;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.kie.dependencies.HasKnowledgeBuilder;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLMiningModelFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.KiePMMLMiningModelWithSources;

public class MiningModelImplementationProvider
implements ModelImplementationProvider<MiningModel, KiePMMLMiningModel> {
    public PMML_MODEL getPMMLModelType() {
        return KiePMMLMiningModel.PMML_MODEL_TYPE;
    }

    public KiePMMLMiningModel getKiePMMLModel(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, MiningModel model, HasClassLoader hasClassloader) {
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        return KiePMMLMiningModelFactory.getKiePMMLMiningModel(dataDictionary, transformationDictionary, model, packageName, hasClassloader);
    }

    public KiePMMLMiningModel getKiePMMLModelWithSources(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, MiningModel model, HasClassLoader hasClassloader) {
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting KnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        Map<String, String> sourcesMap = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMap(dataDictionary, transformationDictionary, model, packageName, hasClassloader, nestedModels);
        return new KiePMMLMiningModelWithSources(model.getModelName(), packageName, sourcesMap, nestedModels);
    }
}

