/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.api.model.taskassigning.PlanningTask;
import org.kie.server.services.taskassigning.core.model.ModelConstants;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.core.model.solver.TaskHelper;

public class PlanningBuilder {
    private TaskAssigningSolution solution;
    private int publishWindowSize;

    private PlanningBuilder() {
    }

    public static PlanningBuilder create() {
        return new PlanningBuilder();
    }

    public PlanningBuilder withSolution(TaskAssigningSolution solution) {
        this.solution = solution;
        return this;
    }

    public PlanningBuilder withPublishWindowSize(int publishWindowSize) {
        this.publishWindowSize = publishWindowSize;
        return this;
    }

    public List<PlanningItem> build() {
        return this.solution.getUserList().stream().map(this::buildPlanningItems).flatMap(Collection::stream).filter(item -> item.getPlanningTask().isPublished()).collect(Collectors.toList());
    }

    private List<PlanningItem> buildPlanningItems(User user) {
        PlanningItem planningItem;
        int index = 0;
        int publishedCount = 0;
        List userTasks = TaskHelper.extractTasks((TaskOrUser)user, (Predicate)ModelConstants.IS_NOT_DUMMY);
        ArrayList<PlanningItem> userPlanningItems = new ArrayList<PlanningItem>();
        for (Task task : userTasks) {
            planningItem = PlanningItem.builder().containerId(task.getContainerId()).taskId(task.getId()).processInstanceId(Long.valueOf(task.getProcessInstanceId())).planningTask(PlanningTask.builder().taskId(task.getId()).published(Boolean.valueOf(task.isPinned())).assignedUser(user.getUser().getEntityId()).index(Integer.valueOf(index++)).build()).build();
            userPlanningItems.add(planningItem);
            publishedCount += planningItem.getPlanningTask().isPublished() ? 1 : 0;
        }
        Iterator userPlanningItemsIt = userPlanningItems.iterator();
        while (userPlanningItemsIt.hasNext() && (publishedCount < this.publishWindowSize || ModelConstants.IS_PLANNING_USER.test(user.getEntityId()))) {
            planningItem = (PlanningItem)userPlanningItemsIt.next();
            if (planningItem.getPlanningTask().isPublished()) continue;
            planningItem.getPlanningTask().setPublished(Boolean.valueOf(true));
            ++publishedCount;
        }
        return userPlanningItems;
    }
}

