/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Predicate;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicateFactory {
    static final String KIE_PMML_COMPOUND_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLCompoundPredicateEvaluateMethodTemplate.tmpl";
    static final String KIE_PMML_COMPOUND_PREDICATE_EVALUATE_METHOD_TEMPLATE = "KiePMMLCompoundPredicateEvaluateMethodTemplate";
    public static final String EVALUATE_NESTED_PREDICATE = "evaluateNestedPredicate";
    public static final String NESTED_PREDICATE_FUNCTIONS = "functions";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCompoundPredicateFactory.class.getName());

    private KiePMMLCompoundPredicateFactory() {
    }

    public static BlockStmt getCompoundPredicateBody(CompoundPredicate predicate, DataDictionary dataDictionary, List<MethodDeclaration> toPopulate, String rootNodeClassName, String nodeClassName, AtomicInteger counter) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (Predicate nestedPredicate : predicate.getPredicates()) {
            BlockStmt nestedPredicateBody = KiePMMLPredicateFactory.getPredicateBody(nestedPredicate, dataDictionary, toPopulate, rootNodeClassName, nodeClassName, counter);
            MethodDeclaration toAdd = new MethodDeclaration();
            toAdd.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
            toAdd.setType("boolean");
            String nestedMethodName = EVALUATE_NESTED_PREDICATE + nodeClassName + counter.addAndGet(1);
            toAdd.setName(new SimpleName(nestedMethodName));
            methodNames.add(nestedMethodName);
            Parameter parameter = new Parameter();
            parameter.setName(new SimpleName("stringObjectMap"));
            parameter.setType((Type)CommonCodegenUtils.getTypedClassOrInterfaceType(Map.class.getName(), Arrays.asList("String", "Object")));
            toAdd.setParameters(NodeList.nodeList((Node[])new Parameter[]{parameter}));
            toAdd.setBody(nestedPredicateBody);
            toPopulate.add(toAdd);
        }
        CompilationUnit templateEvaluate = JavaParserUtils.getFromFileName(KIE_PMML_COMPOUND_PREDICATE_EVALUATE_METHOD_TEMPLATE_JAVA);
        CompilationUnit cloneEvaluate = templateEvaluate.clone();
        ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_COMPOUND_PREDICATE_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException("Main class not found"));
        BlockStmt toReturn = (BlockStmt)((MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluate").get(0)).getBody().orElseThrow(() -> new KiePMMLInternalException("Failed to find body for \"evaluate\""));
        NodeList functionsExpressions = new NodeList();
        for (String nestedMethodName : methodNames) {
            MethodReferenceExpr toAdd = new MethodReferenceExpr();
            toAdd.setScope((Expression)new NameExpr(rootNodeClassName));
            toAdd.setIdentifier(nestedMethodName);
            functionsExpressions.add((Node)toAdd);
        }
        MethodCallExpr valuesInit = new MethodCallExpr();
        valuesInit.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
        valuesInit.setName("asList");
        valuesInit.setArguments(functionsExpressions);
        CommonCodegenUtils.setVariableDeclaratorValue(toReturn, NESTED_PREDICATE_FUNCTIONS, (Expression)valuesInit);
        Expression returnExpression = KiePMMLCompoundPredicateFactory.getReturnExpression(evaluateTemplateClass, predicate.getBooleanOperator());
        CommonCodegenUtils.setAssignExpressionValue(toReturn, "toReturn", returnExpression);
        return toReturn;
    }

    private static Expression getReturnExpression(ClassOrInterfaceDeclaration evaluateTemplateClass, CompoundPredicate.BooleanOperator booleanOperator) {
        String methodName = String.format("evaluate%s", booleanOperator.name());
        BlockStmt blockStmt = (BlockStmt)((MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0)).getBody().orElseThrow(() -> new KiePMMLInternalException("Failed to find body for " + methodName));
        ReturnStmt returnStmt = blockStmt.stream().filter(statement -> statement instanceof ReturnStmt).findFirst().map(ReturnStmt.class::cast).orElseThrow(() -> new KiePMMLInternalException("Failed to find return statement for " + methodName));
        return (Expression)returnStmt.getExpression().orElseThrow(() -> new KiePMMLInternalException("Failed to find return expression for " + methodName));
    }
}

