/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;

public class ConnectionPoolConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ConnectionPoolConfiguration> {
    private ExhaustedAction exhaustedAction = ExhaustedAction.WAIT;
    private boolean lifo = true;
    private int maxActive = -1;
    private int maxTotal = -1;
    private long maxWait = -1L;
    private int maxIdle = -1;
    private int minIdle = 1;
    private long timeBetweenEvictionRuns = 120000L;
    private long minEvictableIdleTime = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = true;
    private int maxPendingRequests = 5;

    ConnectionPoolConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder exhaustedAction(ExhaustedAction exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder lifo(boolean enabled) {
        this.lifo = enabled;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder maxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder maxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder numTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder timeBetweenEvictionRuns(long timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minEvictableIdleTime(long minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder testOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder testOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    @Deprecated
    public ConnectionPoolConfigurationBuilder testWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxPendingRequests(int maxPendingRequests) {
        this.maxPendingRequests = maxPendingRequests;
        return this;
    }

    public ConnectionPoolConfigurationBuilder withPoolProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties((Properties)properties);
        this.exhaustedAction((ExhaustedAction)typed.getEnumProperty("infinispan.client.hotrod.connection_pool.exhausted_action", ExhaustedAction.class, (Enum)ExhaustedAction.values()[typed.getIntProperty("whenExhaustedAction", this.exhaustedAction.ordinal(), true)], true));
        this.maxActive(typed.getIntProperty("infinispan.client.hotrod.connection_pool.max_active", typed.getIntProperty("maxActive", this.maxActive, true), true));
        this.maxWait(typed.getLongProperty("infinispan.client.hotrod.connection_pool.max_wait", typed.getLongProperty("maxWait", this.maxWait, true), true));
        this.minIdle(typed.getIntProperty("infinispan.client.hotrod.connection_pool.min_idle", typed.getIntProperty("minIdle", this.minIdle, true), true));
        this.minEvictableIdleTime(typed.getLongProperty("infinispan.client.hotrod.connection_pool.min_evictable_idle_time", typed.getLongProperty("minEvictableIdleTimeMillis", this.minEvictableIdleTime, true), true));
        this.maxPendingRequests(typed.getIntProperty("infinispan.client.hotrod.connection_pool.max_pending_requests", typed.getIntProperty("maxPendingRequests", this.maxPendingRequests, true), true));
        this.lifo(typed.getBooleanProperty("lifo", this.lifo, true));
        this.maxTotal(typed.getIntProperty("maxTotal", this.maxTotal, true));
        this.maxIdle(typed.getIntProperty("maxIdle", this.maxIdle, true));
        this.numTestsPerEvictionRun(typed.getIntProperty("numTestsPerEvictionRun", this.numTestsPerEvictionRun, true));
        this.timeBetweenEvictionRuns(typed.getLongProperty("timeBetweenEvictionRunsMillis", this.timeBetweenEvictionRuns, true));
        this.testOnBorrow(typed.getBooleanProperty("testOnBorrow", this.testOnBorrow, true));
        this.testOnReturn(typed.getBooleanProperty("testOnReturn", this.testOnReturn, true));
        this.testWhileIdle(typed.getBooleanProperty("testWhileIdle", this.testWhileIdle, true));
        return this;
    }

    public void validate() {
    }

    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.exhaustedAction, this.lifo, this.maxActive, this.maxTotal, this.maxWait, this.maxIdle, this.minIdle, this.numTestsPerEvictionRun, this.timeBetweenEvictionRuns, this.minEvictableIdleTime, this.testOnBorrow, this.testOnReturn, this.testWhileIdle, this.maxPendingRequests);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.exhaustedAction = template.exhaustedAction();
        this.lifo = template.lifo();
        this.maxActive = template.maxActive();
        this.maxTotal = template.maxTotal();
        this.maxWait = template.maxWait();
        this.maxIdle = template.maxIdle();
        this.minIdle = template.minIdle();
        this.numTestsPerEvictionRun = template.numTestsPerEvictionRun();
        this.timeBetweenEvictionRuns = template.timeBetweenEvictionRuns();
        this.minEvictableIdleTime = template.minEvictableIdleTime();
        this.testOnBorrow = template.testOnBorrow();
        this.testOnReturn = template.testOnReturn();
        this.testWhileIdle = template.testWhileIdle();
        this.maxPendingRequests = template.maxPendingRequests();
        return this;
    }
}

