/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.context;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.drools.core.addon.TypeResolver;
import org.drools.core.util.StringUtils;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.context.Declaration;

public class MvelCompilerContext {
    private final Map<String, Declaration> declarations = new HashMap<String, Declaration>();
    private final TypeResolver typeResolver;
    private final String scopeSuffix;
    private final Set<String> usedBindings = new HashSet<String>();
    private Optional<Type> rootPattern = Optional.empty();
    private String rootTypePrefix;

    public MvelCompilerContext(TypeResolver typeResolver) {
        this(typeResolver, null);
    }

    public MvelCompilerContext(TypeResolver typeResolver, String scopeSuffix) {
        this.typeResolver = typeResolver;
        this.scopeSuffix = StringUtils.isEmpty((CharSequence)scopeSuffix) ? null : scopeSuffix;
    }

    public MvelCompilerContext addDeclaration(String name, Class<?> clazz) {
        this.declarations.put(name, new Declaration(name, clazz));
        return this;
    }

    public Optional<Declaration> findDeclarations(String name) {
        Declaration d = this.declarations.get(name);
        if (d == null && this.scopeSuffix != null) {
            d = this.declarations.get(name + this.scopeSuffix);
        }
        return Optional.ofNullable(d);
    }

    public Optional<Class<?>> findEnum(String name) {
        try {
            return Optional.of(this.typeResolver.resolveType(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public Class<?> resolveType(String name) {
        try {
            return this.typeResolver.resolveType(name);
        }
        catch (ClassNotFoundException e) {
            throw new MvelCompilerException(e);
        }
    }

    public void setRootPattern(Type rootPattern) {
        this.rootPattern = Optional.of(rootPattern);
    }

    public Optional<Type> getRootPattern() {
        return this.rootPattern;
    }

    public String getRootTypePrefix() {
        return this.rootTypePrefix;
    }

    public void setRootTypePrefix(String rootTypePrefix) {
        this.rootTypePrefix = rootTypePrefix;
    }

    public void addUsedBinding(String s) {
        this.usedBindings.add(s);
    }

    public Set<String> getUsedBindings() {
        return this.usedBindings;
    }
}

