/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.concurrent.ScheduledExecutorService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.kie.server.services.taskassigning.planning.SolverHandler;
import org.kie.server.services.taskassigning.planning.SolverHandlerConfig;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.planning.TaskAssigningServiceConfig;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.kie.soup.commons.validation.PortablePreconditions;

public class TaskAssigningService {
    private TaskAssigningRuntimeDelegate delegate;
    private UserSystemService userSystemService;
    private ScheduledExecutorService executorService;
    private SolverHandler solverHandler;
    private SolverHandlerConfig solverHandlerConfig;

    public TaskAssigningService(TaskAssigningServiceConfig config) {
        PortablePreconditions.checkNotNull((String)"config", (Object)config);
        this.solverHandlerConfig = config.getSolverHandlerConfig();
    }

    public void setDelegate(TaskAssigningRuntimeDelegate delegate) {
        this.delegate = delegate;
    }

    public void setUserSystemService(UserSystemService userSystemService) {
        this.userSystemService = userSystemService;
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public void start(SolverDef solverDef, KieServerRegistry registry) {
        this.solverHandler = this.createSolverHandler(solverDef, registry, this.delegate, this.userSystemService, this.executorService, this.solverHandlerConfig);
        this.solverHandler.start();
    }

    public void destroy() {
        if (this.solverHandler != null) {
            this.solverHandler.destroy();
        }
    }

    SolverHandler createSolverHandler(SolverDef solverDef, KieServerRegistry registry, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystemService, ScheduledExecutorService executorService, SolverHandlerConfig solverHandlerConfig) {
        return new SolverHandler(solverDef, registry, delegate, userSystemService, executorService, solverHandlerConfig);
    }
}

