/*
 * Decompiled with CFR 0.152.
 */
package org.kie.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.kie.soup.security.utils.BasicAuthorizationPrincipal;

public class KieLoginModule
implements LoginModule {
    private CallbackHandler handler;
    private Subject subject;
    protected boolean committed = false;
    protected Principal principal = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try {
            this.handler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            if (name != null && password != null) {
                String basicAuthHeader = "Basic " + Base64.getEncoder().encodeToString((name + ":" + password).getBytes("UTF-8"));
                this.principal = new BasicAuthorizationPrincipal(basicAuthHeader);
                return true;
            }
            throw new LoginException("Unable to proceed as there is no username or password given");
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.committed = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }
}

