/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.tree.compiler.factories.KiePMMLTreeModelASTFactory;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLDroolsModelFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLTreeModelFactory {
    static final String KIE_PMML_TREE_MODEL_TEMPLATE_JAVA = "KiePMMLTreeModelTemplate.tmpl";
    static final String KIE_PMML_TREE_MODEL_TEMPLATE = "KiePMMLTreeModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLTreeModelFactory.class.getName());

    private KiePMMLTreeModelFactory() {
    }

    public static KiePMMLTreeModel getKiePMMLTreeModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, TreeModel model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName, HasClassLoader hasClassLoader) throws IllegalAccessException, InstantiationException {
        logger.trace("getKiePMMLTreeModel {} {}", (Object)packageName, (Object)model);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        Map<String, String> sourcesMap = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap(dataDictionary, transformationDictionary, model, fieldTypeMap, packageName);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLScorecardModelClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLTreeModel)kiePMMLScorecardModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLTreeModelSourcesMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, TreeModel model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName) {
        logger.trace("getKiePMMLTreeModelSourcesMap {} {} {}", new Object[]{dataDictionary, model, packageName});
        CompilationUnit cloneCU = KiePMMLDroolsModelFactoryUtils.getKiePMMLModelCompilationUnit((DataDictionary)dataDictionary, (Model)model, fieldTypeMap, (String)packageName, (String)KIE_PMML_TREE_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_TREE_MODEL_TEMPLATE);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        KiePMMLTreeModelFactory.setConstructor(model, dataDictionary, transformationDictionary, modelTemplate);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    public static KiePMMLDroolsAST getKiePMMLDroolsAST(DataDictionary dataDictionary, TreeModel model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
        logger.trace("getKiePMMLDroolsAST {}", (Object)model);
        return KiePMMLTreeModelASTFactory.getKiePMMLDroolsAST(dataDictionary, model, fieldTypeMap, types);
    }

    static void setConstructor(TreeModel treeModel, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, (DataDictionary)dataDictionary, (TransformationDictionary)transformationDictionary, (Model)treeModel);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"algorithmName", (String)String.format("\"%s\"", treeModel.getAlgorithmName()));
    }
}

