/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcess {
    private static final Logger logger = LoggerFactory.getLogger(PostProcess.class);

    private PostProcess() {
    }

    public static void postProcess(PMML4Result toReturn, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        PostProcess.executeTargets(toReturn, model);
        PostProcess.updateTargetValueType(model, toReturn);
        PostProcess.populateOutputFields(model, toReturn, kiePMMLNameValues);
    }

    static void executeTargets(PMML4Result toModify, KiePMMLModel model) {
        logger.debug("executeTargets {} {}", (Object)toModify, (Object)model);
        if (!toModify.getResultCode().equals(ResultCode.OK.getName())) {
            return;
        }
        String targetFieldName = toModify.getResultObjectName();
        Map resultVariables = toModify.getResultVariables();
        model.getKiePMMLTargets().stream().filter(kiePMMLTarget -> kiePMMLTarget.getField() != null && kiePMMLTarget.getField().equals(targetFieldName)).findFirst().ifPresent(kiePMMLTarget -> {
            Object prediction = resultVariables.get(targetFieldName);
            logger.debug("Original prediction {}", prediction);
            Object modifiedPrediction = kiePMMLTarget.modifyPrediction(resultVariables.get(targetFieldName));
            logger.debug("Modified prediction {}", modifiedPrediction);
            resultVariables.put(targetFieldName, modifiedPrediction);
        });
    }

    static void updateTargetValueType(KiePMMLModel model, PMML4Result toUpdate) {
        DATA_TYPE dataType = model.getMiningFields().stream().filter(miningField -> model.getTargetField().equals(miningField.getName())).map(MiningField::getDataType).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find DATA_TYPE for " + model.getTargetField()));
        Object prediction = toUpdate.getResultVariables().get(model.getTargetField());
        if (prediction != null) {
            Object convertedPrediction = dataType.getActualValue(prediction);
            toUpdate.getResultVariables().put(model.getTargetField(), convertedPrediction);
        }
    }

    static void populateOutputFields(KiePMMLModel model, PMML4Result toUpdate, List<KiePMMLNameValue> kiePMMLNameValues) {
        List<KiePMMLOutputField> reasonCodeOutputFields;
        List<KiePMMLOutputField> transformedOutputFields;
        logger.debug("populateOutputFields {} {} {}", new Object[]{model, toUpdate, kiePMMLNameValues});
        Map<RESULT_FEATURE, List<KiePMMLOutputField>> outputFieldsByFeature = model.getKiePMMLOutputFields().stream().collect(Collectors.groupingBy(KiePMMLOutputField::getResultFeature));
        List<KiePMMLOutputField> predictedOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.PREDICTED_VALUE);
        if (predictedOutputFields != null) {
            predictedOutputFields.forEach(outputField -> PostProcess.populatePredictedOutputField(outputField, toUpdate, model, kiePMMLNameValues));
        }
        if ((transformedOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.TRANSFORMED_VALUE)) != null) {
            transformedOutputFields.forEach(outputField -> PostProcess.populateTransformedOutputField(outputField, toUpdate, model, kiePMMLNameValues));
        }
        if ((reasonCodeOutputFields = outputFieldsByFeature.get(RESULT_FEATURE.REASON_CODE)) != null) {
            Map sortedByValue = model.getOutputFieldsMap().entrySet().stream().filter(entry -> entry.getValue() instanceof Double && (Double)entry.getValue() > 0.0).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), (Double)entry.getValue())).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            ArrayList orderedReasonCodes = new ArrayList(sortedByValue.keySet());
            reasonCodeOutputFields.forEach(outputField -> PostProcess.populateReasonCodeOutputField(outputField, toUpdate, orderedReasonCodes));
        }
    }

    static void populatePredictedOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        logger.debug("populatePredictedOutputField {} {} {} {}", new Object[]{outputField, toUpdate, model, kiePMMLNameValues});
        if (!RESULT_FEATURE.PREDICTED_VALUE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        String targetFieldName = outputField.getTargetField().orElse(toUpdate.getResultObjectName());
        Optional<Object> variableValue = Optional.empty();
        if (targetFieldName != null) {
            variableValue = Stream.of(PostProcess.getValueFromPMMLResultByVariableName(targetFieldName, toUpdate), PostProcess.getValueFromKiePMMLNameValuesByVariableName(targetFieldName, kiePMMLNameValues)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        variableValue.ifPresent(objValue -> toUpdate.addResultVariable(outputField.getName(), objValue));
    }

    static void populateTransformedOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        logger.debug("populateTransformedOutputField {} {} {} {}", new Object[]{outputField, toUpdate, model, kiePMMLNameValues});
        if (!RESULT_FEATURE.TRANSFORMED_VALUE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        String variableName = outputField.getName();
        Optional<Object> variableValue = Optional.empty();
        if (outputField.getKiePMMLExpression() != null) {
            KiePMMLExpression kiePMMLExpression = outputField.getKiePMMLExpression();
            variableValue = PostProcess.getValueFromKiePMMLExpression(kiePMMLExpression, model, kiePMMLNameValues);
        }
        variableValue.ifPresent(objValue -> toUpdate.addResultVariable(variableName, objValue));
    }

    static void populateReasonCodeOutputField(KiePMMLOutputField outputField, PMML4Result toUpdate, List<String> orderedReasonCodes) {
        logger.debug("populateReasonCodeOutputField {} {} {}", new Object[]{outputField, toUpdate, orderedReasonCodes});
        if (!RESULT_FEATURE.REASON_CODE.equals((Object)outputField.getResultFeature())) {
            throw new KiePMMLException("Unexpected " + outputField.getResultFeature());
        }
        if (outputField.getRank() != null) {
            int index = outputField.getRank() - 1;
            String resultCode = null;
            String resultVariableName = outputField.getName();
            if (index < orderedReasonCodes.size()) {
                resultCode = orderedReasonCodes.get(index);
            }
            toUpdate.updateResultVariable(resultVariableName, resultCode);
        }
    }

    static Optional<Object> getValueFromKiePMMLExpression(KiePMMLExpression kiePMMLExpression, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        String expressionType = kiePMMLExpression.getClass().getSimpleName();
        Optional<Object> toReturn = Optional.empty();
        switch (expressionType) {
            case "KiePMMLApply": {
                toReturn = Stream.of(PostProcess.getValueFromKiePMMLApplyFunction((KiePMMLApply)kiePMMLExpression, model, kiePMMLNameValues), PostProcess.getValueFromKiePMMLApplyMapMissingTo((KiePMMLApply)kiePMMLExpression), PostProcess.getValueFromKiePMMLApplyMapDefaultValue((KiePMMLApply)kiePMMLExpression)).filter(Optional::isPresent).map(Optional::get).findFirst();
                break;
            }
            case "KiePMMLConstant": {
                toReturn = PostProcess.getValueFromKiePMMLConstant((KiePMMLConstant)kiePMMLExpression);
                break;
            }
            case "KiePMMLFieldRef": {
                toReturn = Stream.of(PostProcess.getValueFromKiePMMLNameValuesByVariableName(((KiePMMLFieldRef)kiePMMLExpression).getName(), kiePMMLNameValues), PostProcess.getValueFromKiePMMLOutputFieldsByVariableName(((KiePMMLFieldRef)kiePMMLExpression).getName(), model, kiePMMLNameValues), PostProcess.getMissingValueFromKiePMMLFieldRefMapMissingTo((KiePMMLFieldRef)kiePMMLExpression)).filter(Optional::isPresent).map(Optional::get).findFirst();
                break;
            }
        }
        return toReturn;
    }

    static Optional<Object> getValueFromKiePMMLApplyFunction(KiePMMLApply kiePMMLApply, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        Optional<Object> optionalObjectParameter = Optional.empty();
        if (kiePMMLApply.getKiePMMLExpressions() != null && !kiePMMLApply.getKiePMMLExpressions().isEmpty()) {
            optionalObjectParameter = PostProcess.getValueFromKiePMMLExpression((KiePMMLExpression)kiePMMLApply.getKiePMMLExpressions().get(0), model, kiePMMLNameValues);
        }
        return PostProcess.getValueFromFunctionsMapByFunctionName(model.getFunctionsMap(), kiePMMLApply.getFunction(), kiePMMLNameValues, optionalObjectParameter.orElse(null));
    }

    static Optional<Object> getValueFromFunctionsMapByFunctionName(Map<String, BiFunction<List<KiePMMLNameValue>, Object, Object>> functionsMap, String functionName, List<KiePMMLNameValue> kiePMMLNameValues, Object objectParameter) {
        return functionsMap.entrySet().parallelStream().filter(entry -> ((String)entry.getKey()).equals(functionName)).map(entry -> ((BiFunction)entry.getValue()).apply(kiePMMLNameValues, objectParameter)).findFirst();
    }

    static Optional<Object> getValueFromKiePMMLConstant(KiePMMLConstant kiePMMLConstant) {
        return Optional.ofNullable(kiePMMLConstant.getValue());
    }

    static Optional<Object> getValueFromKiePMMLApplyMapMissingTo(KiePMMLApply kiePMMLApply) {
        return Optional.ofNullable(kiePMMLApply.getMapMissingTo());
    }

    static Optional<Object> getValueFromKiePMMLApplyMapDefaultValue(KiePMMLApply kiePMMLApply) {
        return Optional.ofNullable(kiePMMLApply.getDefaultValue());
    }

    static Optional<Object> getValueFromKiePMMLNameValuesByVariableName(String variableName, List<KiePMMLNameValue> kiePMMLNameValues) {
        return kiePMMLNameValues.stream().filter(kiePMMLNameValue -> kiePMMLNameValue.getName().equals(variableName)).map(KiePMMLNameValue::getValue).findFirst();
    }

    static Optional<Object> getValueFromKiePMMLOutputFieldsByVariableName(String variableName, KiePMMLModel model, List<KiePMMLNameValue> kiePMMLNameValues) {
        KiePMMLOutputField outputField;
        List kiePMMLOutputFields = model.getKiePMMLOutputFields();
        Optional<KiePMMLOutputField> found = kiePMMLOutputFields.stream().filter(kiePMMLOutputField -> variableName.equals(kiePMMLOutputField.getName())).findFirst();
        Optional<Object> variableValue = Optional.empty();
        if (found.isPresent() && (outputField = found.get()).getKiePMMLExpression() != null) {
            KiePMMLExpression kiePMMLExpression = outputField.getKiePMMLExpression();
            variableValue = PostProcess.getValueFromKiePMMLExpression(kiePMMLExpression, model, kiePMMLNameValues);
        }
        return variableValue;
    }

    static Optional<Object> getValueFromPMMLResultByVariableName(String variableName, PMML4Result pmml4Result) {
        return Optional.ofNullable(pmml4Result.getResultVariables().get(variableName));
    }

    static Optional<Object> getMissingValueFromKiePMMLFieldRefMapMissingTo(KiePMMLFieldRef kiePMMLFieldRef) {
        return Optional.ofNullable(kiePMMLFieldRef.getMapMissingTo());
    }
}

