/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.pmml.api.iinterfaces.SerializableFunction;

public abstract class KiePMMLRegressionTable
implements Serializable {
    private static final long serialVersionUID = -7899446939844650691L;
    protected Map<String, SerializableFunction<Double, Double>> numericFunctionMap = new HashMap<String, SerializableFunction<Double, Double>>();
    protected Map<String, SerializableFunction<Object, Double>> categoricalFunctionMap = new HashMap<String, SerializableFunction<Object, Double>>();
    protected Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    protected Map<String, SerializableFunction<Map<String, Object>, Double>> predictorTermsFunctionMap = new HashMap<String, SerializableFunction<Map<String, Object>, Double>>();
    protected double intercept;
    protected String targetField;

    public abstract Object getTargetCategory();

    public Object evaluateRegression(Map<String, Object> input) {
        String key;
        AtomicReference<Double> result = new AtomicReference<Double>(this.intercept);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, SerializableFunction<Double, Double>> entry : this.numericFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, entry.getValue().apply((Object)((Number)input.get(key)).doubleValue()));
        }
        for (Map.Entry<String, Object> entry : this.categoricalFunctionMap.entrySet()) {
            key = entry.getKey();
            if (!input.containsKey(key)) continue;
            resultMap.put(key, ((SerializableFunction)entry.getValue()).apply(input.get(key)));
        }
        for (Map.Entry<String, Object> entry : this.predictorTermsFunctionMap.entrySet()) {
            resultMap.put(entry.getKey(), ((SerializableFunction)entry.getValue()).apply(input));
        }
        resultMap.values().forEach(value -> result.accumulateAndGet((Double)value, Double::sum));
        this.updateResult(result);
        return result.get();
    }

    public Map<String, Object> getOutputFieldsMap() {
        return this.outputFieldsMap;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public Map<String, SerializableFunction<Double, Double>> getNumericFunctionMap() {
        return this.numericFunctionMap;
    }

    public Map<String, SerializableFunction<Object, Double>> getCategoricalFunctionMap() {
        return this.categoricalFunctionMap;
    }

    public Map<String, SerializableFunction<Map<String, Object>, Double>> getPredictorTermsFunctionMap() {
        return this.predictorTermsFunctionMap;
    }

    public double getIntercept() {
        return this.intercept;
    }

    protected abstract void updateResult(AtomicReference<Double> var1);
}

