/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.examples.common.persistence.AbstractXlsxSolutionFileIO;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceConstraintConfiguration;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.domain.Room;
import org.optaplanner.examples.conferencescheduling.domain.Speaker;
import org.optaplanner.examples.conferencescheduling.domain.Talk;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;
import org.optaplanner.examples.conferencescheduling.domain.Timeslot;
import org.optaplanner.swing.impl.TangoColorFactory;

public class ConferenceSchedulingXlsxFileIO
extends AbstractXlsxSolutionFileIO<ConferenceSolution> {
    private static final String ROOM_UNAVAILABLE_TIMESLOT_DESCRIPTION = "Penalty per talk with an unavailable room in its timeslot, per minute";
    private static final String ROOM_CONFLICT_DESCRIPTION = "Penalty per 2 talks in the same room and overlapping timeslots, per overlapping minute";
    private static final String SPEAKER_UNAVAILABLE_TIMESLOT_DESCRIPTION = "Penalty per talk with an unavailable speaker in its timeslot, per minute";
    private static final String SPEAKER_CONFLICT_DESCRIPTION = "Penalty per 2 talks with the same speaker and overlapping timeslots, per overlapping minute";
    private static final String TALK_PREREQUISITE_TALKS_DESCRIPTION = "Penalty per prerequisite talk of a talk that doesn't end before the second talk starts, per minute of either talk";
    private static final String TALK_MUTUALLY_EXCLUSIVE_TALKS_TAGS_DESCRIPTION = "Penalty per common mutually exclusive talks tag of 2 talks with overlapping timeslots, per overlapping minute";
    private static final String CONSECUTIVE_TALKS_PAUSE_DESCRIPTION = "Penalty per 2 consecutive talks for the same speaker with a pause less than the minimum pause, per minute of either talk";
    private static final String CROWD_CONTROL_DESCRIPTION = "Penalty per talk with a non-zero crowd control risk that are not in paired with exactly one other such talk, per minute of either talk";
    private static final String SPEAKER_REQUIRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per missing required tag in a talk's timeslot, per minute";
    private static final String SPEAKER_PROHIBITED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per prohibited tag in a talk's timeslot, per minute";
    private static final String TALK_REQUIRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per missing required tag in a talk's timeslot, per minute";
    private static final String TALK_PROHIBITED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per prohibited tag in a talk's timeslot, per minute";
    private static final String SPEAKER_REQUIRED_ROOM_TAGS_DESCRIPTION = "Penalty per missing required tag in a talk's room, per minute";
    private static final String SPEAKER_PROHIBITED_ROOM_TAGS_DESCRIPTION = "Penalty per prohibited tag in a talk's room, per minute";
    private static final String TALK_REQUIRED_ROOM_TAGS_DESCRIPTION = "Penalty per missing required tag in a talk's room, per minute";
    private static final String TALK_PROHIBITED_ROOM_TAGS_DESCRIPTION = "Penalty per prohibited tag in a talk's room, per minute";
    private static final String PUBLISHED_TIMESLOT_DESCRIPTION = "Penalty per published talk with a different timeslot than its published timeslot, per match";
    private static final String PUBLISHED_ROOM_DESCRIPTION = "Penalty per published talk with a different room than its published room, per match";
    private static final String THEME_TRACK_CONFLICT_DESCRIPTION = "Penalty per common theme track of 2 talks with overlapping timeslots, per overlapping minute";
    private static final String THEME_TRACK_ROOM_STABILITY_DESCRIPTION = "Penalty per common theme track of 2 talks in a different room on the same day, per minute of either talk";
    private static final String SECTOR_CONFLICT_DESCRIPTION = "Penalty per common sector of 2 talks with overlapping timeslots, per overlapping minute";
    private static final String AUDIENCE_TYPE_DIVERSITY_DESCRIPTION = "Reward per 2 talks with a different audience type and the same timeslot, per (overlapping) minute";
    private static final String AUDIENCE_TYPE_THEME_TRACK_CONFLICT_DESCRIPTION = "Penalty per 2 talks with a common audience type, a common theme track and overlapping timeslots, per overlapping minute";
    private static final String AUDIENCE_LEVEL_DIVERSITY_DESCRIPTION = "Reward per 2 talks with a different audience level and the same timeslot, per (overlapping) minute";
    private static final String CONTENT_AUDIENCE_LEVEL_FLOW_VIOLATION_DESCRIPTION = "Penalty per common content of 2 talks with a different audience level for which the easier talk isn't scheduled earlier than the other talk, per minute of either talk";
    private static final String CONTENT_CONFLICT_DESCRIPTION = "Penalty per common content of 2 talks with overlapping timeslots, per overlapping minute";
    private static final String LANGUAGE_DIVERSITY_DESCRIPTION = "Reward per 2 talks with a different language and the the same timeslot, per (overlapping) minute";
    private static final String SAME_DAY_TALKS_DESCRIPTION = "Penalty per common content or theme track of 2 talks with a different day, per minute of either talk";
    private static final String POPULAR_TALKS_DESCRIPTION = "Penalty per 2 talks where the less popular one (has lower favorite count) is assigned a larger room than the more popular talk";
    private static final String SPEAKER_PREFERRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per missing preferred tag in a talk's timeslot, per minute";
    private static final String SPEAKER_UNDESIRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per undesired tag in a talk's timeslot, per minute";
    private static final String TALK_PREFERRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per missing preferred tag in a talk's timeslot, per minute";
    private static final String TALK_UNDESIRED_TIMESLOT_TAGS_DESCRIPTION = "Penalty per undesired tag in a talk's timeslot, per minute";
    private static final String SPEAKER_PREFERRED_ROOM_TAGS_DESCRIPTION = "Penalty per missing preferred tag in a talk's room, per minute";
    private static final String SPEAKER_UNDESIRED_ROOM_TAGS_DESCRIPTION = "Penalty per undesired tag in a talk's room, per minute";
    private static final String TALK_PREFERRED_ROOM_TAGS_DESCRIPTION = "Penalty per missing preferred tag in a talk's room, per minute";
    private static final String TALK_UNDESIRED_ROOM_TAGS_DESCRIPTION = "Penalty per undesired tag in a talk's room, per minute";
    private static final Comparator<Timeslot> COMPARATOR = Comparator.comparing(Timeslot::getStartDateTime).thenComparing(Collections.reverseOrder(Comparator.comparing(Timeslot::getEndDateTime)));
    private boolean strict;

    public ConferenceSchedulingXlsxFileIO() {
        this(true);
    }

    public ConferenceSchedulingXlsxFileIO(boolean strict) {
        this.strict = strict;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConferenceSolution read(File inputSolutionFile) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputSolutionFile));){
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
            ConferenceSolution conferenceSolution = new ConferenceSchedulingXlsxReader(workbook).read();
            return conferenceSolution;
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(ConferenceSolution solution, File outputSolutionFile) {
        try (FileOutputStream out = new FileOutputStream(outputSolutionFile);){
            Workbook workbook = new ConferenceSchedulingXlsxWriter(solution).write();
            workbook.write((OutputStream)out);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException("Failed writing outputSolutionFile (" + outputSolutionFile + ") for solution (" + solution + ").", e);
        }
    }

    private class ConferenceSchedulingXlsxWriter
    extends AbstractXlsxSolutionFileIO.AbstractXlsxWriter<ConferenceSolution> {
        private Map<String, XSSFCellStyle> themeTrackToStyleMap;

        public ConferenceSchedulingXlsxWriter(ConferenceSolution solution) {
            super(solution, "org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml");
        }

        @Override
        public Workbook write() {
            this.writeSetup();
            this.initializeThemeTrackToStyleMap();
            this.writeConfiguration();
            this.writeTimeslotList();
            this.writeRoomList();
            this.writeSpeakerList();
            this.writeTalkList();
            this.writeInfeasibleView();
            this.writeRoomsView();
            this.writeSpeakersView();
            this.writeThemeTracksView();
            this.writeSectorsView();
            this.writeAudienceTypesView();
            this.writeAudienceLevelsView();
            this.writeContentsView();
            this.writeLanguagesView();
            this.writeScoreView(justificationList -> justificationList.stream().filter(o -> o instanceof Talk).map(o -> ((Talk)o).getCode()).collect(Collectors.joining(", ")));
            this.writeDaysSheets();
            return this.workbook;
        }

        private void initializeThemeTrackToStyleMap() {
            this.themeTrackToStyleMap = new HashMap<String, XSSFCellStyle>();
            TangoColorFactory tangoColorFactory = new TangoColorFactory();
            List themeTrackList = ((ConferenceSolution)this.solution).getTalkList().stream().flatMap(talk -> talk.getThemeTrackTagSet().stream()).distinct().collect(Collectors.toList());
            for (String themeTrack : themeTrackList) {
                XSSFCellStyle style = this.createStyle(new XSSFColor(tangoColorFactory.pickColor((Object)themeTrack)));
                this.themeTrackToStyleMap.put(themeTrack, style);
            }
        }

        private void writeConfiguration() {
            this.nextSheet("Configuration", 1, 4, false);
            this.nextRow();
            this.nextHeaderCell("Conference name");
            this.nextCell().setCellValue(((ConferenceSolution)this.solution).getConferenceName());
            ConferenceConstraintConfiguration constraintConfiguration = ((ConferenceSolution)this.solution).getConstraintConfiguration();
            this.writeIntConstraintParameterLine("Minimum consecutive talks pause in minutes", constraintConfiguration::getMinimumConsecutiveTalksPauseInMinutes, "The amount of time a speaker needs between 2 talks");
            this.nextRow();
            this.writeScoreConstraintHeaders();
            this.writeScoreConstraintLine("Room unavailable timeslot", constraintConfiguration.getRoomUnavailableTimeslot(), ConferenceSchedulingXlsxFileIO.ROOM_UNAVAILABLE_TIMESLOT_DESCRIPTION);
            this.writeScoreConstraintLine("Room conflict", constraintConfiguration.getRoomConflict(), ConferenceSchedulingXlsxFileIO.ROOM_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Speaker unavailable timeslot", constraintConfiguration.getSpeakerUnavailableTimeslot(), ConferenceSchedulingXlsxFileIO.SPEAKER_UNAVAILABLE_TIMESLOT_DESCRIPTION);
            this.writeScoreConstraintLine("Speaker conflict", constraintConfiguration.getSpeakerConflict(), ConferenceSchedulingXlsxFileIO.SPEAKER_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Talk prerequisite talks", constraintConfiguration.getTalkPrerequisiteTalks(), ConferenceSchedulingXlsxFileIO.TALK_PREREQUISITE_TALKS_DESCRIPTION);
            this.writeScoreConstraintLine("Talk mutually-exclusive-talks tags", constraintConfiguration.getTalkMutuallyExclusiveTalksTags(), ConferenceSchedulingXlsxFileIO.TALK_MUTUALLY_EXCLUSIVE_TALKS_TAGS_DESCRIPTION);
            this.writeScoreConstraintLine("Consecutive talks pause", constraintConfiguration.getConsecutiveTalksPause(), ConferenceSchedulingXlsxFileIO.CONSECUTIVE_TALKS_PAUSE_DESCRIPTION);
            this.writeScoreConstraintLine("Crowd control", constraintConfiguration.getCrowdControl(), ConferenceSchedulingXlsxFileIO.CROWD_CONTROL_DESCRIPTION);
            this.writeScoreConstraintLine("Speaker required timeslot tags", constraintConfiguration.getSpeakerRequiredTimeslotTags(), "Penalty per missing required tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Speaker prohibited timeslot tags", constraintConfiguration.getSpeakerProhibitedTimeslotTags(), "Penalty per prohibited tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Talk required timeslot tags", constraintConfiguration.getTalkRequiredTimeslotTags(), "Penalty per missing required tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Talk prohibited timeslot tags", constraintConfiguration.getTalkProhibitedTimeslotTags(), "Penalty per prohibited tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Speaker required room tags", constraintConfiguration.getSpeakerRequiredRoomTags(), "Penalty per missing required tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Speaker prohibited room tags", constraintConfiguration.getSpeakerProhibitedRoomTags(), "Penalty per prohibited tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Talk required room tags", constraintConfiguration.getTalkRequiredRoomTags(), "Penalty per missing required tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Talk prohibited room tags", constraintConfiguration.getTalkProhibitedRoomTags(), "Penalty per prohibited tag in a talk's room, per minute");
            this.nextRow();
            this.writeScoreConstraintLine("Published timeslot", constraintConfiguration.getPublishedTimeslot(), ConferenceSchedulingXlsxFileIO.PUBLISHED_TIMESLOT_DESCRIPTION);
            this.nextRow();
            this.writeScoreConstraintLine("Published room", constraintConfiguration.getPublishedRoom(), ConferenceSchedulingXlsxFileIO.PUBLISHED_ROOM_DESCRIPTION);
            this.writeScoreConstraintLine("Theme track conflict", constraintConfiguration.getThemeTrackConflict(), ConferenceSchedulingXlsxFileIO.THEME_TRACK_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Theme track room stability", constraintConfiguration.getThemeTrackRoomStability(), ConferenceSchedulingXlsxFileIO.THEME_TRACK_ROOM_STABILITY_DESCRIPTION);
            this.writeScoreConstraintLine("Sector conflict", constraintConfiguration.getSectorConflict(), ConferenceSchedulingXlsxFileIO.SECTOR_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Audience type diversity", constraintConfiguration.getAudienceTypeDiversity(), ConferenceSchedulingXlsxFileIO.AUDIENCE_TYPE_DIVERSITY_DESCRIPTION);
            this.writeScoreConstraintLine("Audience type theme track conflict", constraintConfiguration.getAudienceTypeThemeTrackConflict(), ConferenceSchedulingXlsxFileIO.AUDIENCE_TYPE_THEME_TRACK_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Audience level diversity", constraintConfiguration.getAudienceLevelDiversity(), ConferenceSchedulingXlsxFileIO.AUDIENCE_LEVEL_DIVERSITY_DESCRIPTION);
            this.writeScoreConstraintLine("Content audience level flow violation", constraintConfiguration.getContentAudienceLevelFlowViolation(), ConferenceSchedulingXlsxFileIO.CONTENT_AUDIENCE_LEVEL_FLOW_VIOLATION_DESCRIPTION);
            this.writeScoreConstraintLine("Content conflict", constraintConfiguration.getContentConflict(), ConferenceSchedulingXlsxFileIO.CONTENT_CONFLICT_DESCRIPTION);
            this.writeScoreConstraintLine("Language diversity", constraintConfiguration.getLanguageDiversity(), ConferenceSchedulingXlsxFileIO.LANGUAGE_DIVERSITY_DESCRIPTION);
            this.writeScoreConstraintLine("Same day talks", constraintConfiguration.getSameDayTalks(), ConferenceSchedulingXlsxFileIO.SAME_DAY_TALKS_DESCRIPTION);
            this.writeScoreConstraintLine("Popular talks", constraintConfiguration.getPopularTalks(), ConferenceSchedulingXlsxFileIO.POPULAR_TALKS_DESCRIPTION);
            this.writeScoreConstraintLine("Speaker preferred timeslot tags", constraintConfiguration.getSpeakerPreferredTimeslotTags(), "Penalty per missing preferred tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Speaker undesired timeslot tags", constraintConfiguration.getSpeakerUndesiredTimeslotTags(), "Penalty per undesired tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Talk preferred timeslot tags", constraintConfiguration.getTalkPreferredTimeslotTags(), "Penalty per missing preferred tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Talk undesired timeslot tags", constraintConfiguration.getTalkUndesiredTimeslotTags(), "Penalty per undesired tag in a talk's timeslot, per minute");
            this.writeScoreConstraintLine("Speaker preferred room tags", constraintConfiguration.getSpeakerPreferredRoomTags(), "Penalty per missing preferred tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Speaker undesired room tags", constraintConfiguration.getSpeakerUndesiredRoomTags(), "Penalty per undesired tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Talk preferred room tags", constraintConfiguration.getTalkPreferredRoomTags(), "Penalty per missing preferred tag in a talk's room, per minute");
            this.writeScoreConstraintLine("Talk undesired room tags", constraintConfiguration.getTalkUndesiredRoomTags(), "Penalty per undesired tag in a talk's room, per minute");
            this.autoSizeColumnsWithHeader();
        }

        private void writeTimeslotList() {
            this.nextSheet("Timeslots", 3, 1, false);
            this.nextRow();
            this.nextHeaderCell("Day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Talk types");
            this.nextHeaderCell("Tags");
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.nextRow();
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslot.getDate()));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()));
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", timeslot.getTalkTypeSet().stream().map(TalkType::getName).collect(Collectors.toList())));
                this.nextCell().setCellValue(String.join((CharSequence)", ", timeslot.getTagSet()));
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomList() {
            this.nextSheet("Rooms", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Capacity");
            this.nextHeaderCell("Talk types");
            this.nextHeaderCell("Tags");
            this.writeTimeslotHoursHeaders();
            for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                this.nextRow();
                this.nextCell().setCellValue(room.getName());
                this.nextCell().setCellValue((double)room.getCapacity());
                this.nextCell().setCellValue(String.join((CharSequence)", ", room.getTalkTypeSet().stream().map(TalkType::getName).collect(Collectors.toList())));
                this.nextCell().setCellValue(String.join((CharSequence)", ", room.getTagSet()));
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    this.nextCell(room.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSpeakerList() {
            this.nextSheet("Speakers", 1, 2, false);
            this.nextRow();
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Name");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : ((ConferenceSolution)this.solution).getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", speaker.getUndesiredRoomTagSet()));
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    this.nextCell(speaker.getUnavailableTimeslotSet().contains(timeslot) ? this.unavailableStyle : this.defaultStyle).setCellValue("");
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeTalkList() {
            this.nextSheet("Talks", 2, 1, false);
            this.nextRow();
            this.nextHeaderCell("Code");
            this.nextHeaderCell("Title");
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Speakers");
            this.nextHeaderCell("Theme track tags");
            this.nextHeaderCell("Sector tags");
            this.nextHeaderCell("Audience types");
            this.nextHeaderCell("Audience level");
            this.nextHeaderCell("Content tags");
            this.nextHeaderCell("Language");
            this.nextHeaderCell("Required timeslot tags");
            this.nextHeaderCell("Preferred timeslot tags");
            this.nextHeaderCell("Prohibited timeslot tags");
            this.nextHeaderCell("Undesired timeslot tags");
            this.nextHeaderCell("Required room tags");
            this.nextHeaderCell("Preferred room tags");
            this.nextHeaderCell("Prohibited room tags");
            this.nextHeaderCell("Undesired room tags");
            this.nextHeaderCell("Mutually exclusive talks tags");
            this.nextHeaderCell("Prerequisite talks codes");
            this.nextHeaderCell("Favorite count");
            this.nextHeaderCell("Crowd control risk");
            this.nextHeaderCell("Pinned by user");
            this.nextHeaderCell("Timeslot day");
            this.nextHeaderCell("Start");
            this.nextHeaderCell("End");
            this.nextHeaderCell("Room");
            this.nextHeaderCell("Published Timeslot");
            this.nextHeaderCell("Published Start");
            this.nextHeaderCell("Published End");
            this.nextHeaderCell("Published Room");
            for (Talk talk : ((ConferenceSolution)this.solution).getTalkList()) {
                XSSFCellStyle roomStyle;
                XSSFCellStyle timeslotStyle;
                this.nextRow();
                this.nextCell().setCellValue(talk.getCode());
                this.nextCell().setCellValue(talk.getTitle());
                this.nextCell().setCellValue(talk.getTalkType().getName());
                this.nextCell().setCellValue(talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getThemeTrackTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getSectorTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getAudienceTypeSet()));
                this.nextCell().setCellValue((double)talk.getAudienceLevel());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getContentTagSet()));
                this.nextCell().setCellValue(talk.getLanguage());
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredTimeslotTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getRequiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPreferredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getProhibitedRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getUndesiredRoomTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getMutuallyExclusiveTalksTagSet()));
                this.nextCell().setCellValue(String.join((CharSequence)", ", talk.getPrerequisiteTalkSet().stream().map(Talk::getCode).collect(Collectors.toList())));
                this.nextCell().setCellValue((double)talk.getFavoriteCount());
                this.nextCell().setCellValue((double)talk.getCrowdControlRisk());
                this.nextCell(talk.isPinnedByUser() ? this.pinnedStyle : this.defaultStyle).setCellValue(talk.isPinnedByUser());
                if (talk.isPinnedByUser()) {
                    timeslotStyle = talk.getTimeslot() == null ? this.hardPenaltyStyle : this.defaultStyle;
                    roomStyle = talk.getRoom() == null ? this.hardPenaltyStyle : this.defaultStyle;
                } else {
                    timeslotStyle = talk.getPublishedTimeslot() == null || talk.getTimeslot() == talk.getPublishedTimeslot() ? this.planningVariableStyle : this.republishedStyle;
                    roomStyle = talk.getPublishedRoom() == null || talk.getRoom() == talk.getPublishedRoom() ? this.planningVariableStyle : this.republishedStyle;
                }
                this.nextCell(timeslotStyle).setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(talk.getTimeslot().getDate()));
                this.nextCell(timeslotStyle).setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getTimeslot().getStartDateTime()));
                this.nextCell(timeslotStyle).setCellValue(talk.getTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getTimeslot().getEndDateTime()));
                this.nextCell(roomStyle).setCellValue(talk.getRoom() == null ? "" : talk.getRoom().getName());
                this.nextCell().setCellValue(talk.getPublishedTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(talk.getPublishedTimeslot().getDate()));
                this.nextCell().setCellValue(talk.getPublishedTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getPublishedTimeslot().getStartDateTime()));
                this.nextCell().setCellValue(talk.getPublishedTimeslot() == null ? "" : AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(talk.getPublishedTimeslot().getEndDateTime()));
                this.nextCell().setCellValue(talk.getPublishedRoom() == null ? "" : talk.getPublishedRoom().getName());
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeInfeasibleView() {
            if (((ConferenceSolution)this.solution).getScore() == null || ((ConferenceSolution)this.solution).getScore().isFeasible()) {
                return;
            }
            this.nextSheet("Infeasible view", 1, 1, true);
            this.nextRow();
            this.nextHeaderCell("Score");
            this.nextCell().setCellValue(((ConferenceSolution)this.solution).getScore() == null ? "Not yet solved" : ((ConferenceSolution)this.solution).getScore().toShortString());
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Talk type");
            this.nextHeaderCell("Count");
            this.nextHeaderCell("Usable timeslots");
            this.nextHeaderCell("Usable rooms");
            this.nextHeaderCell("Usable sessions");
            Map talkTypeToCountMap = ((ConferenceSolution)this.solution).getTalkList().stream().collect(Collectors.groupingBy(Talk::getTalkType, LinkedHashMap::new, Collectors.counting()));
            for (Map.Entry entry : talkTypeToCountMap.entrySet()) {
                TalkType talkType = (TalkType)entry.getKey();
                long count = (Long)entry.getValue();
                this.nextRow();
                this.nextHeaderCell(talkType.getName());
                this.nextCell().setCellValue((double)count);
                int timeslotListSize = talkType.getCompatibleTimeslotSet().size();
                this.nextCell().setCellValue((double)timeslotListSize);
                int roomListSize = talkType.getCompatibleRoomSet().size();
                this.nextCell().setCellValue((double)roomListSize);
                int sessionCount = timeslotListSize * roomListSize;
                this.nextCell((long)sessionCount < count ? this.hardPenaltyStyle : this.defaultStyle).setCellValue((double)sessionCount);
            }
            this.nextRow();
            this.nextRow();
            this.nextHeaderCell("Total");
            int talkListSize = ((ConferenceSolution)this.solution).getTalkList().size();
            this.nextCell().setCellValue((double)talkListSize);
            int timeslotListSize = ((ConferenceSolution)this.solution).getTimeslotList().size();
            this.nextCell().setCellValue((double)timeslotListSize);
            int roomListSize = ((ConferenceSolution)this.solution).getRoomList().size();
            this.nextCell().setCellValue((double)roomListSize);
            int sessionCount = 0;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                    if (Collections.disjoint(timeslot.getTalkTypeSet(), room.getTalkTypeSet()) || room.getUnavailableTimeslotSet().contains(timeslot)) continue;
                    ++sessionCount;
                }
            }
            this.nextCell(sessionCount < talkListSize ? this.hardPenaltyStyle : this.defaultStyle).setCellValue((double)sessionCount);
            this.autoSizeColumnsWithHeader();
        }

        private void writeRoomsView() {
            this.nextSheet("Rooms view", 1, 2, true);
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Room");
            this.writeTimeslotHoursHeaders();
            for (Room room : ((ConferenceSolution)this.solution).getRoomList()) {
                this.nextRow();
                this.currentRow.setHeightInPoints(3.0f * this.currentSheet.getDefaultRowHeightInPoints());
                this.nextCell().setCellValue(room.getName());
                List roomTalkList = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getRoom() == room).collect(Collectors.toList());
                Timeslot mergePreviousTimeslot = null;
                int mergeStart = -1;
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = roomTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    if (talkList.isEmpty() && mergePreviousTimeslot != null && timeslot.getStartDateTime().compareTo(mergePreviousTimeslot.getEndDateTime()) < 0) {
                        this.nextCell();
                        continue;
                    }
                    if (mergePreviousTimeslot != null && mergeStart < this.currentColumnNumber) {
                        this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                    }
                    boolean unavailable = room.getUnavailableTimeslotSet().contains(timeslot) || Collections.disjoint(room.getTalkTypeSet(), timeslot.getTalkTypeSet());
                    this.nextTalkListCell(unavailable, talkList, talk -> talk.getCode() + ": " + talk.getTitle() + "\n  " + talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")));
                    mergePreviousTimeslot = talkList.isEmpty() ? null : timeslot;
                    mergeStart = this.currentColumnNumber;
                }
                if (mergePreviousTimeslot == null || mergeStart >= this.currentColumnNumber) continue;
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, 5120);
            }
        }

        private void writeSpeakersView() {
            this.nextSheet("Speakers view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Speaker unavailable timeslot", "Speaker conflict", "Speaker required timeslot tags", "Speaker prohibited timeslot tags", "Speaker preferred timeslot tags", "Speaker undesired timeslot tags", "Speaker required room tags", "Speaker prohibited room tags", "Speaker preferred room tags", "Speaker undesired room tags"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Speaker");
            this.writeTimeslotHoursHeaders();
            for (Speaker speaker : ((ConferenceSolution)this.solution).getSpeakerList()) {
                this.nextRow();
                this.nextCell().setCellValue(speaker.getName());
                List timeslotTalkList = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getSpeakerList().contains(speaker)).collect(Collectors.toList());
                Timeslot mergePreviousTimeslot = null;
                int mergeStart = -1;
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                    if (talkList.isEmpty() && mergePreviousTimeslot != null && timeslot.getStartDateTime().compareTo(mergePreviousTimeslot.getEndDateTime()) < 0) {
                        this.nextCell();
                        continue;
                    }
                    if (mergePreviousTimeslot != null && mergeStart < this.currentColumnNumber) {
                        this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                    }
                    boolean unavailable = speaker.getUnavailableTimeslotSet().contains(timeslot);
                    this.nextTalkListCell(unavailable, talkList, filteredConstraintNames);
                    mergePreviousTimeslot = talkList.isEmpty() ? null : timeslot;
                    mergeStart = this.currentColumnNumber;
                }
                if (mergePreviousTimeslot == null || mergeStart >= this.currentColumnNumber) continue;
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.headerCellCount; ++i) {
                this.currentSheet.setColumnWidth(i, 5120);
            }
        }

        private void writeThemeTracksView() {
            this.nextSheet("Theme tracks view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Theme track conflict", "Audience type theme track conflict", "Same day talks"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Theme track tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getThemeTrackTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeSectorsView() {
            this.nextSheet("Sectors view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Sector conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Sector tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getSectorTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeAudienceTypesView() {
            this.nextSheet("Audience types view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Audience type diversity", "Audience type theme track conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Audience type");
            this.writeTimeslotHoursHeaders();
            Map audienceTypeToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getAudienceTypeSet().stream().map(audienceType -> Pair.of((Object)audienceType, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : audienceTypeToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeAudienceLevelsView() {
            this.nextSheet("Audience levels view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Audience level diversity", "Content audience level flow violation"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Audience level");
            this.writeTimeslotHoursHeaders();
            Map levelToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).map(talk -> Pair.of((Object)talk.getAudienceLevel(), (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : levelToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(Integer.toString(entry.getKey()));
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeContentsView() {
            this.nextSheet("Contents view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Content audience level flow violation", "Content conflict"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Content tag");
            this.writeTimeslotHoursHeaders();
            Map tagToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).flatMap(talk -> talk.getContentTagSet().stream().map(tag -> Pair.of((Object)tag, (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk)))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : tagToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, (Talk talk) -> talk.getCode() + " (level " + talk.getAudienceLevel() + ")", filteredConstraintNames, justificationList -> justificationList.stream().allMatch(justification -> !(justification instanceof Talk) || ((Talk)justification).getContentTagSet().contains(entry.getKey())));
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeLanguagesView() {
            this.nextSheet("Languages view", 1, 2, true);
            String[] filteredConstraintNames = new String[]{"Language diversity"};
            this.nextRow();
            this.nextHeaderCell("");
            this.writeTimeslotDaysHeaders();
            this.nextRow();
            this.nextHeaderCell("Language");
            this.writeTimeslotHoursHeaders();
            Map languageToTimeslotToTalkListMap = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null).map(talk -> Pair.of((Object)talk.getLanguage(), (Object)Pair.of((Object)talk.getTimeslot(), (Object)talk))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.groupingBy(o -> (Timeslot)((Pair)o.getRight()).getLeft(), Collectors.mapping(o -> (Talk)((Pair)o.getRight()).getRight(), Collectors.toList()))));
            for (Map.Entry entry : languageToTimeslotToTalkListMap.entrySet()) {
                this.nextRow();
                this.nextHeaderCell(entry.getKey());
                Map timeslotToTalkListMap = entry.getValue();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    List<Talk> talkList = timeslotToTalkListMap.get(timeslot);
                    this.nextTalkListCell(talkList, filteredConstraintNames);
                }
            }
            this.autoSizeColumnsWithHeader();
        }

        private void writeDaysSheets() {
            List dayList = ((ConferenceSolution)this.solution).getTimeslotList().stream().map(Timeslot::getDate).distinct().collect(Collectors.toList());
            for (LocalDate day : dayList) {
                List<Timeslot> dayTimeslotList = ((ConferenceSolution)this.solution).getTimeslotList().stream().filter(timeslot -> timeslot.getDate().equals(day)).collect(Collectors.toList());
                List<Talk> dayTalkList = ((ConferenceSolution)this.solution).getTalkList().stream().filter(talk -> talk.getTimeslot() != null && talk.getTimeslot().getDate().equals(day)).collect(Collectors.toList());
                this.writeDaySheet(day, dayTimeslotList, dayTalkList);
            }
        }

        private void writeDaySheet(LocalDate day, List<Timeslot> timeslotList, List<Talk> talkList) {
            this.nextSheet(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(day), 1, 1, true);
            this.nextRow();
            this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(day));
            this.writeTimeslotHoursVertically(timeslotList);
            List dayRoomList = talkList.stream().map(Talk::getRoom).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Room::getName)).collect(Collectors.toList());
            for (Room room : dayRoomList) {
                ++this.currentColumnNumber;
                this.currentRowNumber = -1;
                this.nextCellVertically().setCellValue(room.getName());
                List<Talk> roomTalkList = talkList.stream().filter(talk -> talk.getRoom() == room).collect(Collectors.toList());
                this.writeRoomTalks(timeslotList, room, roomTalkList);
            }
            this.currentSheet.autoSizeColumn(0);
            for (int i = 1; i < this.currentSheet.getRow(0).getPhysicalNumberOfCells(); ++i) {
                this.currentSheet.setColumnWidth(i, 3840);
            }
        }

        private void writeRoomTalks(List<Timeslot> dayTimeslotList, Room room, List<Talk> roomTalkList) {
            Timeslot mergePreviousTimeslot = null;
            int mergeStart = -1;
            for (Timeslot timeslot : dayTimeslotList) {
                List<Talk> talkList = roomTalkList.stream().filter(talk -> talk.getTimeslot() == timeslot).collect(Collectors.toList());
                if (talkList.isEmpty() && mergePreviousTimeslot != null && timeslot.getStartDateTime().compareTo(mergePreviousTimeslot.getEndDateTime()) < 0) {
                    this.nextCellVertically();
                    continue;
                }
                if (mergePreviousTimeslot != null && mergeStart < this.currentRowNumber) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber));
                }
                boolean unavailable = room.getUnavailableTimeslotSet().contains(timeslot) || Collections.disjoint(room.getTalkTypeSet(), timeslot.getTalkTypeSet());
                this.nextTalkListCell(unavailable, talkList, talk -> StringUtils.abbreviate((String)talk.getTitle(), (int)50) + "\n" + StringUtils.abbreviate((String)talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", ")), (int)30), true);
                mergePreviousTimeslot = talkList.isEmpty() ? null : timeslot;
                mergeStart = this.currentRowNumber;
            }
            if (mergePreviousTimeslot != null && mergeStart < this.currentRowNumber) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(mergeStart, this.currentRowNumber, this.currentColumnNumber, this.currentColumnNumber));
            }
        }

        private void writeTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            int mergeStart = -1;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.nextHeaderCell("");
                    continue;
                }
                if (previousTimeslotDay != null) {
                    this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
                }
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
                mergeStart = this.currentColumnNumber;
            }
            if (previousTimeslotDay != null) {
                this.currentSheet.addMergedRegion(new CellRangeAddress(this.currentRowNumber, this.currentRowNumber, mergeStart, this.currentColumnNumber));
            }
        }

        private void writeTimeslotHoursHeaders() {
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.nextHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }

        private void writeTimeslotHoursVertically(List<Timeslot> dayTimeslotList) {
            for (Timeslot timeslot : dayTimeslotList) {
                this.nextRow();
                this.nextCell().setCellValue(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
                this.currentRow.setHeightInPoints(3.0f * this.currentSheet.getDefaultRowHeightInPoints());
            }
        }

        protected void nextTalkListCell(List<Talk> talkList, String[] filteredConstraintNames) {
            this.nextTalkListCell(false, talkList, filteredConstraintNames);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, String[] filteredConstraintNames) {
            this.nextTalkListCell(unavailable, talkList, talk -> talk.getCode() + " @ " + (talk.getRoom() == null ? "No room" : talk.getRoom().getName()), filteredConstraintNames, false, null);
        }

        protected void nextTalkListCell(List<Talk> talkList, Function<Talk, String> stringFunction, String[] filteredConstraintNames, Predicate<List<Object>> isValidJustificationList) {
            this.nextTalkListCell(false, talkList, stringFunction, filteredConstraintNames, false, isValidJustificationList);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction) {
            this.nextTalkListCell(unavailable, talkList, stringFunction, null, false, null);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction, boolean isVerticalView) {
            this.nextTalkListCell(unavailable, talkList, stringFunction, null, isVerticalView, null);
        }

        protected void nextTalkListCell(boolean unavailable, List<Talk> talkList, Function<Talk, String> stringFunction, String[] filteredConstraintNames, boolean isPrintedView, Predicate<List<Object>> isValidJustificationList) {
            List<String> filteredConstraintNameList;
            List<String> list = filteredConstraintNameList = filteredConstraintNames == null ? null : Arrays.asList(filteredConstraintNames);
            if (talkList == null) {
                talkList = Collections.emptyList();
            }
            HardMediumSoftScore score = talkList.stream().map(this.indictmentMap::get).filter(Objects::nonNull).flatMap(indictment -> indictment.getConstraintMatchSet().stream()).filter(constraintMatch -> filteredConstraintNameList == null || filteredConstraintNameList.contains(constraintMatch.getConstraintName())).filter(constraintMatch -> isValidJustificationList == null || isValidJustificationList.test(constraintMatch.getJustificationList())).map(constraintMatch -> (HardMediumSoftScore)constraintMatch.getScore()).filter(indictmentScore -> indictmentScore.getHardScore() < 0 || indictmentScore.getMediumScore() < 0 || indictmentScore.getSoftScore() < 0).reduce(Score::add).orElse(HardMediumSoftScore.ZERO);
            XSSFCell cell = isPrintedView ? this.nextCellVertically(talkList.isEmpty() || talkList.get(0).getThemeTrackTagSet().isEmpty() ? this.wrappedStyle : this.themeTrackToStyleMap.get(talkList.get(0).getThemeTrackTagSet().iterator().next())) : (talkList.stream().anyMatch(Talk::isPinnedByUser) ? this.nextCell(this.pinnedStyle) : (!score.isFeasible() ? this.nextCell(this.hardPenaltyStyle) : (unavailable ? this.nextCell(this.unavailableStyle) : (score.getMediumScore() < 0 ? this.nextCell(this.mediumPenaltyStyle) : (score.getSoftScore() < 0 ? this.nextCell(this.softPenaltyStyle) : this.nextCell(this.wrappedStyle))))));
            if (!talkList.isEmpty()) {
                ClientAnchor anchor = this.creationHelper.createClientAnchor();
                anchor.setCol1(cell.getColumnIndex());
                anchor.setCol2(cell.getColumnIndex() + 4);
                anchor.setRow1(this.currentRow.getRowNum());
                anchor.setRow2(this.currentRow.getRowNum() + 4);
                Comment comment = this.currentDrawing.createCellComment(anchor);
                StringBuilder commentString = new StringBuilder(talkList.size() * 200);
                for (Talk talk : talkList) {
                    commentString.append(talk.getCode()).append("-").append(String.join((CharSequence)", ", talk.getThemeTrackTagSet())).append(": ").append(talk.getTitle()).append("\n    ").append(talk.getSpeakerList().stream().map(Speaker::getName).collect(Collectors.joining(", "))).append(talk.isPinnedByUser() ? "\nPINNED BY USER" : "");
                    Indictment indictment2 = (Indictment)this.indictmentMap.get(talk);
                    if (indictment2 != null) {
                        commentString.append("\n").append(indictment2.getScore().toShortString()).append(" total");
                        Set constraintMatchSet = indictment2.getConstraintMatchSet().stream().filter(constraintMatch -> filteredConstraintNameList == null || filteredConstraintNameList.contains(constraintMatch.getConstraintName())).collect(Collectors.toSet());
                        List constraintNameList = constraintMatchSet.stream().map(ConstraintMatch::getConstraintName).distinct().collect(Collectors.toList());
                        for (String constraintName : constraintNameList) {
                            List filteredConstraintMatchList = constraintMatchSet.stream().filter(constraintMatch -> constraintMatch.getConstraintName().equals(constraintName) && (isValidJustificationList == null || isValidJustificationList.test(constraintMatch.getJustificationList()))).collect(Collectors.toList());
                            HardMediumSoftScore sum = filteredConstraintMatchList.stream().map(constraintMatch -> (HardMediumSoftScore)constraintMatch.getScore()).reduce(HardMediumSoftScore::add).orElse(HardMediumSoftScore.ZERO);
                            String justificationTalkCodes = filteredConstraintMatchList.stream().flatMap(constraintMatch -> constraintMatch.getJustificationList().stream()).filter(justification -> justification instanceof Talk && justification != talk).distinct().map(o -> ((Talk)o).getCode()).collect(Collectors.joining(", "));
                            commentString.append("\n    ").append(sum.toShortString()).append(" for ").append(filteredConstraintMatchList.size()).append(" ").append(constraintName).append("s").append("\n        ").append(justificationTalkCodes);
                        }
                    }
                    commentString.append("\n\n");
                }
                comment.setString(this.creationHelper.createRichTextString(commentString.toString()));
                cell.setCellComment(comment);
            }
            cell.setCellValue(talkList.stream().map(stringFunction).collect(Collectors.joining("\n")));
            this.currentRow.setHeightInPoints(Math.max(this.currentRow.getHeightInPoints(), (float)talkList.size() * this.currentSheet.getDefaultRowHeightInPoints()));
        }
    }

    private class ConferenceSchedulingXlsxReader
    extends AbstractXlsxSolutionFileIO.AbstractXlsxReader<ConferenceSolution> {
        private Map<String, TalkType> totalTalkTypeMap;
        private Set<String> totalTimeslotTagSet;
        private Set<String> totalRoomTagSet;
        private Map<String, Talk> totalTalkCodeMap;

        public ConferenceSchedulingXlsxReader(XSSFWorkbook workbook) {
            super(workbook, "org/optaplanner/examples/conferencescheduling/solver/conferenceSchedulingSolverConfig.xml");
        }

        @Override
        public ConferenceSolution read() {
            this.solution = new ConferenceSolution();
            this.totalTalkTypeMap = new HashMap<String, TalkType>();
            this.totalTimeslotTagSet = new HashSet<String>();
            this.totalRoomTagSet = new HashSet<String>();
            this.totalTalkCodeMap = new HashMap<String, Talk>();
            this.readConfiguration();
            this.readTimeslotList();
            this.readRoomList();
            this.readSpeakerList();
            this.readTalkList();
            ((ConferenceSolution)this.solution).getTimeslotList().sort(COMPARATOR);
            return (ConferenceSolution)this.solution;
        }

        private void readConfiguration() {
            this.nextSheet("Configuration");
            this.nextRow();
            this.readHeaderCell("Conference name");
            ((ConferenceSolution)this.solution).setConferenceName(this.nextStringCell().getStringCellValue());
            if (ConferenceSchedulingXlsxFileIO.this.strict && !VALID_NAME_PATTERN.matcher(((ConferenceSolution)this.solution).getConferenceName()).matches()) {
                throw new IllegalStateException(this.currentPosition() + ": The conference name (" + ((ConferenceSolution)this.solution).getConferenceName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
            }
            ConferenceConstraintConfiguration constraintConfiguration = new ConferenceConstraintConfiguration();
            this.readIntConstraintParameterLine("Minimum consecutive talks pause in minutes", constraintConfiguration::setMinimumConsecutiveTalksPauseInMinutes, "The amount of time a speaker needs between 2 talks");
            this.readScoreConstraintHeaders();
            constraintConfiguration.setId(0L);
            constraintConfiguration.setRoomUnavailableTimeslot((HardMediumSoftScore)this.readScoreConstraintLine("Room unavailable timeslot", ConferenceSchedulingXlsxFileIO.ROOM_UNAVAILABLE_TIMESLOT_DESCRIPTION));
            constraintConfiguration.setRoomConflict((HardMediumSoftScore)this.readScoreConstraintLine("Room conflict", ConferenceSchedulingXlsxFileIO.ROOM_CONFLICT_DESCRIPTION));
            constraintConfiguration.setSpeakerUnavailableTimeslot((HardMediumSoftScore)this.readScoreConstraintLine("Speaker unavailable timeslot", ConferenceSchedulingXlsxFileIO.SPEAKER_UNAVAILABLE_TIMESLOT_DESCRIPTION));
            constraintConfiguration.setSpeakerConflict((HardMediumSoftScore)this.readScoreConstraintLine("Speaker conflict", ConferenceSchedulingXlsxFileIO.SPEAKER_CONFLICT_DESCRIPTION));
            constraintConfiguration.setTalkPrerequisiteTalks((HardMediumSoftScore)this.readScoreConstraintLine("Talk prerequisite talks", ConferenceSchedulingXlsxFileIO.TALK_PREREQUISITE_TALKS_DESCRIPTION));
            constraintConfiguration.setTalkMutuallyExclusiveTalksTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk mutually-exclusive-talks tags", ConferenceSchedulingXlsxFileIO.TALK_MUTUALLY_EXCLUSIVE_TALKS_TAGS_DESCRIPTION));
            constraintConfiguration.setConsecutiveTalksPause((HardMediumSoftScore)this.readScoreConstraintLine("Consecutive talks pause", ConferenceSchedulingXlsxFileIO.CONSECUTIVE_TALKS_PAUSE_DESCRIPTION));
            constraintConfiguration.setCrowdControl((HardMediumSoftScore)this.readScoreConstraintLine("Crowd control", ConferenceSchedulingXlsxFileIO.CROWD_CONTROL_DESCRIPTION));
            constraintConfiguration.setSpeakerRequiredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker required timeslot tags", "Penalty per missing required tag in a talk's timeslot, per minute"));
            constraintConfiguration.setSpeakerProhibitedTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker prohibited timeslot tags", "Penalty per prohibited tag in a talk's timeslot, per minute"));
            constraintConfiguration.setTalkRequiredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk required timeslot tags", "Penalty per missing required tag in a talk's timeslot, per minute"));
            constraintConfiguration.setTalkProhibitedTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk prohibited timeslot tags", "Penalty per prohibited tag in a talk's timeslot, per minute"));
            constraintConfiguration.setSpeakerRequiredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker required room tags", "Penalty per missing required tag in a talk's room, per minute"));
            constraintConfiguration.setSpeakerProhibitedRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker prohibited room tags", "Penalty per prohibited tag in a talk's room, per minute"));
            constraintConfiguration.setTalkRequiredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk required room tags", "Penalty per missing required tag in a talk's room, per minute"));
            constraintConfiguration.setTalkProhibitedRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk prohibited room tags", "Penalty per prohibited tag in a talk's room, per minute"));
            constraintConfiguration.setPublishedTimeslot((HardMediumSoftScore)this.readScoreConstraintLine("Published timeslot", ConferenceSchedulingXlsxFileIO.PUBLISHED_TIMESLOT_DESCRIPTION));
            constraintConfiguration.setPublishedRoom((HardMediumSoftScore)this.readScoreConstraintLine("Published room", ConferenceSchedulingXlsxFileIO.PUBLISHED_ROOM_DESCRIPTION));
            constraintConfiguration.setThemeTrackConflict((HardMediumSoftScore)this.readScoreConstraintLine("Theme track conflict", ConferenceSchedulingXlsxFileIO.THEME_TRACK_CONFLICT_DESCRIPTION));
            constraintConfiguration.setThemeTrackRoomStability((HardMediumSoftScore)this.readScoreConstraintLine("Theme track room stability", ConferenceSchedulingXlsxFileIO.THEME_TRACK_ROOM_STABILITY_DESCRIPTION));
            constraintConfiguration.setSectorConflict((HardMediumSoftScore)this.readScoreConstraintLine("Sector conflict", ConferenceSchedulingXlsxFileIO.SECTOR_CONFLICT_DESCRIPTION));
            constraintConfiguration.setAudienceTypeDiversity((HardMediumSoftScore)this.readScoreConstraintLine("Audience type diversity", ConferenceSchedulingXlsxFileIO.AUDIENCE_TYPE_DIVERSITY_DESCRIPTION));
            constraintConfiguration.setAudienceTypeThemeTrackConflict((HardMediumSoftScore)this.readScoreConstraintLine("Audience type theme track conflict", ConferenceSchedulingXlsxFileIO.AUDIENCE_TYPE_THEME_TRACK_CONFLICT_DESCRIPTION));
            constraintConfiguration.setAudienceLevelDiversity((HardMediumSoftScore)this.readScoreConstraintLine("Audience level diversity", ConferenceSchedulingXlsxFileIO.AUDIENCE_LEVEL_DIVERSITY_DESCRIPTION));
            constraintConfiguration.setContentAudienceLevelFlowViolation((HardMediumSoftScore)this.readScoreConstraintLine("Content audience level flow violation", ConferenceSchedulingXlsxFileIO.CONTENT_AUDIENCE_LEVEL_FLOW_VIOLATION_DESCRIPTION));
            constraintConfiguration.setContentConflict((HardMediumSoftScore)this.readScoreConstraintLine("Content conflict", ConferenceSchedulingXlsxFileIO.CONTENT_CONFLICT_DESCRIPTION));
            constraintConfiguration.setLanguageDiversity((HardMediumSoftScore)this.readScoreConstraintLine("Language diversity", ConferenceSchedulingXlsxFileIO.LANGUAGE_DIVERSITY_DESCRIPTION));
            constraintConfiguration.setSameDayTalks((HardMediumSoftScore)this.readScoreConstraintLine("Same day talks", ConferenceSchedulingXlsxFileIO.SAME_DAY_TALKS_DESCRIPTION));
            constraintConfiguration.setPopularTalks((HardMediumSoftScore)this.readScoreConstraintLine("Popular talks", ConferenceSchedulingXlsxFileIO.POPULAR_TALKS_DESCRIPTION));
            constraintConfiguration.setSpeakerPreferredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker preferred timeslot tags", "Penalty per missing preferred tag in a talk's timeslot, per minute"));
            constraintConfiguration.setSpeakerUndesiredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker undesired timeslot tags", "Penalty per undesired tag in a talk's timeslot, per minute"));
            constraintConfiguration.setTalkPreferredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk preferred timeslot tags", "Penalty per missing preferred tag in a talk's timeslot, per minute"));
            constraintConfiguration.setTalkUndesiredTimeslotTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk undesired timeslot tags", "Penalty per undesired tag in a talk's timeslot, per minute"));
            constraintConfiguration.setSpeakerPreferredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker preferred room tags", "Penalty per missing preferred tag in a talk's room, per minute"));
            constraintConfiguration.setSpeakerUndesiredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Speaker undesired room tags", "Penalty per undesired tag in a talk's room, per minute"));
            constraintConfiguration.setTalkPreferredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk preferred room tags", "Penalty per missing preferred tag in a talk's room, per minute"));
            constraintConfiguration.setTalkUndesiredRoomTags((HardMediumSoftScore)this.readScoreConstraintLine("Talk undesired room tags", "Penalty per undesired tag in a talk's room, per minute"));
            ((ConferenceSolution)this.solution).setConstraintConfiguration(constraintConfiguration);
        }

        private void readTimeslotList() {
            this.nextSheet("Timeslots");
            this.nextRow(false);
            this.readHeaderCell("Day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Talk types");
            this.readHeaderCell("Tags");
            ArrayList<TalkType> talkTypeList = new ArrayList<TalkType>();
            ArrayList<Timeslot> timeslotList = new ArrayList<Timeslot>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            long talkTypeId = 0L;
            while (this.nextRow()) {
                Timeslot timeslot = new Timeslot();
                timeslot.setId(id++);
                LocalDate day = LocalDate.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.DAY_FORMATTER);
                LocalTime startTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                LocalTime endTime = LocalTime.parse(this.nextStringCell().getStringCellValue(), AbstractXlsxSolutionFileIO.TIME_FORMATTER);
                if (startTime.compareTo(endTime) >= 0) {
                    throw new IllegalStateException(this.currentPosition() + ": The startTime (" + startTime + ") must be less than the endTime (" + endTime + ").");
                }
                timeslot.setStartDateTime(LocalDateTime.of(day, startTime));
                timeslot.setEndDateTime(LocalDateTime.of(day, endTime));
                String[] talkTypeNames = this.nextStringCell().getStringCellValue().split(", ");
                LinkedHashSet<TalkType> talkTypeSet = new LinkedHashSet<TalkType>(talkTypeNames.length);
                for (String talkTypeName : talkTypeNames) {
                    TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                    if (talkType == null) {
                        talkType = new TalkType(talkTypeId);
                        ++talkTypeId;
                        if (ConferenceSchedulingXlsxFileIO.this.strict && !VALID_TAG_PATTERN.matcher(talkTypeName).matches()) {
                            throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s talkType (" + talkTypeName + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                        }
                        talkType.setName(talkTypeName);
                        talkType.setCompatibleTimeslotSet(new LinkedHashSet<Timeslot>());
                        talkType.setCompatibleRoomSet(new LinkedHashSet<Room>());
                        this.totalTalkTypeMap.put(talkTypeName, talkType);
                        talkTypeList.add(talkType);
                    }
                    talkTypeSet.add(talkType);
                    talkType.getCompatibleTimeslotSet().add(timeslot);
                }
                if (talkTypeSet.isEmpty()) {
                    throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s talk types (" + timeslot.getTalkTypeSet() + ") must not be empty.");
                }
                timeslot.setTalkTypeSet(talkTypeSet);
                timeslot.setTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : timeslot.getTagSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The timeslot (" + timeslot + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalTimeslotTagSet.addAll(timeslot.getTagSet());
                timeslotList.add(timeslot);
            }
            ((ConferenceSolution)this.solution).setTimeslotList(timeslotList);
            ((ConferenceSolution)this.solution).setTalkTypeList(talkTypeList);
        }

        private void readRoomList() {
            this.nextSheet("Rooms");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Capacity");
            this.readHeaderCell("Talk types");
            this.readHeaderCell("Tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Room> roomList = new ArrayList<Room>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                LinkedHashSet<TalkType> talkTypeSet;
                Room room = new Room();
                room.setId(id++);
                room.setName(this.nextStringCell().getStringCellValue());
                if (ConferenceSchedulingXlsxFileIO.this.strict && !VALID_NAME_PATTERN.matcher(room.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The room name (" + room.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                room.setCapacity(this.getNextStrictlyPositiveIntegerCell("room name (" + room.getName(), "capacity"));
                String[] talkTypeNames = this.nextStringCell().getStringCellValue().split(", ");
                if (talkTypeNames.length == 0 || talkTypeNames.length == 1 && talkTypeNames[0].isEmpty()) {
                    talkTypeSet = new LinkedHashSet<TalkType>(this.totalTalkTypeMap.values());
                    for (TalkType talkType : talkTypeSet) {
                        talkType.getCompatibleRoomSet().add(room);
                    }
                } else {
                    talkTypeSet = new LinkedHashSet(talkTypeNames.length);
                    for (String talkTypeName : talkTypeNames) {
                        TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                        if (talkType == null) {
                            throw new IllegalStateException(this.currentPosition() + ": The room (" + room + ")'s talkType (" + talkTypeName + ") does not exist in the talk types (" + this.totalTalkTypeMap.keySet() + ") of the other sheet (Timeslots).");
                        }
                        talkTypeSet.add(talkType);
                        talkType.getCompatibleRoomSet().add(room);
                    }
                }
                room.setTalkTypeSet(talkTypeSet);
                room.setTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : room.getTagSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The room (" + room + ")'s tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                this.totalRoomTagSet.addAll(room.getTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    XSSFCell cell = this.nextStringCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the talks sheet pre-assign rooms and timeslots.");
                }
                room.setUnavailableTimeslotSet(unavailableTimeslotSet);
                roomList.add(room);
            }
            ((ConferenceSolution)this.solution).setRoomList(roomList);
        }

        private void readSpeakerList() {
            this.nextSheet("Speakers");
            this.nextRow(false);
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readHeaderCell("");
            this.readTimeslotDaysHeaders();
            this.nextRow(false);
            this.readHeaderCell("Name");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readTimeslotHoursHeaders();
            ArrayList<Speaker> speakerList = new ArrayList<Speaker>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            while (this.nextRow()) {
                Speaker speaker = new Speaker();
                speaker.setId(id++);
                speaker.setName(this.nextStringCell().getStringCellValue());
                if (ConferenceSchedulingXlsxFileIO.this.strict && !VALID_NAME_PATTERN.matcher(speaker.getName()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The speaker name (" + speaker.getName() + ") must match to the regular expression (" + VALID_NAME_PATTERN + ").");
                }
                speaker.setRequiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getRequiredTimeslotTagSet());
                speaker.setPreferredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getPreferredTimeslotTagSet());
                speaker.setProhibitedTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getProhibitedTimeslotTagSet());
                speaker.setUndesiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(speaker.getUndesiredTimeslotTagSet());
                speaker.setRequiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getRequiredRoomTagSet());
                speaker.setPreferredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getPreferredRoomTagSet());
                speaker.setProhibitedRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getProhibitedRoomTagSet());
                speaker.setUndesiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(speaker.getUndesiredRoomTagSet());
                LinkedHashSet<Timeslot> unavailableTimeslotSet = new LinkedHashSet<Timeslot>();
                for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                    XSSFCell cell = this.nextStringCell();
                    if (Objects.equals(this.extractColor(cell, UNAVAILABLE_COLOR), UNAVAILABLE_COLOR)) {
                        unavailableTimeslotSet.add(timeslot);
                    }
                    if (cell.getStringCellValue().isEmpty()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The cell (" + cell.getStringCellValue() + ") should be empty. Use the other sheet (Talks) to pre-assign rooms and timeslots.");
                }
                speaker.setUnavailableTimeslotSet(unavailableTimeslotSet);
                speakerList.add(speaker);
            }
            ((ConferenceSolution)this.solution).setSpeakerList(speakerList);
        }

        private void readTalkList() {
            Map<String, Speaker> speakerMap = ((ConferenceSolution)this.solution).getSpeakerList().stream().collect(Collectors.toMap(Speaker::getName, speaker -> speaker));
            this.nextSheet("Talks");
            this.nextRow(false);
            this.readHeaderCell("Code");
            this.readHeaderCell("Title");
            this.readHeaderCell("Talk type");
            this.readHeaderCell("Speakers");
            this.readHeaderCell("Theme track tags");
            this.readHeaderCell("Sector tags");
            this.readHeaderCell("Audience types");
            this.readHeaderCell("Audience level");
            this.readHeaderCell("Content tags");
            this.readHeaderCell("Language");
            this.readHeaderCell("Required timeslot tags");
            this.readHeaderCell("Preferred timeslot tags");
            this.readHeaderCell("Prohibited timeslot tags");
            this.readHeaderCell("Undesired timeslot tags");
            this.readHeaderCell("Required room tags");
            this.readHeaderCell("Preferred room tags");
            this.readHeaderCell("Prohibited room tags");
            this.readHeaderCell("Undesired room tags");
            this.readHeaderCell("Mutually exclusive talks tags");
            this.readHeaderCell("Prerequisite talks codes");
            this.readHeaderCell("Favorite count");
            this.readHeaderCell("Crowd control risk");
            this.readHeaderCell("Pinned by user");
            this.readHeaderCell("Timeslot day");
            this.readHeaderCell("Start");
            this.readHeaderCell("End");
            this.readHeaderCell("Room");
            this.readHeaderCell("Published Timeslot");
            this.readHeaderCell("Published Start");
            this.readHeaderCell("Published End");
            this.readHeaderCell("Published Room");
            ArrayList<Talk> talkList = new ArrayList<Talk>(this.currentSheet.getLastRowNum() - 1);
            long id = 0L;
            Map<Pair<LocalDateTime, LocalDateTime>, Timeslot> timeslotMap = ((ConferenceSolution)this.solution).getTimeslotList().stream().collect(Collectors.toMap(timeslot -> Pair.of((Object)timeslot.getStartDateTime(), (Object)timeslot.getEndDateTime()), Function.identity()));
            Map<String, Room> roomMap = ((ConferenceSolution)this.solution).getRoomList().stream().collect(Collectors.toMap(Room::getName, Function.identity()));
            HashMap<Talk, Set<String>> talkToPrerequisiteTalkSetMap = new HashMap<Talk, Set<String>>();
            while (this.nextRow()) {
                Talk talk = new Talk();
                talk.setId(id++);
                talk.setCode(this.nextStringCell().getStringCellValue());
                this.totalTalkCodeMap.put(talk.getCode(), talk);
                if (ConferenceSchedulingXlsxFileIO.this.strict && !VALID_CODE_PATTERN.matcher(talk.getCode()).matches()) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk code (" + talk.getCode() + ") must match to the regular expression (" + VALID_CODE_PATTERN + ").");
                }
                talk.setTitle(this.nextStringCell().getStringCellValue());
                String talkTypeName = this.nextStringCell().getStringCellValue();
                TalkType talkType = this.totalTalkTypeMap.get(talkTypeName);
                if (talkType == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s talkType (" + talkTypeName + ") does not exist in the talk types (" + this.totalTalkTypeMap.keySet() + ") of the other sheet (Timeslots).");
                }
                talk.setTalkType(talkType);
                talk.setSpeakerList(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).map(speakerName -> {
                    Speaker speaker = (Speaker)speakerMap.get(speakerName);
                    if (speaker == null) {
                        throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a speaker (" + speakerName + ") that doesn't exist in the speaker list.");
                    }
                    return speaker;
                }).collect(Collectors.toList()));
                talk.setThemeTrackTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getThemeTrackTagSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s theme tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setSectorTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getSectorTagSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s sector tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setAudienceTypeSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String audienceType : talk.getAudienceTypeSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(audienceType).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s audience type (" + audienceType + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setAudienceLevel(this.getNextStrictlyPositiveIntegerCell("talk with code (" + talk.getCode(), "an audience level"));
                talk.setContentTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                for (String tag2 : talk.getContentTagSet()) {
                    if (!ConferenceSchedulingXlsxFileIO.this.strict || VALID_TAG_PATTERN.matcher(tag2).matches()) continue;
                    throw new IllegalStateException(this.currentPosition() + ": The talk (" + talk + ")'s content tag (" + tag2 + ") must match to the regular expression (" + VALID_TAG_PATTERN + ").");
                }
                talk.setLanguage(this.nextStringCell().getStringCellValue());
                talk.setRequiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getRequiredTimeslotTagSet());
                talk.setPreferredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getPreferredTimeslotTagSet());
                talk.setProhibitedTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getProhibitedTimeslotTagSet());
                talk.setUndesiredTimeslotTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyTimeslotTags(talk.getUndesiredTimeslotTagSet());
                talk.setRequiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getRequiredRoomTagSet());
                talk.setPreferredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getPreferredRoomTagSet());
                talk.setProhibitedRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getProhibitedRoomTagSet());
                talk.setUndesiredRoomTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.verifyRoomTags(talk.getUndesiredRoomTagSet());
                talk.setMutuallyExclusiveTalksTagSet(Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                talkToPrerequisiteTalkSetMap.put(talk, Arrays.stream(this.nextStringCell().getStringCellValue().split(", ")).filter(tag -> !tag.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new)));
                talk.setFavoriteCount(this.getNextPositiveIntegerCell("talk with code (" + talk.getCode(), "a Favorite count"));
                talk.setCrowdControlRisk(this.getNextPositiveIntegerCell("talk with code (" + talk.getCode(), "a crowd control risk"));
                talk.setPinnedByUser(this.nextBooleanCell().getBooleanCellValue());
                talk.setTimeslot(this.extractTimeslot(timeslotMap, talk));
                talk.setRoom(this.extractRoom(roomMap, talk));
                talk.setPublishedTimeslot(this.extractTimeslot(timeslotMap, talk));
                talk.setPublishedRoom(this.extractRoom(roomMap, talk));
                talkList.add(talk);
            }
            this.setPrerequisiteTalkSets(talkToPrerequisiteTalkSetMap);
            ((ConferenceSolution)this.solution).setTalkList(talkList);
        }

        private Timeslot extractTimeslot(Map<Pair<LocalDateTime, LocalDateTime>, Timeslot> timeslotMap, Talk talk) {
            String dateString = this.nextStringCell().getStringCellValue();
            String startTimeString = this.nextStringCell().getStringCellValue();
            String endTimeString = this.nextStringCell().getStringCellValue();
            if (!(dateString.isEmpty() && startTimeString.isEmpty() && endTimeString.isEmpty())) {
                LocalDateTime endDateTime;
                LocalDateTime startDateTime;
                try {
                    startDateTime = LocalDateTime.of(LocalDate.parse(dateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER), LocalTime.parse(startTimeString, AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                    endDateTime = LocalDateTime.of(LocalDate.parse(dateString, AbstractXlsxSolutionFileIO.DAY_FORMATTER), LocalTime.parse(endTimeString, AbstractXlsxSolutionFileIO.TIME_FORMATTER));
                }
                catch (DateTimeParseException e) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't parse as a date or time.", e);
                }
                Timeslot assignedTimeslot = timeslotMap.get(Pair.of((Object)startDateTime, (Object)endDateTime));
                if (assignedTimeslot == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a timeslot date (" + dateString + "), startTime (" + startTimeString + ") and endTime (" + endTimeString + ") that doesn't exist in the other sheet (Timeslots).");
                }
                return assignedTimeslot;
            }
            return null;
        }

        private Room extractRoom(Map<String, Room> roomMap, Talk talk) {
            String roomName = this.nextStringCell().getStringCellValue();
            if (!roomName.isEmpty()) {
                Room room = roomMap.get(roomName);
                if (room == null) {
                    throw new IllegalStateException(this.currentPosition() + ": The talk with code (" + talk.getCode() + ") has a roomName (" + roomName + ") that doesn't exist in the other sheet (Rooms).");
                }
                return room;
            }
            return null;
        }

        private int getNextStrictlyPositiveIntegerCell(String classSpecifier, String columnName) {
            double cellValueDouble = this.nextNumericCell().getNumericCellValue();
            if (ConferenceSchedulingXlsxFileIO.this.strict && (cellValueDouble <= 0.0 || cellValueDouble != Math.floor(cellValueDouble))) {
                throw new IllegalStateException(this.currentPosition() + ": The" + classSpecifier + ")'s has " + columnName + " (" + cellValueDouble + ") that isn't a strictly positive integer number.");
            }
            return (int)cellValueDouble;
        }

        private int getNextPositiveIntegerCell(String classSpecifier, String columnName) {
            double cellValueDouble = this.nextNumericCell().getNumericCellValue();
            if (ConferenceSchedulingXlsxFileIO.this.strict && (cellValueDouble < 0.0 || cellValueDouble != Math.floor(cellValueDouble))) {
                throw new IllegalStateException(this.currentPosition() + ": The " + classSpecifier + ")'s has " + columnName + " (" + cellValueDouble + ") that isn't a positive integer number.");
            }
            return (int)cellValueDouble;
        }

        private void verifyTimeslotTags(Set<String> timeslotTagSet) {
            for (String tag : timeslotTagSet) {
                if (this.totalTimeslotTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The timeslot tag (" + tag + ") does not exist in the tags (" + this.totalTimeslotTagSet + ") of the other sheet (Timeslots).");
            }
        }

        private void verifyRoomTags(Set<String> roomTagSet) {
            for (String tag : roomTagSet) {
                if (this.totalRoomTagSet.contains(tag)) continue;
                throw new IllegalStateException(this.currentPosition() + ": The room tag (" + tag + ") does not exist in the tags (" + this.totalRoomTagSet + ") of the other sheet (Rooms).");
            }
        }

        private void setPrerequisiteTalkSets(Map<Talk, Set<String>> talkToPrerequisiteTalkSetMap) {
            for (Map.Entry<Talk, Set<String>> entry : talkToPrerequisiteTalkSetMap.entrySet()) {
                Talk currentTalk = entry.getKey();
                HashSet<Talk> prerequisiteTalkSet = new HashSet<Talk>();
                for (String prerequisiteTalkCode : entry.getValue()) {
                    Talk prerequisiteTalk = this.totalTalkCodeMap.get(prerequisiteTalkCode);
                    if (prerequisiteTalk == null) {
                        throw new IllegalStateException("The talk (" + currentTalk.getCode() + ") has a prerequisite talk (" + prerequisiteTalkCode + ") that doesn't exist in the talk list.");
                    }
                    prerequisiteTalkSet.add(prerequisiteTalk);
                }
                currentTalk.setPrerequisiteTalkSet(prerequisiteTalkSet);
            }
        }

        private void readTimeslotDaysHeaders() {
            LocalDate previousTimeslotDay = null;
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                LocalDate timeslotDay = timeslot.getDate();
                if (timeslotDay.equals(previousTimeslotDay)) {
                    this.readHeaderCell("");
                    continue;
                }
                this.readHeaderCell(AbstractXlsxSolutionFileIO.DAY_FORMATTER.format(timeslotDay));
                previousTimeslotDay = timeslotDay;
            }
        }

        private void readTimeslotHoursHeaders() {
            for (Timeslot timeslot : ((ConferenceSolution)this.solution).getTimeslotList()) {
                this.readHeaderCell(AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getStartDateTime()) + "-" + AbstractXlsxSolutionFileIO.TIME_FORMATTER.format(timeslot.getEndDateTime()));
            }
        }
    }
}

