/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.provider;

import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;

public interface ModelImplementationProvider<T extends Model, E extends KiePMMLModel> {
    public PMML_MODEL getPMMLModelType();

    public E getKiePMMLModel(String var1, DataDictionary var2, TransformationDictionary var3, T var4, HasClassLoader var5);

    public E getKiePMMLModelWithSources(String var1, DataDictionary var2, TransformationDictionary var3, T var4, HasClassLoader var5);

    default public E getKiePMMLModelWithSourcesCompiled(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        E toReturn = this.getKiePMMLModelWithSources(packageName, dataDictionary, transformationDictionary, model, hasClassloader);
        Map sourcesMap = ((HasSourcesMap)toReturn).getSourcesMap();
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        String fullClassName = packageName + "." + className;
        try {
            hasClassloader.compileAndLoadClass(sourcesMap, fullClassName);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
        return toReturn;
    }
}

