/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.util;

import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.CommandExecutor;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.impl.KieContainerInstanceImpl;

public class KieServerUtils {
    private static final String SNAPSHOT = "-SNAPSHOT";

    public static boolean isSnapshot(ReleaseId releaseId) {
        return KieServerUtils.isSnapshot(releaseId.getVersion());
    }

    public static boolean isSnapshot(org.kie.api.builder.ReleaseId releaseId) {
        return KieServerUtils.isSnapshot(releaseId.getVersion());
    }

    public static boolean isSnapshot(String version) {
        return version.toUpperCase().endsWith(SNAPSHOT);
    }

    public static CommandExecutor getDefaultKieSession(KieContainerInstanceImpl kci) {
        KieProject kieProject = ((KieContainerImpl)kci.getKieContainer()).getKieProject();
        KieSessionModel defaultStatefulModel = kieProject.getDefaultKieSession();
        KieSessionModel defaultStatelessModel = kieProject.getDefaultStatelessKieSession();
        if (defaultStatefulModel != null) {
            return kci.getKieContainer().getKieSession();
        }
        if (defaultStatelessModel != null) {
            return kci.getKieContainer().getStatelessKieSession();
        }
        throw new IllegalStateException("No default KieSession found on container '" + kci.getContainerId() + "'.");
    }
}

