/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLApplyFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLConstantFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldRefFactory;

public class KiePMMLExpressionFactory {
    private static final String EXPRESSION_NOT_MANAGED = "Expression %s not managed";

    private KiePMMLExpressionFactory() {
    }

    public static BlockStmt getKiePMMLExpression(String variableName, Expression expression) {
        if (expression instanceof Apply) {
            return KiePMMLApplyFactory.getApplyVariableDeclaration(variableName, (Apply)expression);
        }
        if (expression instanceof Constant) {
            return KiePMMLConstantFactory.getConstantVariableDeclaration(variableName, (Constant)expression);
        }
        if (expression instanceof FieldRef) {
            return KiePMMLFieldRefFactory.getFieldRefVariableDeclaration(variableName, (FieldRef)expression);
        }
        throw new IllegalArgumentException(String.format(EXPRESSION_NOT_MANAGED, expression.getClass()));
    }
}

