/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.ConverterTypeUtil;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class ExpressionFunctionUtils {
    public static final String APPLY_VARIABLE = "applyVariable";
    public static final String CONSTANT_VALUE = "constantValue";
    public static final String INPUT_DATA = "inputData";
    public static final String KIEPMMLNAMEVALUE = "kiePMMLNameValue";
    public static final String FIELDREFVARIABLE = "fieldRefVariable";
    public static final String KEYREFVARIABLE = "keyRefVariable";
    public static final String MISSINGFIELDREFVARIABLE = "missingFieldRefVariable";
    static final String EXPRESSION_FUNCTION_UTILS_TEMPLATE_JAVA = "ExpressionFunctionUtilsTemplate.tmpl";
    static final String EXPRESSION_FUNCTION_UTILS_TEMPLATE = "ExpressionFunctionUtilsTemplate";
    static final ClassOrInterfaceDeclaration EXPRESSION_TEMPLATE;
    static final String KIEPMMLNAMEVALUE_LIST_PARAM = "param1";
    static final String INNER_VARIABLE_NAME = "variable%s%s%s";
    static final LinkedHashMap<String, ClassOrInterfaceType> DEFAULT_PARAMETERTYPE_MAP;
    static final FieldAccessExpr CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR;
    private static final String APPLYEXPRESSIONBUILTINFUNCTIONINVOCATION = "applyExpressionBuiltinFunctionInvocation";
    private static final String APPLYEXPRESSIONLOCALMETHODINVOCATION = "applyExpressionLocalMethodInvocation";
    private static final String FIELDREFEXPRESSIONFROMKIEPMMLNAMEVALUESTEMPLATE = "fieldRefExpressionFromKiePMMLNameValuesTemplate";
    private static final String FIELDREFEXPRESSIONFROMSTRINGOBJECTMAPTEMPLATE = "fieldRefExpressionFromStringObjectMapTemplate";
    private static final String FIELDREFEXPRESSIONFROMINPUTVALUETEMPLATE = "fieldRefExpressionFromInputValueTemplate";
    private static final String CONSTANTEXPRESSIONTEMPLATE = "constantExpressionTemplate";
    private static final String METHODDECLARATIONKIEPMMLNAMEVALUETEMPLATE = "methodDeclarationKiePMMLNameValueTemplate";
    private static final String METHODDECLARATIONSTRINGOBJECTMAPTEMPLATE = "methodDeclarationStringObjectMapTemplate";
    private static final String EXPRESSION_NOT_MANAGED = "Expression %s not managed";

    private ExpressionFunctionUtils() {
    }

    public static MethodDeclaration getExpressionMethodDeclarationWithStringObjectMap(Expression expression, DataType dataType, String methodName) {
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName(dataType));
        if (expression instanceof Aggregate) {
            return ExpressionFunctionUtils.getAggregatedExpressionMethodDeclaration(methodName, (Aggregate)expression, returnedType, null);
        }
        if (expression instanceof Apply) {
            return ExpressionFunctionUtils.getApplyExpressionMethodDeclarationStringObjectMap(methodName, (Apply)expression, returnedType);
        }
        if (expression instanceof Constant) {
            return ExpressionFunctionUtils.getConstantExpressionMethodDeclaration(methodName, (Constant)expression, returnedType, null);
        }
        if (expression instanceof Discretize) {
            return ExpressionFunctionUtils.getDiscretizeExpressionMethodDeclaration(methodName, (Discretize)expression, returnedType, null);
        }
        if (expression instanceof FieldRef) {
            return ExpressionFunctionUtils.getFieldRefExpressionMethodDeclarationWithStringObjectMap(methodName, (FieldRef)expression, returnedType);
        }
        if (expression instanceof Lag) {
            return ExpressionFunctionUtils.getLagExpressionMethodDeclaration(methodName, (Lag)expression, returnedType, null);
        }
        if (expression instanceof MapValues) {
            return ExpressionFunctionUtils.getMapValuesExpressionMethodDeclaration(methodName, (MapValues)expression, returnedType, null);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionFunctionUtils.getNormContinuousExpressionMethodDeclaration(methodName, (NormContinuous)expression, returnedType, null);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionFunctionUtils.getNormDiscreteExpressionMethodDeclaration(methodName, (NormDiscrete)expression, returnedType, null);
        }
        if (expression instanceof TextIndex) {
            return ExpressionFunctionUtils.getTextIndexExpressionMethodDeclaration(methodName, (TextIndex)expression, returnedType, null);
        }
        throw new IllegalArgumentException(String.format(EXPRESSION_NOT_MANAGED, expression.getClass()));
    }

    static MethodDeclaration getApplyExpressionMethodDeclarationStringObjectMap(String methodName, Apply apply, ClassOrInterfaceType returnedType) {
        String variableName = APPLY_VARIABLE;
        BlockStmt body = ExpressionFunctionUtils.getApplyExpressionBlockStmtWithStringObjectMap(variableName, apply, returnedType);
        return ExpressionFunctionUtils.getExpressionMethodDeclarationWithStringObjectMap(methodName, variableName, body, returnedType);
    }

    static MethodDeclaration getConstantExpressionMethodDeclaration(String methodName, Constant constant, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt body = ExpressionFunctionUtils.getConstantExpressionBlockStmt(CONSTANT_VALUE, constant, returnedType);
        return ExpressionFunctionUtils.getExpressionMethodDeclarationWithKiePMMLValues(methodName, CONSTANT_VALUE, body, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getFieldRefExpressionMethodDeclarationWithStringObjectMap(String methodName, FieldRef fieldRef, ClassOrInterfaceType returnedType) {
        String variableName = FIELDREFVARIABLE;
        BlockStmt body = ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithStringObjectMap(variableName, fieldRef, returnedType);
        return ExpressionFunctionUtils.getExpressionMethodDeclarationWithStringObjectMap(methodName, variableName, body, returnedType);
    }

    static MethodDeclaration getAggregatedExpressionMethodDeclaration(String methodName, Aggregate aggregate, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getDiscretizeExpressionMethodDeclaration(String methodName, Discretize discretize, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getLagExpressionMethodDeclaration(String methodName, Lag lag, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesExpressionMethodDeclaration(String methodName, MapValues mapValues, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousExpressionMethodDeclaration(String methodName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteExpressionMethodDeclaration(String methodName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexExpressionMethodDeclaration(String methodName, TextIndex textIndex, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static BlockStmt getExpressionBlockStmtWithKiePMMLValues(String variableName, Expression expression, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        if (expression instanceof Aggregate) {
            return ExpressionFunctionUtils.getAggregatedExpressionBlockStmt(variableName, (Aggregate)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Apply) {
            return ExpressionFunctionUtils.getApplyExpressionBlockStmtWithKiePMMLValues(variableName, (Apply)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof Constant) {
            return ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, (Constant)expression, returnedType);
        }
        if (expression instanceof Discretize) {
            return ExpressionFunctionUtils.getDiscretizeExpressionBlockStmt(variableName, (Discretize)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof FieldRef) {
            if (parameterNameTypeMap.size() == 1) {
                return ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithKiePMMLValues(variableName, (FieldRef)expression, returnedType);
            }
            return ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithInputValue(variableName, (FieldRef)expression, returnedType);
        }
        if (expression instanceof Lag) {
            return ExpressionFunctionUtils.getLagExpressionBlockStmt(variableName, (Lag)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof MapValues) {
            return ExpressionFunctionUtils.getMapValuesExpressionBlockStmt(variableName, (MapValues)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionFunctionUtils.getNormContinuousExpressionBlockStmt(variableName, (NormContinuous)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionFunctionUtils.getNormDiscreteExpressionBlockStmt(variableName, (NormDiscrete)expression, returnedType, parameterNameTypeMap);
        }
        if (expression instanceof TextIndex) {
            return ExpressionFunctionUtils.getTextIndexExpressionBlockStmt(variableName, (TextIndex)expression, returnedType, parameterNameTypeMap);
        }
        throw new IllegalArgumentException(String.format(EXPRESSION_NOT_MANAGED, expression.getClass()));
    }

    static BlockStmt getExpressionBlockStmtWithStringObjectMap(String variableName, Expression expression, ClassOrInterfaceType returnedType) {
        if (expression instanceof Aggregate) {
            return ExpressionFunctionUtils.getAggregatedExpressionBlockStmt(variableName, (Aggregate)expression, returnedType, null);
        }
        if (expression instanceof Apply) {
            return ExpressionFunctionUtils.getApplyExpressionBlockStmtWithStringObjectMap(variableName, (Apply)expression, returnedType);
        }
        if (expression instanceof Constant) {
            return ExpressionFunctionUtils.getConstantExpressionBlockStmt(variableName, (Constant)expression, returnedType);
        }
        if (expression instanceof Discretize) {
            return ExpressionFunctionUtils.getDiscretizeExpressionBlockStmt(variableName, (Discretize)expression, returnedType, null);
        }
        if (expression instanceof FieldRef) {
            return ExpressionFunctionUtils.getFieldRefExpressionBlockStmtWithStringObjectMap(variableName, (FieldRef)expression, returnedType);
        }
        if (expression instanceof Lag) {
            return ExpressionFunctionUtils.getLagExpressionBlockStmt(variableName, (Lag)expression, returnedType, null);
        }
        if (expression instanceof MapValues) {
            return ExpressionFunctionUtils.getMapValuesExpressionBlockStmt(variableName, (MapValues)expression, returnedType, null);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionFunctionUtils.getNormContinuousExpressionBlockStmt(variableName, (NormContinuous)expression, returnedType, null);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionFunctionUtils.getNormDiscreteExpressionBlockStmt(variableName, (NormDiscrete)expression, returnedType, null);
        }
        if (expression instanceof TextIndex) {
            return ExpressionFunctionUtils.getTextIndexExpressionBlockStmt(variableName, (TextIndex)expression, returnedType, null);
        }
        throw new IllegalArgumentException(String.format(EXPRESSION_NOT_MANAGED, expression.getClass()));
    }

    static BlockStmt getAggregatedExpressionBlockStmt(String variableName, Aggregate aggregate, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static BlockStmt getApplyExpressionBlockStmtWithKiePMMLValues(String variableName, Apply apply, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        BlockStmt toReturn = new BlockStmt();
        ArrayList<String> innerVariables = new ArrayList<String>();
        innerVariables.add(KIEPMMLNAMEVALUE_LIST_PARAM);
        ClassOrInterfaceType objectReturnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        if (apply.getExpressions() != null) {
            int counter = 1;
            for (Expression expression : apply.getExpressions()) {
                String innerVariable = String.format(INNER_VARIABLE_NAME, variableName, expression.getClass().getSimpleName(), counter);
                BlockStmt innerBlockStmt = ExpressionFunctionUtils.getExpressionBlockStmtWithKiePMMLValues(innerVariable, expression, objectReturnedType, parameterNameTypeMap);
                toReturn.getStatements().addAll(innerBlockStmt.getStatements());
                innerVariables.add(innerVariable);
                ++counter;
            }
        }
        MethodCallExpr functionMethodCall = new MethodCallExpr();
        functionMethodCall.setScope((com.github.javaparser.ast.expr.Expression)new ThisExpr());
        functionMethodCall.setName(apply.getFunction());
        NodeList functionCallArguments = NodeList.nodeList((Collection)innerVariables.stream().map(NameExpr::new).collect(Collectors.toList()));
        functionMethodCall.setArguments(functionCallArguments);
        VariableDeclarator variableDeclarator = new VariableDeclarator();
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)functionMethodCall);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr();
        variableDeclarationExpr.setVariables(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        toReturn.addStatement((com.github.javaparser.ast.expr.Expression)variableDeclarationExpr);
        return toReturn;
    }

    static BlockStmt getApplyExpressionBlockStmtWithStringObjectMap(String variableName, Apply apply, ClassOrInterfaceType returnedType) {
        NodeList functionCallArguments;
        MethodCallExpr functionMethodCall;
        VariableDeclarator variableDeclarator;
        BlockStmt applyBlock;
        String function;
        BlockStmt toReturn = new BlockStmt();
        ArrayList<String> innerVariables = new ArrayList<String>();
        ClassOrInterfaceType objectReturnedType = StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getName());
        if (apply.getExpressions() != null) {
            int counter = 1;
            for (Expression expression : apply.getExpressions()) {
                String innerVariable = String.format(INNER_VARIABLE_NAME, variableName, expression.getClass().getSimpleName(), counter);
                BlockStmt innerBlockStmt = ExpressionFunctionUtils.getExpressionBlockStmtWithStringObjectMap(innerVariable, expression, objectReturnedType);
                toReturn.getStatements().addAll(innerBlockStmt.getStatements());
                innerVariables.add(innerVariable);
                ++counter;
            }
        }
        if (BUILTIN_FUNCTIONS.isBUILTIN_FUNCTIONS((String)(function = apply.getFunction()))) {
            MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(APPLYEXPRESSIONBUILTINFUNCTIONINVOCATION).get(0)).clone();
            applyBlock = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
            variableDeclarator = CommonCodegenUtils.getVariableDeclarator(applyBlock, APPLY_VARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", APPLY_VARIABLE, applyBlock)));
            CastExpr castExpr = ((com.github.javaparser.ast.expr.Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", APPLY_VARIABLE, applyBlock)))).asCastExpr();
            castExpr.setType((Type)returnedType);
            functionMethodCall = castExpr.getExpression().asMethodCallExpr();
            VariableDeclarator inputData = CommonCodegenUtils.getVariableDeclarator(applyBlock, INPUT_DATA).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", INPUT_DATA, applyBlock)));
            ArrayInitializerExpr arrayInitializerExpr = ((com.github.javaparser.ast.expr.Expression)inputData.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", INPUT_DATA, applyBlock)))).asArrayInitializerExpr();
            arrayInitializerExpr.setValues(NodeList.nodeList((Collection)innerVariables.stream().map(NameExpr::new).collect(Collectors.toList())));
            String inputDataVariableName = variableName + INPUT_DATA;
            inputData.setName(inputDataVariableName);
            functionCallArguments = NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{new NameExpr(inputDataVariableName)});
        } else {
            MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(APPLYEXPRESSIONLOCALMETHODINVOCATION).get(0)).clone();
            applyBlock = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
            variableDeclarator = CommonCodegenUtils.getVariableDeclarator(applyBlock, APPLY_VARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", APPLY_VARIABLE, applyBlock)));
            functionMethodCall = ((com.github.javaparser.ast.expr.Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", APPLY_VARIABLE, applyBlock)))).asMethodCallExpr();
            functionCallArguments = NodeList.nodeList((Collection)innerVariables.stream().map(NameExpr::new).collect(Collectors.toList()));
            functionMethodCall.setArguments(functionCallArguments);
        }
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        functionMethodCall.setArguments(functionCallArguments);
        applyBlock.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static BlockStmt getConstantExpressionBlockStmt(String variableName, Constant constant, ClassOrInterfaceType returnedType) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(CONSTANTEXPRESSIONTEMPLATE).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        Object constantValue = constant.getValue();
        Object initializer = constantValue instanceof String ? new StringLiteralExpr((String)constantValue) : new NameExpr(constantValue.toString());
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, CONSTANT_VALUE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", CONSTANT_VALUE, toReturn)));
        variableDeclarator.setName(new SimpleName(variableName));
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setInitializer((com.github.javaparser.ast.expr.Expression)initializer);
        return toReturn;
    }

    static BlockStmt getDiscretizeExpressionBlockStmt(String variableName, Discretize discretize, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static BlockStmt getFieldRefExpressionBlockStmtWithKiePMMLValues(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(FIELDREFEXPRESSIONFROMKIEPMMLNAMEVALUESTEMPLATE).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator optionalKiePMMLNameValue = CommonCodegenUtils.getVariableDeclarator(toReturn, KIEPMMLNAMEVALUE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", KIEPMMLNAMEVALUE, toReturn)));
        MethodCallExpr optionalKiePMMLNameValueInitializer = ((com.github.javaparser.ast.expr.Expression)optionalKiePMMLNameValue.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", KIEPMMLNAMEVALUE, toReturn)))).asMethodCallExpr();
        ExpressionStmt expressionStmt = (ExpressionStmt)optionalKiePMMLNameValueInitializer.findAll(ExpressionStmt.class).get(0);
        MethodCallExpr methodCallExpr = expressionStmt.getExpression().asMethodCallExpr();
        String fieldNameToRef = fieldRef.getField().getValue();
        NameExpr nameExpr = new NameExpr(String.format("\"%s\"", fieldNameToRef));
        methodCallExpr.getArguments().set(0, (Node)nameExpr);
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, FIELDREFVARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", FIELDREFVARIABLE, toReturn)));
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        CastExpr initializer = ((com.github.javaparser.ast.expr.Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", FIELDREFVARIABLE, toReturn)))).asCastExpr();
        initializer.setType((Type)returnedType);
        MethodCallExpr expression = initializer.getExpression().asMethodCallExpr();
        StringLiteralExpr orElseExpression = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        expression.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{orElseExpression}));
        return toReturn;
    }

    static BlockStmt getFieldRefExpressionBlockStmtWithStringObjectMap(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(FIELDREFEXPRESSIONFROMSTRINGOBJECTMAPTEMPLATE).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        String fieldNameToRef = fieldRef.getField().getValue();
        String kieRefVariableName = KEYREFVARIABLE + fieldNameToRef;
        VariableDeclarator kieRefVariable = CommonCodegenUtils.getVariableDeclarator(toReturn, KEYREFVARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", KEYREFVARIABLE, toReturn)));
        kieRefVariable.setName(kieRefVariableName);
        kieRefVariable.setInitializer((com.github.javaparser.ast.expr.Expression)new NameExpr(String.format("\"%s\"", fieldNameToRef)));
        String missingFieldRefVariableName = MISSINGFIELDREFVARIABLE + fieldNameToRef;
        VariableDeclarator missingFieldRefVariable = CommonCodegenUtils.getVariableDeclarator(toReturn, MISSINGFIELDREFVARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", MISSINGFIELDREFVARIABLE, toReturn)));
        missingFieldRefVariable.setName(missingFieldRefVariableName);
        StringLiteralExpr missingFieldRefInitializer = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        missingFieldRefVariable.setInitializer((com.github.javaparser.ast.expr.Expression)missingFieldRefInitializer);
        VariableDeclarator fieldRefVariable = CommonCodegenUtils.getVariableDeclarator(toReturn, FIELDREFVARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", FIELDREFVARIABLE, toReturn)));
        fieldRefVariable.setName(variableName);
        fieldRefVariable.setType((Type)returnedType);
        ConditionalExpr initializer = ((com.github.javaparser.ast.expr.Expression)fieldRefVariable.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", FIELDREFVARIABLE, toReturn)))).asConditionalExpr();
        initializer.getCondition().asMethodCallExpr().setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{new NameExpr(kieRefVariableName)}));
        initializer.getThenExpr().asMethodCallExpr().setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{new NameExpr(kieRefVariableName)}));
        initializer.setElseExpr((com.github.javaparser.ast.expr.Expression)new NameExpr(missingFieldRefVariableName));
        return toReturn;
    }

    static BlockStmt getFieldRefExpressionBlockStmtWithInputValue(String variableName, FieldRef fieldRef, ClassOrInterfaceType returnedType) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(FIELDREFEXPRESSIONFROMINPUTVALUETEMPLATE).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        String fieldNameToRef = fieldRef.getField().getValue();
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, FIELDREFVARIABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", FIELDREFVARIABLE, toReturn)));
        variableDeclarator.setType((Type)returnedType);
        variableDeclarator.setName(variableName);
        ConditionalExpr initializer = ((com.github.javaparser.ast.expr.Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", FIELDREFVARIABLE, toReturn)))).asConditionalExpr();
        BinaryExpr condition = initializer.getCondition().asBinaryExpr();
        NameExpr nameExpression = new NameExpr(fieldNameToRef);
        condition.setLeft((com.github.javaparser.ast.expr.Expression)nameExpression);
        CastExpr thenExpr = initializer.getThenExpr().asCastExpr();
        thenExpr.setType((Type)returnedType);
        MethodCallExpr converterCallExpression = thenExpr.getExpression().asMethodCallExpr();
        ClassExpr expectedClassExpression = new ClassExpr();
        expectedClassExpression.setType((Type)returnedType);
        converterCallExpression.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{expectedClassExpression, nameExpression}));
        CastExpr elseExpr = initializer.getElseExpr().asCastExpr();
        StringLiteralExpr elseExpression = fieldRef.getMapMissingTo() != null ? new StringLiteralExpr(fieldRef.getMapMissingTo()) : new NullLiteralExpr();
        elseExpr.setType((Type)returnedType);
        elseExpr.setExpression((com.github.javaparser.ast.expr.Expression)elseExpression);
        return toReturn;
    }

    static BlockStmt getLagExpressionBlockStmt(String variableName, Lag lag, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static BlockStmt getMapValuesExpressionBlockStmt(String variableName, MapValues mapValues, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static BlockStmt getNormContinuousExpressionBlockStmt(String variableName, NormContinuous normContinuous, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static BlockStmt getNormDiscreteExpressionBlockStmt(String variableName, NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static BlockStmt getTextIndexExpressionBlockStmt(String variableName, TextIndex textIndex, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }

    static MethodDeclaration getExpressionMethodDeclarationWithKiePMMLValues(String methodName, String variableName, BlockStmt body, ClassOrInterfaceType returnedType, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        MethodDeclaration toReturn = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(METHODDECLARATIONKIEPMMLNAMEVALUETEMPLATE).get(0)).clone();
        NodeList typeParameters = new NodeList();
        parameterNameTypeMap.forEach((parameterName, classOrInterfaceType) -> {
            Parameter toAdd = new Parameter();
            toAdd.setName(parameterName);
            toAdd.setType((Type)classOrInterfaceType);
            typeParameters.add((Node)toAdd);
        });
        toReturn.setParameters(typeParameters);
        ReturnStmt returnStmt = (ReturnStmt)((BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", toReturn)))).findFirst(ReturnStmt.class).orElseThrow(() -> new KiePMMLException(String.format("Missing expected return in method %s", toReturn)));
        returnStmt.setExpression((com.github.javaparser.ast.expr.Expression)new NameExpr(variableName));
        body.addStatement((Statement)returnStmt);
        toReturn.setName(methodName);
        toReturn.setType((Type)returnedType);
        toReturn.setBody(body);
        return toReturn;
    }

    static MethodDeclaration getExpressionMethodDeclarationWithStringObjectMap(String methodName, String variableName, BlockStmt body, ClassOrInterfaceType returnedType) {
        MethodDeclaration toReturn = ((MethodDeclaration)EXPRESSION_TEMPLATE.getMethodsByName(METHODDECLARATIONSTRINGOBJECTMAPTEMPLATE).get(0)).clone();
        ReturnStmt returnStmt = (ReturnStmt)((BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", toReturn)))).findFirst(ReturnStmt.class).orElseThrow(() -> new KiePMMLException(String.format("Missing expected return in method %s", toReturn)));
        returnStmt.setExpression((com.github.javaparser.ast.expr.Expression)new NameExpr(variableName));
        body.addStatement((Statement)returnStmt);
        toReturn.setName(methodName);
        toReturn.setType((Type)returnedType);
        toReturn.setBody(body);
        return toReturn;
    }

    static {
        DEFAULT_PARAMETERTYPE_MAP = new LinkedHashMap();
        DEFAULT_PARAMETERTYPE_MAP.put(KIEPMMLNAMEVALUE_LIST_PARAM, CommonCodegenUtils.getTypedClassOrInterfaceType(List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())));
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR = new FieldAccessExpr();
        String converterTypeUtilFullName = ConverterTypeUtil.class.getName();
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.setName(converterTypeUtilFullName.substring(converterTypeUtilFullName.lastIndexOf(46) + 1));
        CONVERTER_TYPE_UTIL_FIELD_ACCESSOR_EXPR.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(converterTypeUtilFullName.substring(0, converterTypeUtilFullName.lastIndexOf(46))));
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(EXPRESSION_FUNCTION_UTILS_TEMPLATE_JAVA);
        EXPRESSION_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(EXPRESSION_FUNCTION_UTILS_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: ExpressionFunctionUtilsTemplate"));
    }
}

