/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.LocalTransformations;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLDerivedFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLLocalTransformationsFactory {
    public static final String LOCAL_TRANSFORMATIONS = "localTransformations";
    static final String KIE_PMML_LOCAL_TRANSFORMATIONS_TEMPLATE_JAVA = "KiePMMLLocalTransformationsTemplate.tmpl";
    static final String KIE_PMML_LOCAL_TRANSFORMATIONS_TEMPLATE = "KiePMMLLocalTransformationsTemplate";
    static final String GETKIEPMMLLOCALTRANSFORMATIONS = "getKiePMMLLocalTransformations";
    static final ClassOrInterfaceDeclaration LOCAL_TRANSFORMATIONS_TEMPLATE;

    private KiePMMLLocalTransformationsFactory() {
    }

    static BlockStmt getKiePMMLLocalTransformationsVariableDeclaration(LocalTransformations localTransformations) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)LOCAL_TRANSFORMATIONS_TEMPLATE.getMethodsByName(GETKIEPMMLLOCALTRANSFORMATIONS).get(0)).clone();
        BlockStmt transformationDictionaryBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(transformationDictionaryBody, LOCAL_TRANSFORMATIONS).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", LOCAL_TRANSFORMATIONS, transformationDictionaryBody)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", LOCAL_TRANSFORMATIONS, methodDeclaration)))).asMethodCallExpr();
        BlockStmt toReturn = new BlockStmt();
        if (localTransformations.hasDerivedFields()) {
            NodeList<Expression> derivedFields = KiePMMLLocalTransformationsFactory.addDerivedField(toReturn, localTransformations.getDerivedFields());
            CommonCodegenUtils.getChainedMethodCallExprFrom("withDerivedFields", initializer).setArguments(derivedFields);
        }
        transformationDictionaryBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static NodeList<Expression> addDerivedField(BlockStmt body, List<DerivedField> derivedFields) {
        NodeList arguments = new NodeList();
        int counter = 0;
        for (DerivedField derivedField : derivedFields) {
            String nestedVariableName = String.format("localTransformationsDerivedField_%s", counter);
            arguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLDerivedFieldFactory.getDerivedFieldVariableDeclaration(nestedVariableName, derivedField);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)body).addStatement(arg_0));
            ++counter;
        }
        return KiePMMLLocalTransformationsFactory.getArraysAsListInvocation((NodeList<Expression>)arguments);
    }

    private static NodeList<Expression> getArraysAsListInvocation(NodeList<Expression> arguments) {
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        return NodeList.nodeList((Node[])new Expression[]{methodCallExpr});
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_LOCAL_TRANSFORMATIONS_TEMPLATE_JAVA);
        LOCAL_TRANSFORMATIONS_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_LOCAL_TRANSFORMATIONS_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLLocalTransformationsTemplate"));
        ((MethodDeclaration)LOCAL_TRANSFORMATIONS_TEMPLATE.getMethodsByName(GETKIEPMMLLOCALTRANSFORMATIONS).get(0)).clone();
    }
}

