/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Value;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;

public class ModelUtils {
    private ModelUtils() {
    }

    public static Optional<String> getTargetFieldName(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFields(dataDictionary, model).stream().map(KiePMMLNameOpType::getName).findFirst();
    }

    public static DATA_TYPE getTargetFieldType(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFieldsTypeMap(dataDictionary, model).entrySet().iterator().next().getValue();
    }

    public static List<KiePMMLNameOpType> getTargetFields(DataDictionary dataDictionary, Model model) {
        ArrayList<KiePMMLNameOpType> toReturn = new ArrayList<KiePMMLNameOpType>();
        if (model.getMiningSchema() != null && model.getMiningSchema().getMiningFields() != null) {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                OP_TYPE opType = ModelUtils.getOpType(dataDictionary, model, miningField.getName().getValue());
                toReturn.add(new KiePMMLNameOpType(miningField.getName().getValue(), opType));
            }
        }
        return toReturn;
    }

    public static Map<String, DATA_TYPE> getTargetFieldsTypeMap(DataDictionary dataDictionary, Model model) {
        LinkedHashMap<String, DATA_TYPE> toReturn = new LinkedHashMap<String, DATA_TYPE>();
        if (model.getMiningSchema() != null && model.getMiningSchema().getMiningFields() != null) {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                toReturn.put(miningField.getName().getValue(), ModelUtils.getDataType(dataDictionary, miningField.getName().getValue()));
            }
        }
        return toReturn;
    }

    public static OP_TYPE getOpType(DataDictionary dataDictionary, Model model, String targetFieldName) {
        return Stream.of(ModelUtils.getOpTypeFromTargets(model.getTargets(), targetFieldName), ModelUtils.getOpTypeFromMiningFields(model.getMiningSchema(), targetFieldName), ModelUtils.getOpTypeFromDataDictionary(dataDictionary, targetFieldName)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find OpType for field %s", targetFieldName)));
    }

    public static Optional<OP_TYPE> getOpTypeFromDataDictionary(DataDictionary dataDictionary, String fieldName) {
        if (dataDictionary != null && dataDictionary.getDataFields() != null) {
            return dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(fieldName, dataField.getName().getValue()) && dataField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return Optional.empty();
    }

    public static Optional<OP_TYPE> getOpTypeFromMiningFields(MiningSchema miningSchema, String fieldName) {
        if (miningSchema != null && miningSchema.getMiningFields() != null) {
            return miningSchema.getMiningFields().stream().filter(miningField -> Objects.equals(fieldName, miningField.getName().getValue()) && miningField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return Optional.empty();
    }

    public static Optional<OP_TYPE> getOpTypeFromTargets(Targets targets, String fieldName) {
        if (targets != null && targets.getTargets() != null) {
            return targets.getTargets().stream().filter(target -> Objects.equals(fieldName, target.getField().getValue()) && target.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return Optional.empty();
    }

    public static DataType getDataType(List<DerivedField> derivedFields, DataDictionary dataDictionary, String fieldName) {
        return Stream.of(ModelUtils.getDataTypeFromDerivedFields(derivedFields, fieldName), ModelUtils.getDataTypeFromDataDictionary(dataDictionary, fieldName)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", fieldName)));
    }

    public static DATA_TYPE getDataType(DataDictionary dataDictionary, String targetFieldName) {
        Optional<DATA_TYPE> toReturn = dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue())).findFirst().map(dataField -> DATA_TYPE.byName((String)dataField.getDataType().value()));
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", targetFieldName)));
    }

    public static List<DerivedField> getDerivedFields(TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        ArrayList<DerivedField> toReturn = new ArrayList<DerivedField>();
        if (transformationDictionary != null && transformationDictionary.getDerivedFields() != null) {
            toReturn.addAll(transformationDictionary.getDerivedFields());
        }
        if (localTransformations != null && localTransformations.getDerivedFields() != null) {
            toReturn.addAll(localTransformations.getDerivedFields());
        }
        return toReturn;
    }

    public static List<MiningField> convertToKieMiningFieldList(MiningSchema toConvert, DataDictionary dataDictionary) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getMiningFields().stream().map(miningField -> {
            DataField dataField = dataDictionary.getDataFields().stream().filter(df -> df.getName().equals((Object)miningField.getName())).findFirst().orElseThrow(() -> new KiePMMLException("Cannot find " + miningField.getName() + " in DataDictionary"));
            return ModelUtils.convertToKieMiningField(miningField, dataField);
        }).collect(Collectors.toList());
    }

    public static MiningField convertToKieMiningField(org.dmg.pmml.MiningField toConvert, DataField dataField) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        FIELD_USAGE_TYPE fieldUsageType = toConvert.getUsageType() != null ? FIELD_USAGE_TYPE.byName((String)toConvert.getUsageType().value()) : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataType = dataField.getDataType() != null ? DATA_TYPE.byName((String)dataField.getDataType().value()) : null;
        String missingValueReplacement = toConvert.getMissingValueReplacement() != null ? toConvert.getMissingValueReplacement().toString() : null;
        List<String> allowedValues = ModelUtils.convertDataFieldValues(dataField.getValues());
        List<Interval> intervals = ModelUtils.convertDataFieldIntervals(dataField.getIntervals());
        return new MiningField(name, fieldUsageType, opType, dataType, missingValueReplacement, allowedValues, intervals);
    }

    public static List<OutputField> convertToKieOutputFieldList(Output toConvert, DataDictionary dataDictionary) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getOutputFields().stream().map(outputField -> {
            DataField dataField = dataDictionary.getDataFields().stream().filter(df -> df.getName().equals((Object)outputField.getTargetField())).findFirst().orElse(null);
            return ModelUtils.convertToKieOutputField(outputField, dataField);
        }).collect(Collectors.toList());
    }

    public static OutputField convertToKieOutputField(org.dmg.pmml.OutputField toConvert, DataField dataField) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataFieldDataType = dataField != null ? DATA_TYPE.byName((String)dataField.getDataType().value()) : null;
        DATA_TYPE dataType = toConvert.getDataType() != null ? DATA_TYPE.byName((String)toConvert.getDataType().value()) : dataFieldDataType;
        String targetField = toConvert.getTargetField() != null ? toConvert.getTargetField().getValue() : null;
        RESULT_FEATURE resultFeature = toConvert.getResultFeature() != null ? RESULT_FEATURE.byName((String)toConvert.getResultFeature().value()) : null;
        List<String> allowedValues = dataField != null ? ModelUtils.convertDataFieldValues(dataField.getValues()) : null;
        return new OutputField(name, opType, dataType, targetField, resultFeature, allowedValues);
    }

    public static List<KiePMMLOutputField> convertToKiePMMLOutputFieldList(Output toConvert) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getOutputFields().stream().map(ModelUtils::convertToKiePMMLOutputField).collect(Collectors.toList());
    }

    public static KiePMMLOutputField convertToKiePMMLOutputField(org.dmg.pmml.OutputField toConvert) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : "" + toConvert.hashCode();
        String targetField = toConvert.getTargetField() != null ? toConvert.getTargetField().getValue() : null;
        RESULT_FEATURE resultFeature = toConvert.getResultFeature() != null ? RESULT_FEATURE.byName((String)toConvert.getResultFeature().value()) : null;
        KiePMMLExpression kiePMMLExpression = ModelUtils.convertToKiePMMLExpression(toConvert.getExpression());
        KiePMMLOutputField.Builder builder = KiePMMLOutputField.builder((String)name, Collections.emptyList()).withTargetField(targetField).withResultFeature(resultFeature).withRank(toConvert.getRank()).withKiePMMLExpression(kiePMMLExpression);
        return (KiePMMLOutputField)builder.build();
    }

    public static List<KiePMMLExpression> convertToKiePMMLExpressions(List<Expression> toConvert) {
        if (toConvert == null) {
            return null;
        }
        return toConvert.stream().map(ModelUtils::convertToKiePMMLExpression).collect(Collectors.toList());
    }

    public static KiePMMLExpression convertToKiePMMLExpression(Expression toConvert) {
        String expressionType;
        if (toConvert == null) {
            return null;
        }
        KiePMMLApply toReturn = null;
        switch (expressionType = toConvert.getClass().getSimpleName()) {
            case "Apply": {
                toReturn = ModelUtils.convertToKiePMMLApply((Apply)toConvert);
                break;
            }
            case "Constant": {
                toReturn = ModelUtils.convertToKiePMMLConstant((Constant)toConvert);
                break;
            }
            case "FieldRef": {
                toReturn = ModelUtils.convertToKiePMMLFieldRef((FieldRef)toConvert);
                break;
            }
        }
        return toReturn;
    }

    public static KiePMMLApply convertToKiePMMLApply(Apply toConvert) {
        String name = "" + toConvert.hashCode();
        String invalidValueTreatment = toConvert.getInvalidValueTreatment() != null ? toConvert.getInvalidValueTreatment().value() : null;
        List<KiePMMLExpression> kiePMMLExpressions = ModelUtils.convertToKiePMMLExpressions(toConvert.getExpressions());
        KiePMMLApply.Builder builder = KiePMMLApply.builder((String)name, Collections.emptyList(), (String)toConvert.getFunction()).withKiePMMLExpressions(kiePMMLExpressions).withMapMissingTo(toConvert.getMapMissingTo()).withDefaultValue(toConvert.getDefaultValue()).withInvalidValueTreatmentMethod(invalidValueTreatment);
        return (KiePMMLApply)builder.build();
    }

    public static KiePMMLConstant convertToKiePMMLConstant(Constant toConvert) {
        String name = "" + toConvert.hashCode();
        return new KiePMMLConstant(name, Collections.emptyList(), toConvert.getValue());
    }

    public static KiePMMLFieldRef convertToKiePMMLFieldRef(FieldRef toConvert) {
        return new KiePMMLFieldRef(toConvert.getField().getValue(), Collections.emptyList(), toConvert.getMapMissingTo());
    }

    public static List<KiePMMLTarget> convertToKiePMMLTargetList(Targets toConvert) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getTargets().stream().map(ModelUtils::convertToKiePMMLTarget).collect(Collectors.toList());
    }

    public static KiePMMLTarget convertToKiePMMLTarget(Target toConvert) {
        Double rescaleFactor;
        Double rescaleConstant;
        Double max;
        Double min;
        CAST_INTEGER castInteger;
        String field;
        OP_TYPE opType;
        KiePMMLTarget.Builder builder = KiePMMLTarget.builder((String)("" + toConvert.hashCode()), Collections.emptyList());
        List<KiePMMLTargetValue> targetValues = ModelUtils.convertToKiePMMLTargetValueList(toConvert.getTargetValues());
        if (!targetValues.isEmpty()) {
            builder.withTargetValues(targetValues);
        }
        OP_TYPE oP_TYPE = opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        if (opType != null) {
            builder.withOpType(opType);
        }
        String string = field = toConvert.getField() != null ? toConvert.getField().getValue() : null;
        if (field != null) {
            builder.withField(field);
        }
        CAST_INTEGER cAST_INTEGER = castInteger = toConvert.getCastInteger() != null ? CAST_INTEGER.byName((String)toConvert.getCastInteger().value()) : null;
        if (castInteger != null) {
            builder.withCastInteger(castInteger);
        }
        Double d = min = toConvert.getMin() != null ? Double.valueOf(toConvert.getMin().doubleValue()) : null;
        if (min != null) {
            builder.withMin(min.doubleValue());
        }
        Double d2 = max = toConvert.getMax() != null ? Double.valueOf(toConvert.getMax().doubleValue()) : null;
        if (max != null) {
            builder.withMax(max.doubleValue());
        }
        Double d3 = rescaleConstant = toConvert.getRescaleConstant() != null ? Double.valueOf(toConvert.getRescaleConstant().doubleValue()) : null;
        if (rescaleConstant != null) {
            builder.withRescaleConstant(rescaleConstant.doubleValue());
        }
        Double d4 = rescaleFactor = toConvert.getRescaleFactor() != null ? Double.valueOf(toConvert.getRescaleFactor().doubleValue()) : null;
        if (rescaleFactor != null) {
            builder.withRescaleFactor(rescaleFactor.doubleValue());
        }
        return (KiePMMLTarget)builder.build();
    }

    public static List<KiePMMLTargetValue> convertToKiePMMLTargetValueList(List<TargetValue> toConvert) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.stream().map(ModelUtils::convertToKiePMMLTargetValue).collect(Collectors.toList());
    }

    public static KiePMMLTargetValue convertToKiePMMLTargetValue(TargetValue toConvert) {
        String value = toConvert.getValue() != null ? toConvert.getValue().toString() : null;
        String displayValue = toConvert.getDisplayValue() != null ? toConvert.getDisplayValue() : null;
        KiePMMLTargetValue.Builder builder = KiePMMLTargetValue.builder((String)("" + toConvert.hashCode()), Collections.emptyList()).withValue(value).withDisplayValue(displayValue).withPriorProbability(toConvert.getPriorProbability()).withDefaultValue(toConvert.getDefaultValue());
        return (KiePMMLTargetValue)builder.build();
    }

    public static String getBoxedClassName(ParameterField parameterField) {
        return parameterField.getDataType() == null ? Object.class.getName() : ModelUtils.getBoxedClassName(parameterField.getDataType());
    }

    public static String getBoxedClassName(DataType dataType) {
        Class c = dataType == null ? Object.class : DATA_TYPE.byName((String)dataType.value()).getMappedClass();
        return PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed((Class)c).map(primitiveBoxed -> primitiveBoxed.getBoxed().getName()).orElse(c.getName());
    }

    static Optional<DataType> getDataTypeFromDataDictionary(DataDictionary dataDictionary, String fieldName) {
        return dataDictionary != null && dataDictionary.getDataFields() != null ? dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(fieldName, dataField.getName().getValue())).findFirst().map(DataField::getDataType) : Optional.empty();
    }

    static Optional<DataType> getDataTypeFromTransformationDictionary(TransformationDictionary transformationDictionary, String fieldName) {
        return transformationDictionary != null && transformationDictionary.getDerivedFields() != null ? transformationDictionary.getDerivedFields().stream().filter(derivedField -> Objects.equals(fieldName, derivedField.getName().getValue())).findFirst().map(DerivedField::getDataType) : Optional.empty();
    }

    static Optional<DataType> getDataTypeFromDerivedFields(List<DerivedField> derivedFields, String fieldName) {
        return derivedFields.stream().filter(derivedField -> Objects.equals(fieldName, derivedField.getName().getValue())).map(DerivedField::getDataType).findFirst();
    }

    static List<String> convertDataFieldValues(List<Value> toConvert) {
        return toConvert != null ? toConvert.stream().map(value -> value.getValue().toString()).collect(Collectors.toList()) : null;
    }

    static List<Interval> convertDataFieldIntervals(List<org.dmg.pmml.Interval> toConvert) {
        return toConvert != null ? toConvert.stream().map(interval -> new Interval(interval.getLeftMargin(), interval.getRightMargin())).collect(Collectors.toList()) : null;
    }
}

