/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.app;

import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.persistence.AbstractSolutionExporter;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.persistence.ExaminationExporter;
import org.optaplanner.examples.examination.persistence.ExaminationImporter;
import org.optaplanner.examples.examination.swingui.ExaminationPanel;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class ExaminationApp
extends CommonApp<Examination> {
    public static final String SOLVER_CONFIG = "org/optaplanner/examples/examination/solver/examinationSolverConfig.xml";
    public static final String DATA_DIR_NAME = "examination";

    public static void main(String[] args) {
        ExaminationApp.prepareSwingEnvironment();
        new ExaminationApp().init();
    }

    public ExaminationApp() {
        super("Exam timetabling", "Official competition name: ITC 2007 track1 - Examination timetabling\n\nAssign exams to timeslots and rooms.", SOLVER_CONFIG, DATA_DIR_NAME, "/org/optaplanner/examples/examination/swingui/examinationLogo.png");
    }

    protected ExaminationPanel createSolutionPanel() {
        return new ExaminationPanel();
    }

    @Override
    public SolutionFileIO<Examination> createSolutionFileIO() {
        return new XStreamSolutionFileIO(new Class[]{Examination.class});
    }

    @Override
    protected AbstractSolutionImporter[] createSolutionImporters() {
        return new AbstractSolutionImporter[]{new ExaminationImporter()};
    }

    @Override
    protected AbstractSolutionExporter createSolutionExporter() {
        return new ExaminationExporter();
    }
}

