/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.ProcessService;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaServerConsumer;
import org.kie.server.services.jbpm.kafka.KafkaServerProducer;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaServerExtension
implements KieServerExtension,
DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerExtension.class);
    public static final String EXTENSION_NAME = "Kafka";
    private static final String DEFAULT_HOST = "localhost:9092";
    private KafkaServerConsumer kafkaServerConsumer;
    private KafkaServerProducer kafkaServerProducer;
    private KafkaEventProcessorFactory factory;
    private AtomicBoolean initialized = new AtomicBoolean();
    private ListenerSupport deploymentService;
    private Map<String, Object> consumerProperties = new HashMap<String, Object>();
    private Map<String, Object> producerProperties = new HashMap<String, Object>();

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isActive() {
        return !Boolean.parseBoolean(System.getProperty("org.kie.kafka.server.ext.disabled", "true"));
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.initialized.get()) {
            logger.warn("Kafka extension already initialized");
            return;
        }
        this.initProperties();
        DeploymentDescriptorManager.addDescriptorLocation((String)"classpath:/META-INF/kafka-deployment-descriptor-defaults.xml");
        KieServerExtension jbpmExt = registry.getServerExtension("jBPM");
        if (jbpmExt == null) {
            logger.warn("Extension jBPM is required");
            return;
        }
        ProcessService processService = null;
        for (Object service : jbpmExt.getServices()) {
            if (this.deploymentService == null && DeploymentService.class.isAssignableFrom(service.getClass())) {
                this.deploymentService = (ListenerSupport)service;
            } else if (processService == null && ProcessService.class.isAssignableFrom(service.getClass())) {
                processService = (ProcessService)service;
            }
            if (this.deploymentService == null || processService == null) continue;
            break;
        }
        if (this.deploymentService == null) {
            throw new IllegalStateException("Cannot find deployment service");
        }
        if (processService == null) {
            throw new IllegalStateException("Cannot find process service");
        }
        this.factory = KafkaServerUtils.buildEventProcessorFactory();
        this.kafkaServerConsumer = new KafkaServerConsumer(this.factory, this::getKafkaConsumer, processService);
        this.kafkaServerProducer = new KafkaServerProducer(this.factory, this::getKafkaProducer);
        this.deploymentService.addListener((DeploymentEventListener)this);
        this.initialized.set(true);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.deploymentService != null) {
            this.deploymentService.removeListener((DeploymentEventListener)this);
        }
        Duration duration = Duration.ofSeconds(Long.getLong("org.kie.server.jbpm-kafka.ext.close.timeout", 30L));
        this.kafkaServerConsumer.close(duration);
        this.kafkaServerConsumer = null;
        this.kafkaServerProducer.close(duration);
        this.kafkaServerProducer = null;
        this.factory.close();
        this.factory = null;
        this.deploymentService = null;
        this.initialized.set(false);
        this.consumerProperties.clear();
        this.producerProperties.clear();
    }

    protected Consumer<String, byte[]> getKafkaConsumer() {
        this.consumerProperties.putIfAbsent("bootstrap.servers", DEFAULT_HOST);
        this.consumerProperties.putIfAbsent("isolation.level", IsolationLevel.READ_COMMITTED.toString().toLowerCase());
        this.consumerProperties.putIfAbsent("group.id", "jbpm-consumer");
        return new KafkaConsumer(this.consumerProperties, (Deserializer)new StringDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    protected Producer<String, byte[]> getKafkaProducer() {
        this.producerProperties.putIfAbsent("bootstrap.servers", DEFAULT_HOST);
        this.producerProperties.putIfAbsent("max.block.ms", 2000L);
        return new KafkaProducer(this.producerProperties, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
    }

    public void onDeploy(DeploymentEvent event) {
        this.kafkaServerProducer.activate(event);
        this.kafkaServerConsumer.addRegistration(event);
    }

    public void onUnDeploy(DeploymentEvent event) {
        this.kafkaServerProducer.deactivate(event);
        this.kafkaServerConsumer.removeRegistration(event);
    }

    public void onActivate(DeploymentEvent event) {
        this.kafkaServerConsumer.addRegistration(event);
    }

    public void onDeactivate(DeploymentEvent event) {
        this.kafkaServerConsumer.removeRegistration(event);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public String getImplementedCapability() {
        return "BPM-KAFKA";
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 20;
    }

    public String toString() {
        return "Kafka KIE Server extension";
    }

    public void serverStarted() {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void prepareContainerUpdate(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        return Collections.emptyList();
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    protected final Map<String, Object> getConsumerProperties() {
        return Collections.unmodifiableMap(this.consumerProperties);
    }

    protected final Map<String, Object> getProducerProperties() {
        return Collections.unmodifiableMap(this.producerProperties);
    }

    protected final void initProperties() {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("org.kie.server.jbpm-kafka.ext.")) continue;
            String propName = key.substring("org.kie.server.jbpm-kafka.ext.".length());
            if (ConsumerConfig.configNames().contains(propName)) {
                this.consumerProperties.put(propName, entry.getValue());
            }
            if (!ProducerConfig.configNames().contains(propName)) continue;
            this.producerProperties.put(propName, entry.getValue());
        }
    }
}

