/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.MessageDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.SignalDesc;
import org.jbpm.services.api.model.SignalDescBase;
import org.kie.server.services.jbpm.kafka.KafkaServerEventProcessor;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;

class KafkaServerRegistration {
    private Map<String, Map<SignalDesc, Collection<String>>> topic2Signal = new HashMap<String, Map<SignalDesc, Collection<String>>>();
    private Map<String, Map<MessageDesc, Collection<String>>> topic2Message = new HashMap<String, Map<MessageDesc, Collection<String>>>();

    KafkaServerRegistration() {
    }

    synchronized void close() {
        this.topic2Signal.clear();
        this.topic2Message.clear();
    }

    synchronized boolean isEmpty() {
        return this.topic2Signal.isEmpty() && this.topic2Message.isEmpty();
    }

    synchronized Set<String> addRegistration(DeploymentEvent event) {
        for (DeployedAsset asset : event.getDeployedUnit().getDeployedAssets()) {
            this.updateTopics(event.getDeploymentId(), (ProcessDefinition)asset);
        }
        return this.getTopicsRegistered();
    }

    synchronized Set<String> removeRegistration(DeploymentEvent event, Consumer<String> topicProcessed) {
        for (DeployedAsset asset : event.getDeployedUnit().getDeployedAssets()) {
            this.removeTopics(event.getDeploymentId(), (ProcessDefinition)asset, topicProcessed);
        }
        return this.getTopicsRegistered();
    }

    private Set<String> getTopicsRegistered() {
        HashSet<String> topics = new HashSet<String>();
        topics.addAll(this.topic2Signal.keySet());
        topics.addAll(this.topic2Message.keySet());
        return topics;
    }

    private void updateTopics(String deploymentId, ProcessDefinition processDefinition) {
        if (KafkaServerUtils.processSignals()) {
            this.addTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc());
        }
        if (KafkaServerUtils.processMessages()) {
            this.addTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc());
        }
    }

    private void removeTopics(String deploymentId, ProcessDefinition processDefinition, Consumer<String> topicProcessed) {
        this.removeTopics(this.topic2Signal, deploymentId, processDefinition.getSignalsDesc(), topicProcessed);
        this.removeTopics(this.topic2Message, deploymentId, processDefinition.getMessagesDesc(), topicProcessed);
    }

    void forEachSignal(ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<SignalDesc> eventProcessor) {
        this.forEach(this.topic2Signal, event, eventProcessor);
    }

    void forEachMessage(ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<MessageDesc> eventProcessor) {
        this.forEach(this.topic2Message, event, eventProcessor);
    }

    private synchronized <T extends SignalDescBase> void forEach(Map<String, Map<T, Collection<String>>> topic2SignalBase, ConsumerRecord<String, byte[]> event, KafkaServerEventProcessor<T> processor) {
        Map<T, Collection<String>> signalInfo = topic2SignalBase.get(event.topic());
        if (signalInfo != null) {
            for (Map.Entry<T, Collection<String>> entry : signalInfo.entrySet()) {
                SignalDescBase signal = (SignalDescBase)entry.getKey();
                for (String deploymentId : entry.getValue()) {
                    processor.accept(event, deploymentId, signal);
                }
            }
        }
    }

    private <T extends SignalDescBase> void addTopics(Map<String, Map<T, Collection<String>>> topic2SignalBase, String deploymentId, Collection<T> signals) {
        for (SignalDescBase signal : signals) {
            if (signal.getIncomingNodes().isEmpty()) continue;
            topic2SignalBase.computeIfAbsent(KafkaServerUtils.topicFromSignal(signal), k -> new HashMap()).computeIfAbsent(signal, k -> new ArrayList()).add(deploymentId);
        }
    }

    private <T extends SignalDescBase> void removeTopics(Map<String, Map<T, Collection<String>>> topic2SignalBase, String deploymentId, Collection<T> signalsDesc, Consumer<String> topicProcessed) {
        HashSet<String> topicsPerDeployment = new HashSet<String>();
        for (SignalDescBase signal : signalsDesc) {
            Collection<String> deploymentIds;
            String topic = KafkaServerUtils.topicFromSignal(signal);
            Map<T, Collection<String>> signals = topic2SignalBase.get(topic);
            if (signals == null || (deploymentIds = signals.get(signal)) == null || !deploymentIds.remove(deploymentId)) continue;
            topicsPerDeployment.add(topic);
            if (!deploymentIds.isEmpty()) continue;
            signals.remove(signal);
            if (!signals.isEmpty()) continue;
            topic2SignalBase.remove(topic);
        }
        for (String removed : topicsPerDeployment) {
            topicProcessed.accept(removed);
        }
    }
}

