/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.jbpm.casemgmt.api.model.CaseStatus;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.query.QueryContext;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.prometheus.PrometheusCaseEventListener;
import org.kie.server.services.prometheus.PrometheusCustomMetricsSupport;
import org.kie.server.services.prometheus.PrometheusDataSetListener;
import org.kie.server.services.prometheus.PrometheusDeploymentEventListener;
import org.kie.server.services.prometheus.PrometheusJobListener;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.kie.server.services.prometheus.PrometheusProcessEventListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Prometheus";
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.kie.prometheus.server.ext.disabled", "true"));
    private static PrometheusMetrics METRICS = null;
    private KieServerRegistry context;
    private boolean initialized = false;
    private PrometheusCustomMetricsSupport customMetrics;

    public static PrometheusMetrics getMetrics() {
        if (METRICS == null) {
            METRICS = new PrometheusMetrics();
        }
        return METRICS;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        CaseManagementRuntimeDataServiceBase caseRuntime;
        KieServerExtension caseExtension;
        this.context = registry;
        this.customMetrics = new PrometheusCustomMetricsSupport(this);
        this.registerDefaultDescriptor();
        KieServerExtension jBPMExtension = this.context.getServerExtension("jBPM");
        if (jBPMExtension != null) {
            RuntimeDataService dataService;
            QueryServiceImpl queryService;
            ExecutorServiceImpl executorService;
            KModuleDeploymentService deploymentService = (KModuleDeploymentService)jBPMExtension.getAppComponents(KModuleDeploymentService.class);
            if (deploymentService != null) {
                List<DeploymentEventListener> metrics = this.customMetrics.getDeploymentEventListener();
                if (!metrics.isEmpty()) {
                    ArrayList<DeploymentEventListener> listeners = new ArrayList<DeploymentEventListener>(metrics);
                    listeners.forEach(l -> deploymentService.addListener(l));
                }
                deploymentService.addListener((DeploymentEventListener)new PrometheusDeploymentEventListener());
            }
            if ((executorService = (ExecutorServiceImpl)jBPMExtension.getAppComponents(ExecutorServiceImpl.class)) != null) {
                List<AsynchronousJobListener> metrics = this.customMetrics.getAsynchronousJobListener();
                if (!metrics.isEmpty()) {
                    ArrayList<AsynchronousJobListener> listeners = new ArrayList<AsynchronousJobListener>(metrics);
                    listeners.forEach(l -> executorService.addAsyncJobListener(l));
                }
                executorService.addAsyncJobListener((AsynchronousJobListener)new PrometheusJobListener());
            }
            if ((queryService = (QueryServiceImpl)jBPMExtension.getAppComponents(QueryServiceImpl.class)) != null) {
                DataSetDefRegistry dataSetDefRegistry = queryService.getDataSetDefRegistry();
                PrometheusDataSetListener listener = new PrometheusDataSetListener(dataSetDefRegistry);
                listener.init();
                dataSetDefRegistry.addListener((DataSetDefRegistryListener)listener);
            }
            if ((dataService = (RuntimeDataService)jBPMExtension.getAppComponents(RuntimeDataService.class)) != null) {
                Collection processInstances = dataService.getProcessInstances(Arrays.asList(1), null, new QueryContext(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)));
                processInstances.forEach(pi -> PrometheusProcessEventListener.recordRunningProcessInstance(pi.getDeploymentId(), pi.getProcessId()));
            }
        }
        if ((caseExtension = this.context.getServerExtension("Case-Mgmt")) != null && (caseRuntime = (CaseManagementRuntimeDataServiceBase)caseExtension.getAppComponents(CaseManagementRuntimeDataServiceBase.class)) != null) {
            CaseInstanceList caseInstances = caseRuntime.getCaseInstances(Arrays.asList(CaseStatus.OPEN.getName()), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), null, false);
            for (CaseInstance instance : caseInstances.getCaseInstances()) {
                PrometheusCaseEventListener.recordRunningCaseInstance(instance.getCaseDefinitionId());
            }
        }
        this.initialized = true;
        if (!this.customMetrics.hasCustomMetrics()) {
            LOGGER.info("{} started", (Object)this.toString());
        } else {
            LOGGER.info("{} started with custom Prometheus metrics provider(s): {}", (Object)this.toString(), this.customMetrics.customMetricsProviders());
        }
    }

    public List<DMNRuntimeEventListener> getDMNRuntimeListeners(KieContainerInstance kContainer) {
        return this.customMetrics.getDMNRuntimeEventListener(kContainer);
    }

    public List<AgendaEventListener> getDroolsListeners(String kieSessionId, KieContainerInstance kieContainer) {
        return this.customMetrics.getAgendaEventListener(kieSessionId, kieContainer);
    }

    public List<PhaseLifecycleListener> getOptaPlannerListeners(String solverId) {
        return this.customMetrics.getPhaseLifecycleListener(solverId);
    }

    protected void registerDefaultDescriptor() {
        DeploymentDescriptorManager.addDescriptorLocation((String)"classpath:/META-INF/prometheus-deployment-descriptor-defaults.xml");
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.customMetrics.clearAgendaEventListener(kieContainerInstance);
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.context};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public String getImplementedCapability() {
        return EXTENSION_NAME;
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "Prometheus KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

