/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDroolsModelFactoryUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDroolsModelFactoryUtils.class.getName());
    static final String GETKMODULEPACKAGENAME_METHOD = "getKModulePackageName";

    private KiePMMLDroolsModelFactoryUtils() {
    }

    public static CompilationUnit getKiePMMLModelCompilationUnit(DataDictionary dataDictionary, Model model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName, String javaTemplate, String modelClassName) {
        logger.trace("getKiePMMLModelCompilationUnit {} {} {}", new Object[]{dataDictionary, model, packageName});
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)javaTemplate, (String)modelClassName);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)model.getMiningFunction().value());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        String targetField = ModelUtils.getTargetFieldName((DataDictionary)dataDictionary, (Model)model).orElse(null);
        List outputFields = KiePMMLOutputFieldFactory.getOutputFields((Model)model);
        KiePMMLDroolsModelFactoryUtils.setConstructor(model, constructorDeclaration, modelTemplate.getName(), targetField, miningFunction);
        KiePMMLModelFactoryUtils.addKiePMMLOutputFieldsPopulation((BlockStmt)constructorDeclaration.getBody(), (List)outputFields);
        KiePMMLDroolsModelFactoryUtils.addFieldTypeMapPopulation(constructorDeclaration.getBody(), fieldTypeMap);
        MethodDeclaration getKModulePackageNameMethod = (MethodDeclaration)modelTemplate.getMethodsByName(GETKMODULEPACKAGENAME_METHOD).get(0);
        KiePMMLDroolsModelFactoryUtils.populateGetKModulePackageName(getKModulePackageNameMethod, packageName);
        return cloneCU;
    }

    static void setConstructor(Model model, ConstructorDeclaration constructorDeclaration, SimpleName tableName, String targetField, MINING_FUNCTION miningFunction) {
        constructorDeclaration.setName(tableName);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"targetField", (Expression)new StringLiteralExpr(targetField));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"miningFunction", (Expression)new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"pmmlMODEL", (Expression)new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
    }

    static void addFieldTypeMapPopulation(BlockStmt body, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        for (Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry : fieldTypeMap.entrySet()) {
            KiePMMLOriginalTypeGeneratedType kiePMMLOriginalTypeGeneratedType = entry.getValue();
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(kiePMMLOriginalTypeGeneratedType.getOriginalType()), new StringLiteralExpr(kiePMMLOriginalTypeGeneratedType.getGeneratedType())});
            ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
            objectCreationExpr.setType(KiePMMLOriginalTypeGeneratedType.class.getName());
            objectCreationExpr.setArguments(expressions);
            expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(entry.getKey()), objectCreationExpr});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("fieldTypeMap"), "put", expressions));
        }
    }

    static void populateGetKModulePackageName(MethodDeclaration getKModulePackageNameMethod, String packageName) {
        BlockStmt blockStmt = (BlockStmt)getKModulePackageNameMethod.getBody().orElseThrow(() -> new KiePMMLException("Missing body inside " + getKModulePackageNameMethod));
        blockStmt.getStatements().forEach(statement -> {
            if (statement instanceof ReturnStmt) {
                ReturnStmt returnStmt = (ReturnStmt)statement;
                returnStmt.setExpression((Expression)new StringLiteralExpr(packageName));
            }
        });
    }
}

