/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.index.engine.VersionValue;

class DeleteVersionValue
extends VersionValue {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DeleteVersionValue.class);
    private final long time;

    DeleteVersionValue(long version, long time) {
        super(version);
        this.time = time;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public boolean isDelete() {
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteVersionValue that = (DeleteVersionValue)o;
        return this.time == that.time;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "DeleteVersionValue{version=" + this.getVersion() + ",time=" + this.time + '}';
    }
}

