/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindScorecardNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ScoreCardServiceLoader;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ScoreCardServiceLoaderImpl
implements ScoreCardServiceLoader {
    @Inject
    private RefactoringQueryService refactoringQueryService;
    @Inject
    private WorkspaceProjectService projectService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> find(Path path, final String packageName) {
        HashSet<String> result = new HashSet<String>();
        try {
            final WorkspaceProject workspaceProject = this.projectService.resolveProject(path);
            List rows = this.refactoringQueryService.query(FindScorecardNamesQuery.NAME, (Set)new HashSet<ValueIndexTerm>(){
                {
                    this.add(new ValueSharedPartIndexTerm("*", PartType.SCORECARD_MODEL_NAME, ValueIndexTerm.TermSearchType.WILDCARD));
                    this.add(new ValueModuleRootPathIndexTerm(workspaceProject.getMainModule().getRootPath().toURI()));
                    this.add(new ValuePackageNameIndexTerm(packageName));
                }
            });
            for (RefactoringPageRow row : rows) {
                result.add(row.getValue().toString());
            }
        }
        finally {
            return result;
        }
    }
}

