/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.services.shared.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridSortedColumnPreference;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;

@Portable
public class GridPreferencesStore
extends UserPreference {
    private GridGlobalPreferences globalPreferences;
    private List<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
    private int pageSizePreferences;
    private String selectedFilterKey;
    private HashMap<String, HashMap> customFilters = new HashMap();
    private GridSortedColumnPreference gridSortedColumnPreference;

    public GridPreferencesStore() {
    }

    public GridPreferencesStore(GridGlobalPreferences globalPreferences) {
        this.globalPreferences = globalPreferences;
        if (globalPreferences != null) {
            this.pageSizePreferences = globalPreferences.getPageSize();
        }
        this.type = UserPreferencesType.GRIDPREFERENCES;
        this.preferenceKey = globalPreferences.getKey();
    }

    public GridGlobalPreferences getGlobalPreferences() {
        return this.globalPreferences;
    }

    public List<GridColumnPreference> getColumnPreferences() {
        return this.columnPreferences;
    }

    public void addGridColumnPreference(GridColumnPreference preference) {
        this.columnPreferences.add(preference);
    }

    public GridSortedColumnPreference getGridSortedColumnPreference() {
        return this.gridSortedColumnPreference;
    }

    public void setGridSortedColumnPreference(GridSortedColumnPreference gridSortedColumnPreference) {
        this.gridSortedColumnPreference = gridSortedColumnPreference;
    }

    public void resetGridColumnPreferences() {
        this.columnPreferences.clear();
    }

    public void resetPageSizePreferences() {
        if (this.globalPreferences != null) {
            this.pageSizePreferences = this.globalPreferences.getPageSize();
        }
    }

    public int getPageSizePreferences() {
        return this.pageSizePreferences;
    }

    public void setPageSizePreferences(int pageSizePreferences) {
        this.pageSizePreferences = pageSizePreferences;
    }

    public String getSelectedFilterKey() {
        return this.selectedFilterKey;
    }

    public void setSelectedFilterKey(String selectedFilterKey) {
        if (!"addFilter".equals(selectedFilterKey)) {
            this.selectedFilterKey = selectedFilterKey;
        }
    }

    public void addCustomFilter(String filterName, HashMap filterParams) {
        this.customFilters.put(filterName, filterParams);
    }

    public HashMap getCustomFilters() {
        return this.customFilters;
    }

    public void removeCustomFilter(String filterName) {
        this.customFilters.remove(filterName);
    }

    public void resetGridPreferences() {
        this.resetPageSizePreferences();
        this.resetGridColumnPreferences();
        this.selectedFilterKey = "";
        this.customFilters.clear();
    }
}

