/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Optional;
import org.drools.mvelcompiler.ast.TypedExpression;

public class BigDecimalArithmeticExprT
implements TypedExpression {
    private final String name;
    private final TypedExpression argument;
    private boolean isNegated;
    private final TypedExpression scope;
    private final Type type = BigDecimal.class;

    public static String toBigDecimalMethod(BinaryExpr.Operator operator) {
        switch (operator) {
            case PLUS: {
                return "add";
            }
            case MINUS: {
                return "subtract";
            }
            case MULTIPLY: {
                return "multiply";
            }
            case DIVIDE: {
                return "divide";
            }
            case REMAINDER: {
                return "remainder";
            }
            case EQUALS: {
                return "equals";
            }
            case NOT_EQUALS: {
                return "equals";
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    public static String toBigDecimalMethod(AssignExpr.Operator operator) {
        switch (operator) {
            case PLUS: {
                return "add";
            }
            case MINUS: {
                return "subtract";
            }
            case MULTIPLY: {
                return "multiply";
            }
            case DIVIDE: {
                return "divide";
            }
            case ASSIGN: {
                return "valueOf";
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    public BigDecimalArithmeticExprT(String bigDecimalMethod, TypedExpression scope, TypedExpression argument, boolean isNegated) {
        this.name = bigDecimalMethod;
        this.scope = scope;
        this.argument = argument;
        this.isNegated = isNegated;
    }

    public BigDecimalArithmeticExprT(String bigDecimalMethod, TypedExpression scope, TypedExpression argument) {
        this(bigDecimalMethod, scope, argument, false);
    }

    @Override
    public Optional<Type> getType() {
        return Optional.of(this.type);
    }

    @Override
    public Node toJavaExpression() {
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)this.scope.toJavaExpression(), this.name, NodeList.nodeList((Node[])new Expression[]{(Expression)this.argument.toJavaExpression()}));
        if (!"valueOf".equals(this.name) && !"equals".equals(this.name)) {
            methodCallExpr.addArgument("java.math.MathContext.DECIMAL128");
        }
        return this.isNegated ? new UnaryExpr((Expression)new EnclosedExpr((Expression)methodCallExpr), UnaryExpr.Operator.LOGICAL_COMPLEMENT) : methodCallExpr;
    }

    public String toString() {
        return "BigDecimalExprT{name='" + this.name + '\'' + ", argument=" + this.argument + ", type=" + this.type + '}';
    }
}

