/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.admin.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.admin.EmailNotification;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.OrgEntities;
import org.kie.server.api.model.admin.TaskNotification;
import org.kie.server.api.model.admin.TaskNotificationList;
import org.kie.server.api.model.admin.TaskReassignment;
import org.kie.server.api.model.admin.TaskReassignmentList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.admin.UserTaskAdminServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class UserTaskAdminServicesClientImpl
extends AbstractKieServicesClientImpl
implements UserTaskAdminServicesClient {
    public UserTaskAdminServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public UserTaskAdminServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public void addPotentialOwners(String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        this.addPotentialOwners(null, containerId, taskId, removeExisting, orgEntities);
    }

    @Override
    public void addPotentialOwners(String userId, String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?remove=" + removeExisting;
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                queryString = queryString + "&user=" + userId;
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/pot-owners", valuesMap) + queryString, orgEntities, null, headers);
        } else {
            Object[] argvs = new Object[]{containerId, taskId, removeExisting};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, removeExisting};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "addPotentialOwners", this.serialize(orgEntities), this.marshaller.getFormat().getType(), argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addExcludedOwners(String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        this.addExcludedOwners(null, containerId, taskId, removeExisting, orgEntities);
    }

    @Override
    public void addExcludedOwners(String userId, String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?remove=" + removeExisting;
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                queryString = queryString + "&user=" + userId;
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/exl-owners", valuesMap) + queryString, orgEntities, null, headers);
        } else {
            Object[] argvs = new Object[]{containerId, taskId, removeExisting};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, removeExisting};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "addExcludedOwners", this.serialize(orgEntities), this.marshaller.getFormat().getType(), argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addBusinessAdmins(String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        this.addBusinessAdmins(null, containerId, taskId, removeExisting, orgEntities);
    }

    @Override
    public void addBusinessAdmins(String userId, String containerId, Long taskId, boolean removeExisting, OrgEntities orgEntities) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?remove=" + removeExisting;
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                queryString = queryString + "&user=" + userId;
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/admins", valuesMap) + queryString, orgEntities, null, headers);
        } else {
            Object[] argvs = new Object[]{containerId, taskId, removeExisting};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, removeExisting};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "addBusinessAdmins", this.serialize(orgEntities), this.marshaller.getFormat().getType(), argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removePotentialOwnerUsers(String containerId, Long taskId, String ... users) {
        this.removePotentialOwnerUsers(null, containerId, taskId, users);
    }

    @Override
    public void removePotentialOwnerUsers(String userId, String containerId, Long taskId, String ... users) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(users).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/pot-owners/users/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(users));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removePotentialOwners", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeExcludedOwnerUsers(String containerId, Long taskId, String ... users) {
        this.removeExcludedOwnerUsers(null, containerId, taskId, users);
    }

    @Override
    public void removeExcludedOwnerUsers(String userId, String containerId, Long taskId, String ... users) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(users).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/exl-owners/users/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(users));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeExcludedOwners", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeBusinessAdminUsers(String containerId, Long taskId, String ... users) {
        this.removeBusinessAdminUsers(null, containerId, taskId, users);
    }

    @Override
    public void removeBusinessAdminUsers(String userId, String containerId, Long taskId, String ... users) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(users).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/admins/users/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(users));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeBusinessAdmins", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removePotentialOwnerGroups(String containerId, Long taskId, String ... groups) {
        this.removePotentialOwnerGroups(null, containerId, taskId, groups);
    }

    @Override
    public void removePotentialOwnerGroups(String userId, String containerId, Long taskId, String ... groups) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(groups).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/pot-owners/groups/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(groups));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removePotentialOwners", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeExcludedOwnerGroups(String containerId, Long taskId, String ... groups) {
        this.removeExcludedOwnerGroups(null, containerId, taskId, groups);
    }

    @Override
    public void removeExcludedOwnerGroups(String userId, String containerId, Long taskId, String ... groups) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(groups).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/exl-owners/groups/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(groups));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeExcludedOwners", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeBusinessAdminGroups(String containerId, Long taskId, String ... groups) {
        this.removeBusinessAdminGroups(null, containerId, taskId, groups);
    }

    @Override
    public void removeBusinessAdminGroups(String userId, String containerId, Long taskId, String ... groups) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("entityId", Arrays.stream(groups).collect(Collectors.joining(",")));
            String queryString = this.getUserQueryStr(BYPASS_AUTH_USER != false && userId != null ? userId : null);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/admins/groups/{entityId}", valuesMap) + queryString, null);
        } else {
            ArrayList<String> entities = new ArrayList<String>(Arrays.asList(groups));
            Object[] argvs = new Object[]{containerId, taskId, entities, true};
            if (BYPASS_AUTH_USER.booleanValue() && userId != null) {
                argvs = new Object[]{userId, containerId, taskId, entities, true};
            }
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeBusinessAdmins", argvs)));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void addTaskInputs(String containerId, Long taskId, Map<String, Object> data) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/contents/input", valuesMap), data, null, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "addTaskInputs", this.serialize(this.safeMap(data)), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeTaskInputs(String containerId, Long taskId, String ... inputs) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(inputs));
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = this.getAdditionalParams("", "name", names);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/contents/input", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeTaskInputs", new Object[]{containerId, taskId, names})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void removeTaskOutputs(String containerId, Long taskId, String ... outputs) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(outputs));
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = this.getAdditionalParams("", "name", names);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/contents/output", valuesMap) + queryString, null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "removeTaskOutputs", new Object[]{containerId, taskId, names})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public Long reassignWhenNotStarted(String containerId, Long taskId, String expiresAt, OrgEntities orgEntities) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?expiresAt=" + expiresAt + "&whenNotStarted=true";
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/reassignments", valuesMap) + queryString, orgEntities, Object.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "reassignWhenNotStarted", this.serialize(orgEntities), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, expiresAt})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Long reassignWhenNotCompleted(String containerId, Long taskId, String expiresAt, OrgEntities orgEntities) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?expiresAt=" + expiresAt + "&whenNotCompleted=true";
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/reassignments", valuesMap) + queryString, orgEntities, Object.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "reassignWhenNotCompleted", this.serialize(orgEntities), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, expiresAt})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Long notifyWhenNotStarted(String containerId, Long taskId, String expiresAt, EmailNotification emailNotification) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?expiresAt=" + expiresAt + "&whenNotStarted=true";
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/notifications", valuesMap) + queryString, emailNotification, Object.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "notifyWhenNotStarted", this.serialize(emailNotification), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, expiresAt})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public Long notifyWhenNotCompleted(String containerId, Long taskId, String expiresAt, EmailNotification emailNotification) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queryString = "?expiresAt=" + expiresAt + "&whenNotCompleted=true";
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/notifications", valuesMap) + queryString, emailNotification, Object.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "notifyWhenNotCompleted", this.serialize(emailNotification), this.marshaller.getFormat().getType(), new Object[]{containerId, taskId, expiresAt})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = this.deserialize((String)response.getResult(), Object.class);
        }
        if (result instanceof Wrapped) {
            return (Long)((Wrapped)result).unwrap();
        }
        return ((Number)result).longValue();
    }

    @Override
    public void cancelNotification(String containerId, Long taskId, Long notificationId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("notificationId", notificationId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/notifications/{notificationId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "cancelNotification", new Object[]{containerId, taskId, notificationId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void cancelReassignment(String containerId, Long taskId, Long reassignmentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            valuesMap.put("reassignmentId", reassignmentId);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/reassignments/{reassignmentId}", valuesMap), null);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "cancelReassignment", new Object[]{containerId, taskId, reassignmentId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<TaskNotification> getTaskNotifications(String containerId, Long taskId, boolean activeOnly) {
        TaskNotificationList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = "?activeOnly=" + activeOnly;
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/notifications", valuesMap) + queryString, TaskNotificationList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getTaskNotifications", new Object[]{containerId, taskId, activeOnly})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (TaskNotificationList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<TaskReassignment> getTaskReassignments(String containerId, Long taskId, boolean activeOnly) {
        TaskReassignmentList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = "?activeOnly=" + activeOnly;
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/reassignments", valuesMap) + queryString, TaskReassignmentList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getTaskReassignments", new Object[]{containerId, taskId, activeOnly})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (TaskReassignmentList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExecutionErrorInstance> getTaskErrors(String containerId, boolean includeAcknowledged, Integer page, Integer pageSize) {
        ExecutionErrorInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            String queryString = "?includeAck=" + includeAcknowledged;
            queryString = this.getPagingQueryString(queryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/errors", valuesMap) + queryString, ExecutionErrorInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getExecutionErrorsByTaskName", new Object[]{containerId, "", "", includeAcknowledged, page, pageSize, "", true})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExecutionErrorInstance> getErrorsByTaskId(String containerId, Long taskId, boolean includeAcknowledged, Integer page, Integer pageSize) {
        ExecutionErrorInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("taskInstanceId", taskId);
            String queryString = "?includeAck=" + includeAcknowledged;
            queryString = this.getPagingQueryString(queryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/{taskInstanceId}/errors", valuesMap) + queryString, ExecutionErrorInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getExecutionErrorsByTaskId", new Object[]{containerId, taskId, includeAcknowledged, page, pageSize, "", true})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExecutionErrorInstance> getErrorsByTaskInfo(String containerId, Long processId, String taskName, boolean includeAcknowledged, Integer page, Integer pageSize) {
        ExecutionErrorInstanceList result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            String queryString = "?includeAck=" + includeAcknowledged + "&name=" + taskName + "&process=" + processId;
            queryString = this.getPagingQueryString(queryString, page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/errors", valuesMap) + queryString, ExecutionErrorInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getExecutionErrorsByTaskName", new Object[]{containerId, processId, taskName, includeAcknowledged, page, pageSize, "", true})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstanceList)response.getResult();
        }
        if (result != null && result.getItems() != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public void acknowledgeError(String containerId, String ... errorId) {
        ArrayList<String> errorIds = new ArrayList<String>(Arrays.asList(errorId));
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            HashMap<String, String> headers = new HashMap<String, String>();
            String endpoint = "errors/{errorId}";
            String queryString = "";
            if (errorIds.size() > 1) {
                endpoint = "errors";
                queryString = this.getAdditionalParams(queryString, "errorId", errorIds);
            } else {
                valuesMap.put("errorId", errorIds.get(0));
            }
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)("admin/containers/{containerId}/tasks/" + endpoint), valuesMap) + queryString, "", String.class, headers);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "acknowledgeError", new Object[]{this.safeList(errorIds)})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM", containerId).getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public ExecutionErrorInstance getError(String containerId, String errorId) {
        ExecutionErrorInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("errorId", errorId);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/tasks/errors/{errorId}", valuesMap), ExecutionErrorInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("UserTaskAdminService", "getError", new Object[]{errorId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (ExecutionErrorInstance)response.getResult();
        }
        return result;
    }
}

