/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.kie.internal.runtime.Closeable;

public abstract class AbstractEventSupport<E extends EventListener>
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private List<E> listeners = new CopyOnWriteArrayList();
    private volatile boolean hasListeners = false;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listeners = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listeners);
    }

    public <O> void notifyAllListeners(O event, BiConsumer<E, O> consumer) {
        if (this.listeners.size() == 1) {
            consumer.accept((EventListener)this.listeners.get(0), event);
        } else {
            for (EventListener listener : this.listeners) {
                consumer.accept(listener, event);
            }
        }
    }

    protected boolean hasListeners() {
        return this.hasListeners;
    }

    public final synchronized void addEventListener(E listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.hasListeners = true;
        }
    }

    public final synchronized void removeEventListener(Class cls) {
        int listenerIndex = 0;
        while (listenerIndex < this.listeners.size()) {
            EventListener listener = (EventListener)this.listeners.get(listenerIndex);
            if (cls.isAssignableFrom(listener.getClass())) {
                this.listeners.remove(listenerIndex);
                continue;
            }
            ++listenerIndex;
        }
        this.hasListeners = !this.listeners.isEmpty();
    }

    public final void removeEventListener(E listener) {
        this.listeners.remove(listener);
        this.hasListeners = !this.listeners.isEmpty();
    }

    public List<E> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void clear() {
        for (EventListener listener : this.listeners) {
            if (!(listener instanceof Closeable)) continue;
            ((Closeable)listener).close();
        }
        this.listeners.clear();
    }
}

