/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.Constant;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLConstantFactory {
    static final String KIE_PMML_CONSTANT_TEMPLATE_JAVA = "KiePMMLConstantTemplate.tmpl";
    static final String KIE_PMML_CONSTANT_TEMPLATE = "KiePMMLConstantTemplate";
    static final String GETKIEPMMLCONSTANT = "getKiePMMLConstant";
    static final String CONSTANT = "constant";
    static final ClassOrInterfaceDeclaration CONSTANT_TEMPLATE;

    private KiePMMLConstantFactory() {
    }

    static BlockStmt getConstantVariableDeclaration(String variableName, Constant constant) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)CONSTANT_TEMPLATE.getMethodsByName(GETKIEPMMLCONSTANT).get(0)).clone();
        BlockStmt toReturn = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(toReturn, CONSTANT).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", CONSTANT, toReturn)));
        variableDeclarator.setName(variableName);
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", CONSTANT, toReturn)))).asObjectCreationExpr();
        StringLiteralExpr nameExpr = new StringLiteralExpr(variableName);
        Expression valueExpr = CommonCodegenUtils.getExpressionForObject(constant.getValue());
        objectCreationExpr.getArguments().set(0, (Node)nameExpr);
        objectCreationExpr.getArguments().set(2, (Node)valueExpr);
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_CONSTANT_TEMPLATE_JAVA);
        CONSTANT_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_CONSTANT_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLConstantTemplate"));
        ((MethodDeclaration)CONSTANT_TEMPLATE.getMethodsByName(GETKIEPMMLCONSTANT).get(0)).clone();
    }
}

