/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.process.workitem.core.util.WorkItemHeaderInfo;
import org.kie.api.runtime.process.WorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemHeaderUtils {
    private static final String CONTENT_PREFIX = "HEADER_";
    private static final String PARAM_PREFIX = "HEADER_PARAM_";
    static final String SEPARATOR_PROP = "org.kie.workitem.ws.header.separator";
    private static final Logger logger = LoggerFactory.getLogger(WorkItemHeaderUtils.class);

    private WorkItemHeaderUtils() {
    }

    public static Collection<WorkItemHeaderInfo> getHeaderInfo(WorkItem workItem) {
        String separator = System.getProperty(SEPARATOR_PROP, "_");
        HashMap<String, WorkItemHeaderInfo.Builder> map = new HashMap<String, WorkItemHeaderInfo.Builder>();
        for (Map.Entry param : workItem.getParameters().entrySet()) {
            String key = ((String)param.getKey()).toUpperCase();
            if (key.startsWith(PARAM_PREFIX)) {
                key = ((String)param.getKey()).substring(PARAM_PREFIX.length());
                int indexOf = key.indexOf(separator);
                if (indexOf != -1) {
                    map.computeIfAbsent(key.substring(indexOf + separator.length()), WorkItemHeaderInfo.Builder::of).withParam(key.substring(0, indexOf), param.getValue());
                    continue;
                }
                logger.warn("Wrong parameter name {}. It expects at least one {} in {}", new Object[]{param.getKey(), separator, key});
                continue;
            }
            if (!key.startsWith(CONTENT_PREFIX)) continue;
            map.computeIfAbsent(((String)param.getKey()).substring(CONTENT_PREFIX.length()), WorkItemHeaderInfo.Builder::of).withContent(param.getValue());
        }
        return map.values().stream().map(WorkItemHeaderInfo.Builder::build).collect(Collectors.toList());
    }
}

