/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.security;

import java.nio.file.Paths;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.services.task.identity.AbstractUserGroupInfo;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.kie.api.task.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ElytronUserGroupCallbackImpl
extends AbstractUserGroupInfo
implements UserGroupCallback {
    public static final Logger logger = LoggerFactory.getLogger(ElytronUserGroupCallbackImpl.class);
    private static final String FOLDER_PATH = "org.kie.server.services.jbpm.security.filesystemrealm.folder-path";
    private static final String ENCODING = "org.kie.server.services.jbpm.security.filesystemrealm.encoded";
    private static final String LEVELS = "org.kie.server.services.jbpm.security.filesystemrealm.levels";
    public static final String DEFAULT_FILE_SYSTEM_REALM_PATH = System.getProperty("jboss.server.config.dir") + "/kie-fs-realm-users";
    public static final Integer DEFAULT_FILE_SYSTEM_LEVELS = 2;
    public static final Boolean DEFAULT_FILE_SYSTEM_ENCODED = true;
    private final String folderPath;
    private final int levels;
    private final boolean encoded;
    private ServiceLoader<UserGroupAdapter> ugAdapterServiceLoader = ServiceLoader.load(UserGroupAdapter.class);
    private static final ThreadLocal<UserGroupAdapter> externalUserGroupAdapterLocal = new ThreadLocal();

    public ElytronUserGroupCallbackImpl() {
        this.folderPath = System.getProperty(FOLDER_PATH, DEFAULT_FILE_SYSTEM_REALM_PATH);
        this.levels = this.getLevels();
        this.encoded = this.getEncoded();
    }

    private boolean getEncoded() {
        try {
            return Boolean.valueOf(System.getProperty(ENCODING, DEFAULT_FILE_SYSTEM_ENCODED.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_FILE_SYSTEM_ENCODED;
        }
    }

    private int getLevels() {
        try {
            return Integer.valueOf(System.getProperty(LEVELS, DEFAULT_FILE_SYSTEM_LEVELS.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_FILE_SYSTEM_LEVELS;
        }
    }

    public boolean existsUser(String userId) {
        return true;
    }

    public boolean existsGroup(String groupId) {
        return true;
    }

    public static void addExternalUserGroupAdapter(UserGroupAdapter externalUserGroupAdapter) {
        if (externalUserGroupAdapterLocal.get() != null) {
            UserGroupAdapter adapter = externalUserGroupAdapterLocal.get();
            throw new IllegalStateException("The external UserGroupAdapter has already been set! (" + adapter.getClass().getName() + ")");
        }
        externalUserGroupAdapterLocal.set(externalUserGroupAdapter);
    }

    public static void clearExternalUserGroupAdapter() {
        externalUserGroupAdapterLocal.set(null);
    }

    public List<String> getGroupsForUser(String userId) {
        UserGroupAdapter adapter;
        HashSet<String> result = new HashSet<String>();
        try {
            FileSystemSecurityRealm realm = this.getRealm();
            ModifiableRealmIdentity identity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userId));
            for (String role : identity.getAttributes().get("role")) {
                result.add(role);
            }
        }
        catch (RealmUnavailableException e) {
            for (UserGroupAdapter adapter2 : this.ugAdapterServiceLoader) {
                logger.debug("Adding roles from UserGroupAdapter service ({})", (Object)adapter2.getClass().getSimpleName());
                List userRoles = adapter2.getGroupsForUser(userId);
                if (userRoles == null) continue;
                result.addAll(userRoles);
            }
        }
        if ((adapter = externalUserGroupAdapterLocal.get()) != null) {
            logger.debug("Adding roles from external UserGroupAdapter ({})", (Object)adapter.getClass().getSimpleName());
            List userRoles = adapter.getGroupsForUser(userId);
            if (userRoles != null) {
                result.addAll(userRoles);
            }
        }
        return new ArrayList<String>(result);
    }

    private FileSystemSecurityRealm getRealm() {
        return new FileSystemSecurityRealm(Paths.get(this.folderPath, new String[0]), NameRewriter.IDENTITY_REWRITER, this.levels, this.encoded);
    }
}

