/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.jbpm.persistence.api.integration.EventManagerProvider;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.persistence.api.integration.PersistenceEventManager;
import org.jbpm.persistence.api.integration.model.TaskOperationView;
import org.jbpm.process.audit.ArchiveLoggerProvider;
import org.jbpm.process.audit.AuditLoggerArchiveTreat;
import org.jbpm.services.task.audit.TaskLifeCycleEventConstants;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.variable.TaskIndexerManager;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.persistence.JPATaskPersistenceContext;
import org.jbpm.services.task.persistence.PersistableEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPATaskLifeCycleEventListener
extends PersistableEventListener
implements TaskLifeCycleEventListener,
AuditLoggerArchiveTreat {
    public static final String METADATA_TASK_EVENT = "TASK_EVENT";
    public static final String METADATA_AUDIT_TASK = "TASK_AUDIT_EVENT";
    public static final String METADATA_VAR_EVENT = "TASK_VAR_EVENT";
    private static final Logger logger = LoggerFactory.getLogger(JPATaskLifeCycleEventListener.class);
    private List<ArchiveLoggerProvider> archiveLoggerProviders = this.initArchiveLoggerProvider();

    public JPATaskLifeCycleEventListener(boolean flag) {
        super(null);
    }

    public JPATaskLifeCycleEventListener(EntityManagerFactory emf) {
        super(emf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskStartedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STARTED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.STARTED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskActivatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.ACTIVATED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskClaimedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.CLAIMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.CLAIMED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskSkippedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SKIPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.SKIPPED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskStoppedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STOPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.STOPPED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskCompletedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.COMPLETED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            this.archiveLoggerProviders.forEach(e -> e.archive(((JPATaskPersistenceContext)persistenceContext).getEntityManager(), (org.kie.internal.task.api.model.TaskEvent)taskEventImpl));
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.COMPLETED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            this.archiveLoggerProviders.forEach(e -> e.archive(((JPATaskPersistenceContext)persistenceContext).getEntityManager(), (AuditTask)auditTaskImpl));
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskFailedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FAILED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.FAILED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskAddedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            if (ti.getTaskData().getProcessId() != null) {
                userId = ti.getTaskData().getProcessId();
            }
            AuditTaskImpl auditTaskImpl = new AuditTaskImpl(ti.getId(), ti.getName(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ti.getTaskData().getActualOwner() != null ? ti.getTaskData().getActualOwner().getId() : "", ti.getDescription(), ti.getPriority(), ti.getTaskData().getCreatedBy() != null ? ti.getTaskData().getCreatedBy().getId() : "", ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getDeploymentId(), ti.getTaskData().getParentId(), ti.getTaskData().getWorkItemId(), event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.persist((Object)auditTaskImpl);
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ADDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.ADDED);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskExitedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.EXITED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.EXITED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskReleasedEvent(TaskEvent event) {
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskResumedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RESUMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.RESUMED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskSuspendedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SUSPENDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.SUSPENDED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskForwardedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            StringBuilder message = new StringBuilder();
            String entitiesAsString = ti.getPeopleAssignments().getPotentialOwners().stream().map(oe -> oe.getId()).collect(Collectors.joining(","));
            message.append("Forward to [" + entitiesAsString + "]");
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FORWARDED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message.toString());
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.FORWARDED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskDelegatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.DELEGATED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskNominatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.NOMINATED, userId, new Date());
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.NOMINATED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    protected AuditTaskImpl getAuditTask(TaskEvent event, TaskPersistenceContext persistenceContext, Task ti) {
        AuditTaskImpl auditTaskImpl = (AuditTaskImpl)persistenceContext.queryWithParametersInTransaction("getAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(AuditTaskImpl.class));
        return auditTaskImpl;
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTaskReleasedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RELEASED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.RELEASED);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof JPATaskLifeCycleEventListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)((Object)this)).getClass().getName().hashCode();
        return result;
    }

    public void beforeTaskUpdatedEvent(TaskEvent event) {
    }

    public String getUpdateFieldLog(String fieldName, String previousValue, String value) {
        return "Updated " + fieldName + " {From: '" + (previousValue != null ? previousValue : "") + "' to: '" + (value != null ? value : "") + "'}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskUpdatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl;
            String message;
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            if (ti.getDescription() != null && !ti.getDescription().equals(auditTaskImpl.getDescription()) || ti.getDescription() == null && auditTaskImpl.getDescription() != null) {
                message = this.getUpdateFieldLog("Description", auditTaskImpl.getDescription(), ti.getDescription());
                taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message);
                event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
                persistenceContext.persist((Object)taskEventImpl);
                this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED);
            }
            if (ti.getName() != null && !ti.getName().equals(auditTaskImpl.getName()) || ti.getName() == null && auditTaskImpl.getName() != null) {
                message = this.getUpdateFieldLog("Name", auditTaskImpl.getName(), ti.getName());
                taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message);
                event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
                persistenceContext.persist((Object)taskEventImpl);
                this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED);
            }
            if (auditTaskImpl.getPriority() != ti.getPriority().intValue()) {
                message = this.getUpdateFieldLog("Priority", String.valueOf(auditTaskImpl.getPriority()), String.valueOf(ti.getPriority()));
                taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message);
                event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
                persistenceContext.persist((Object)taskEventImpl);
                this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED);
            }
            if (auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() != null && auditTaskImpl.getDueDate().getTime() != ti.getTaskData().getExpirationTime().getTime() || auditTaskImpl.getDueDate() == null && ti.getTaskData().getExpirationTime() != null || auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() == null) {
                String fromDate = auditTaskImpl.getDueDate() != null ? new Date(auditTaskImpl.getDueDate().getTime()).toString() : null;
                String toDate = ti.getTaskData().getExpirationTime() != null ? ti.getTaskData().getExpirationTime().toString() : "";
                String message2 = this.getUpdateFieldLog("DueDate", fromDate, toDate);
                TaskEventImpl taskEventImpl2 = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message2);
                event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl2);
                persistenceContext.persist((Object)taskEventImpl2);
                this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED);
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskReassignedEvent(TaskEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskReassignedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            TaskEventImpl taskEventImpl = new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId);
            event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
            persistenceContext.persist((Object)taskEventImpl);
            this.createTaskOperationView(event, TaskEvent.TaskEventType.DELEGATED);
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskOutputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        String userId = event.getTaskContext().getUserId();
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", TaskVariable.VariableType.OUTPUT);
        params.put("taskId", task.getId());
        int removed = persistenceContext.executeUpdate("DeleteTaskVariableForTask", params);
        logger.debug("Deleted {} output variables logs for task id {}", (Object)removed, (Object)task.getId());
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.indexAndPersistVariables(event, task, variables, persistenceContext, TaskVariable.VariableType.OUTPUT);
        String message = "Task output data updated";
        TaskEventImpl taskEventImpl = new TaskEventImpl(task.getId(), TaskEvent.TaskEventType.UPDATED, (Long)task.getTaskData().getProcessInstanceId(), (Long)task.getTaskData().getWorkItemId(), userId, message);
        event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
        persistenceContext.persist((Object)taskEventImpl);
        this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED);
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, task);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)task.getId(), (Object)task.getName());
            return;
        }
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        event.getMetadata().put(METADATA_AUDIT_TASK, auditTaskImpl);
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskInputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        this.indexAndPersistVariables(event, task, variables, persistenceContext, TaskVariable.VariableType.INPUT);
    }

    protected void indexAndPersistVariables(TaskEvent event, Task task, Map<String, Object> variables, TaskPersistenceContext persistenceContext, TaskVariable.VariableType type) {
        TaskIndexerManager manager = TaskIndexerManager.get();
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            if (TaskLifeCycleEventConstants.SKIPPED_TASK_VARIABLES.contains(variable.getKey()) || variable.getValue() == null) continue;
            List<TaskVariable> taskVars = manager.index(task, variable.getKey(), variable.getValue());
            event.getMetadata().put(METADATA_VAR_EVENT, taskVars);
            if (taskVars == null) continue;
            for (TaskVariable tVariable : taskVars) {
                tVariable.setType(type);
                persistenceContext.persist((Object)tVariable);
            }
        }
    }

    public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpadted(event, type, entities, "] have been added");
    }

    public void afterTaskAssignmentsRemovedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpadted(event, type, entities, "] have been removed");
    }

    protected void assignmentsUpadted(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, String messageSufix) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        String userId = event.getTaskContext().getUserId();
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        StringBuilder message = new StringBuilder();
        switch (type) {
            case POT_OWNER: {
                message.append("Potential owners [");
                break;
            }
            case EXCL_OWNER: {
                message.append("Excluded owners [");
                break;
            }
            case ADMIN: {
                message.append("Business administrators [");
                break;
            }
        }
        String entitiesAsString = entities.stream().map(oe -> oe.getId()).collect(Collectors.joining(","));
        message.append(entitiesAsString);
        message.append(messageSufix);
        TaskEventImpl taskEventImpl = new TaskEventImpl(task.getId(), TaskEvent.TaskEventType.UPDATED, (Long)task.getTaskData().getProcessInstanceId(), (Long)task.getTaskData().getWorkItemId(), userId, message.toString());
        event.getMetadata().put(METADATA_TASK_EVENT, taskEventImpl);
        persistenceContext.persist((Object)taskEventImpl);
        this.createTaskOperationView(event, TaskEvent.TaskEventType.UPDATED, type);
    }

    protected String getActualOwner(Task ti) {
        String userId = "";
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        return userId;
    }

    private void createTaskOperationView(TaskEvent event, TaskEvent.TaskEventType type) {
        this.createTaskOperationView(event, type, null);
    }

    private void createTaskOperationView(TaskEvent event, TaskEvent.TaskEventType type, TaskLifeCycleEventListener.AssignmentType assignType) {
        PersistenceEventManager eventManager = EventManagerProvider.getInstance().get();
        if (eventManager.isActive()) {
            eventManager.update((InstanceView)new TaskOperationView(event, type, assignType));
        }
    }
}

