/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.kie.server.api.security.SecurityAdapter;
import org.kie.server.services.impl.security.BaseIdentityProvider;

public class JACCIdentityProvider
extends BaseIdentityProvider {
    public String getName() {
        Set<Principal> principals;
        if (!this.contextUsers.isEmpty()) {
            return (String)this.contextUsers.peek();
        }
        Subject subject = JACCIdentityProvider.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            for (Principal principal : principals) {
                if (!this.supportedPrincipal(principal)) continue;
                return principal.getName();
            }
        }
        return this.getNameFromAdapter();
    }

    public List<String> getRoles() {
        Set<Principal> principals;
        if (!this.contextUsers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> roles = new ArrayList<String>();
        Subject subject = JACCIdentityProvider.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            roles = new ArrayList();
            for (Principal principal : principals) {
                if (!(principal instanceof Group)) continue;
                Enumeration groups = ((Group)principal).members();
                while (groups.hasMoreElements()) {
                    Principal groupPrincipal = (Principal)groups.nextElement();
                    roles.add(groupPrincipal.getName());
                }
                break block0;
            }
        }
        roles.addAll(this.getRolesFromAdapter());
        return roles;
    }

    public boolean hasRole(String s) {
        Set<Principal> principals;
        Subject subject = JACCIdentityProvider.getSubjectFromContainer();
        if (subject != null && (principals = subject.getPrincipals()) != null) {
            for (Principal principal : principals) {
                if (!(principal instanceof Group)) continue;
                Enumeration groups = ((Group)principal).members();
                while (groups.hasMoreElements()) {
                    Principal groupPrincipal = (Principal)groups.nextElement();
                    if (!groupPrincipal.getName().equals(s)) continue;
                    return true;
                }
                break block0;
            }
        }
        for (SecurityAdapter adapter : this.adapters) {
            List adapterRoles = adapter.getRoles(new Object[0]);
            if (adapterRoles == null || !adapterRoles.contains(s)) continue;
            return true;
        }
        return false;
    }

    protected static Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean supportedPrincipal(Principal principal) {
        return !(principal instanceof Group) && !principal.getClass().getName().endsWith("BasicAuthorizationPrincipal");
    }
}

