/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl.converters;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.lucene.search.TermQuery;
import org.uberfire.ext.metadata.backend.infinispan.ickl.FieldConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.QueryConverter;

public class TermQueryConverter
implements QueryConverter {
    private final TermQuery query;
    private final FieldConverter fieldConverter;
    private final List<String> basicAttrs = Arrays.asList("id", "type", "cluster.id", "segment.id", "key");

    public TermQueryConverter(TermQuery query, FieldConverter fieldConverter) {
        this.query = query;
        this.fieldConverter = fieldConverter;
    }

    @Override
    public String convert() {
        String key = this.fieldConverter.convertKey(this.query.getTerm().field());
        String value = this.fieldConverter.convertValue(this.query.getTerm().text());
        return key + this.getOperator(this.query.getTerm().field()) + this.convertValue(value);
    }

    private String getOperator(String key) {
        return this.basicAttrs.contains(key) ? "=" : ":";
    }

    private String convertValue(String value) {
        if (NumberUtils.isNumber((String)value) || BooleanUtils.toBooleanObject((String)value) != null) {
            return value;
        }
        return "'" + value + "'";
    }
}

