/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.IndexBuilder;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GitKeepFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(GitKeepFileIndexer.class);
    private static final String KEEP_FILE = ".gitkeep";

    @Override
    protected IndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieModule module = this.getModule(path);
        if (module == null) {
            logger.error("Unable to index {0}: module could not be resolved.", (Object)path.toUri().toString());
            return null;
        }
        Package pkg = this.getPackage(path);
        if (pkg == null) {
            logger.error("Unable to index {0}: package could not be resolved.", (Object)path.toUri().toString());
            return null;
        }
        return new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), (Module)module, pkg);
    }

    public boolean supportsPath(Path path) {
        return Objects.equals(path.getFileName().toString(), KEEP_FILE);
    }

    protected KieModule getModule(Path path) {
        return (KieModule)this.moduleService.resolveModule(Paths.convert((Path)path));
    }

    protected Package getPackage(Path path) {
        return this.moduleService.resolvePackage(Paths.convert((Path)path));
    }
}

