/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepositoryService;
import org.guvnor.m2repo.utils.FileNameUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GuvnorM2Repository {
    private static final Logger log = LoggerFactory.getLogger(GuvnorM2Repository.class);
    private static final int BUFFER_SIZE = 1024;
    protected static final String META_INF = "META-INF";
    private static final String MAVEN = "maven";
    private static final String META_INF_MAVEN = "META-INF/maven";
    private static final String POM = "pom";
    private static final String POM_XML = "pom.xml";
    private static final String POM_PROPERTIES = "pom.properties";
    private static final String GROUP_ID_NAME = "groupId";
    private static final String ARTIFACT_ID_NAME = "artifactId";
    private static final String VERSION_NAME = "version";
    protected static final String KMODULE_XML = "kmodule.xml";
    protected static final String KIE_DEPLOYMENT_DESCRIPTOR_XML = "kie-deployment-descriptor.xml";
    private final List<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
    private final List<ArtifactRepository> pomRepositories = new ArrayList<ArtifactRepository>();
    private ArtifactRepositoryService artifactRepositoryFactory;

    public GuvnorM2Repository() {
    }

    @Inject
    public GuvnorM2Repository(ArtifactRepositoryService factory) {
        this.artifactRepositoryFactory = factory;
    }

    @PostConstruct
    public void init() {
        this.setM2Repos();
    }

    private void setM2Repos() {
        this.repositories.addAll(this.artifactRepositoryFactory.getRepositories());
        this.pomRepositories.addAll(this.artifactRepositoryFactory.getPomRepositories());
    }

    public String getM2RepositoryDir(String repositoryName) {
        return this.getM2RepositoryRootDir(repositoryName).replaceAll(Matcher.quoteReplacement(File.separator) + "$", "");
    }

    public String getM2RepositoryRootDir(String repositoryName) {
        String defaultName = "global-m2-repo";
        if (repositoryName != null && !repositoryName.isEmpty()) {
            defaultName = repositoryName;
        }
        String name = defaultName;
        ArtifactRepository repository = this.getArtifactRepository(name);
        String rootDir = repository.getRootDir();
        if (!repository.getRootDir().endsWith(File.separator)) {
            return rootDir + File.separator;
        }
        return rootDir;
    }

    private ArtifactRepository getArtifactRepository(String name) {
        return this.repositories.stream().filter(artifactRepository -> artifactRepository.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Repository %s not found", name)));
    }

    public String getRepositoryURL(String repositoryName) {
        File file = new File(this.getM2RepositoryRootDir(repositoryName));
        return "file://" + file.getAbsolutePath();
    }

    public void deployArtifact(InputStream jarStream, GAV gav, boolean includeAdditionalRepositories) {
        this.deployArtifact(jarStream, gav, includeAdditionalRepositories, repo -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployArtifact(InputStream jarStream, GAV gav, boolean includeAdditionalRepositories, Predicate<ArtifactRepository> filter) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, "jar"));
        try {
            String pomProperties;
            this.inputStreamToFile(jarStream, jarFile);
            String pomXML = GuvnorM2Repository.loadPomFromJar(new File(jarFile.getPath()));
            if (pomXML == null) {
                pomXML = this.generatePOM(gav);
                jarFile = this.appendFileToJar(pomXML, this.getPomXmlPath(gav), jarFile.getPath());
            }
            if ((pomProperties = this.loadGAVFromJarInternal(new File(jarFile.getPath()))) == null) {
                pomProperties = GuvnorM2Repository.generatePomProperties(gav);
                jarFile = this.appendFileToJar(pomProperties, this.getPomPropertiesPath(gav), jarFile.getPath());
            }
            this.deployArtifact(gav, pomXML, jarFile, includeAdditionalRepositories, filter);
        }
        finally {
            try {
                jarFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + jarFile.getAbsolutePath() + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployPom(InputStream pomStream, GAV gav) {
        File pomFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, POM));
        try {
            this.inputStreamToFile(pomStream, pomFile);
            this.deployPom(gav, pomFile);
        }
        finally {
            try {
                pomFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + pomFile.getAbsolutePath() + "'");
            }
        }
    }

    private void inputStreamToFile(InputStream inputStream, File file) {
        OutputStream fos = null;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int byteRead = 0;
            while ((byteRead = inputStream.read(buf)) != -1) {
                ((FileOutputStream)fos).write(buf, 0, byteRead);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    log.error("Error occurred when trying to close stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployParentPom(GAV gav) {
        File pomXMLFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, POM_XML));
        try {
            String pomXML = this.generateParentPOM(gav);
            this.writeStringIntoFile(pomXML, pomXMLFile);
            DefaultArtifact pomXMLArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), POM, gav.getVersion());
            DefaultArtifact finalPomXMLArtifact = pomXMLArtifact = pomXMLArtifact.setFile(pomXMLFile);
            this.pomRepositories.forEach(arg_0 -> GuvnorM2Repository.lambda$deployParentPom$3(pomXML, (Artifact)finalPomXMLArtifact, arg_0));
        }
        finally {
            try {
                pomXMLFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + pomXMLFile.getAbsolutePath() + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployArtifact(GAV gav, String pomXML, File jarFile, boolean includeAdditionalRepositories, Predicate<ArtifactRepository> filter) {
        File pomXMLFile = new File(System.getProperty("java.io.tmpdir"), this.toFileName(gav, POM_XML));
        try {
            this.writeStringIntoFile(pomXML, pomXMLFile);
            DefaultArtifact jarArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "jar", gav.getVersion());
            jarArtifact = jarArtifact.setFile(jarFile);
            SubArtifact pomXMLArtifact = new SubArtifact((Artifact)jarArtifact, "", POM);
            pomXMLArtifact = pomXMLArtifact.setFile(pomXMLFile);
            DefaultArtifact finalJarArtifact = jarArtifact;
            SubArtifact finalPomXMLArtifact = pomXMLArtifact;
            this.repositories.stream().filter(filter).forEach(arg_0 -> GuvnorM2Repository.lambda$deployArtifact$4(pomXML, (Artifact)finalJarArtifact, (Artifact)finalPomXMLArtifact, arg_0));
            if (!includeAdditionalRepositories) {
                return;
            }
        }
        finally {
            try {
                pomXMLFile.delete();
            }
            catch (Exception e) {
                log.warn("Unable to remove temporary file '" + pomXMLFile.getAbsolutePath() + "'");
            }
        }
    }

    private void writeStringIntoFile(String string, File file) {
        OutputStream fos = null;
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            IOUtils.write((String)string, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    log.error("Error occurred trying to close a stream", (Throwable)e);
                }
            }
        }
    }

    private void deployPom(GAV gav, File pomFile) {
        DefaultArtifact pomArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), POM, gav.getVersion());
        DefaultArtifact finalPomArtifact = pomArtifact = pomArtifact.setFile(pomFile);
        this.pomRepositories.forEach(arg_0 -> GuvnorM2Repository.lambda$deployPom$5((Artifact)finalPomArtifact, arg_0));
    }

    public Collection<File> listFiles() {
        return this.listFiles(null);
    }

    public List<File> listFiles(String filters) {
        return this.listFiles(filters, null);
    }

    public List<File> listFiles(String filters, List<String> fileFormats) {
        ArrayList<String> wildcards = new ArrayList<String>();
        String wildcardPrefix = "";
        if (filters != null) {
            wildcardPrefix = "*" + filters;
        }
        if (fileFormats == null) {
            fileFormats = new ArrayList<String>();
            fileFormats.add("jar");
            fileFormats.add("kjar");
            fileFormats.add(POM);
        }
        for (String fileFormat : fileFormats) {
            wildcards.add(wildcardPrefix + "*." + fileFormat);
        }
        ArrayList<File> files = new ArrayList<File>(this.getFiles(wildcards));
        return files;
    }

    public List<Artifact> listArtifacts(String filters, List<String> fileFormats) {
        ArrayList<String> wildcards = new ArrayList<String>();
        String wildcardPrefix = "";
        if (filters != null) {
            wildcardPrefix = "*" + filters;
        }
        if (fileFormats == null) {
            fileFormats = new ArrayList<String>();
            fileFormats.add("jar");
            fileFormats.add("kjar");
            fileFormats.add(POM);
        }
        for (String fileFormat : fileFormats) {
            wildcards.add(wildcardPrefix + "*." + fileFormat);
        }
        ArrayList<Artifact> files = new ArrayList<Artifact>(this.getArtifacts(wildcards));
        return files;
    }

    protected Collection<File> getFiles(List<String> wildcards) {
        return this.repositories.stream().flatMap(artifactRepository -> artifactRepository.listFiles(wildcards).stream()).collect(Collectors.toList());
    }

    protected Collection<Artifact> getArtifacts(List<String> wildcards) {
        return this.repositories.stream().flatMap(artifactRepository -> artifactRepository.listArtifacts(wildcards).stream()).collect(Collectors.toList());
    }

    public String getPomText(String path) {
        ArtifactRepository repository = this.getArtifactRepository("global-m2-repo");
        File file = new File(repository.getRootDir(), path);
        String normalizedPath = file.toPath().normalize().toString();
        if (FileNameUtilities.isJar((String)normalizedPath) || FileNameUtilities.isKJar((String)normalizedPath)) {
            return GuvnorM2Repository.loadPomFromJar(file);
        }
        if (FileNameUtilities.isDeployedPom((String)normalizedPath)) {
            return GuvnorM2Repository.loadPom(file);
        }
        throw new RuntimeException("Not a valid jar, kjar or pom file: " + path);
    }

    public String getKModuleText(String path) {
        return this.loadKieTextFromJar(path, META_INF, KMODULE_XML);
    }

    public String getKieDeploymentDescriptorText(String path) {
        return this.loadKieTextFromJar(path, META_INF, KIE_DEPLOYMENT_DESCRIPTOR_XML);
    }

    protected String loadKieTextFromJar(String jarFilePath, String subPath, String fileName) {
        ArtifactRepository repository = this.getArtifactRepository("global-m2-repo");
        File file = new File(repository.getRootDir(), jarFilePath);
        String normalizedPath = file.toPath().normalize().toString();
        if (FileNameUtilities.isJar((String)normalizedPath) || FileNameUtilities.isKJar((String)normalizedPath)) {
            return GuvnorM2Repository.loadFileTextFromJar(file, subPath, fileName);
        }
        return null;
    }

    private static String loadPomFromJar(File file) {
        return GuvnorM2Repository.loadFileTextFromJar(file, META_INF_MAVEN, POM_XML);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String loadFileTextFromJar(File jarFile, String path, String fileName) {
        if (jarFile == null) return null;
        if (fileName == null) return null;
        if (fileName.isEmpty()) return null;
        try (ZipFile zip = new ZipFile(jarFile);){
            ZipEntry entry;
            Enumeration<? extends ZipEntry> e = zip.entries();
            do {
                if (!e.hasMoreElements()) return null;
            } while (!(entry = e.nextElement()).getName().startsWith(path) || !entry.getName().endsWith(fileName));
            String string = GuvnorM2Repository.zipEntryToString(zip, entry);
            return string;
        }
        catch (ZipException e) {
            log.error(e.getMessage());
            return null;
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadPom(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            String string;
            try (InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
                StringBuilder sb = new StringBuilder();
                int c = isr.read();
                while (c != -1) {
                    sb.append((char)c);
                    c = isr.read();
                }
                string = sb.toString();
            }
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public GAV loadGAVFromJar(String jarPath) {
        ArtifactRepository repository = this.getArtifactRepository("global-m2-repo");
        File zip = new File(repository.getRootDir(), jarPath);
        try {
            String pomProperties = this.loadGAVFromJarInternal(zip);
            Properties props = new Properties();
            props.load(new StringReader(pomProperties));
            String groupId = props.getProperty(GROUP_ID_NAME);
            String artifactId = props.getProperty(ARTIFACT_ID_NAME);
            String version = props.getProperty(VERSION_NAME);
            return new GAV(groupId, artifactId, version);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private String loadGAVFromJarInternal(File file) {
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith(META_INF_MAVEN) || !entry.getName().endsWith(POM_PROPERTIES)) continue;
                return GuvnorM2Repository.zipEntryToString(zip, entry);
            }
        }
        catch (ZipException e) {
            log.error(e.getMessage());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static String loadPomFromJar(InputStream jarInputStream) {
        try {
            InputStream is = GuvnorM2Repository.getInputStreamFromJar(jarInputStream, META_INF_MAVEN, POM_XML);
            StringBuilder sb = new StringBuilder();
            int c = is.read();
            while (c != -1) {
                sb.append((char)c);
                c = is.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String loadPomPropertiesFromJar(InputStream jarInputStream) {
        try {
            InputStream is = GuvnorM2Repository.getInputStreamFromJar(jarInputStream, META_INF_MAVEN, POM_PROPERTIES);
            StringBuilder sb = new StringBuilder();
            int c = is.read();
            while (c != -1) {
                sb.append((char)c);
                c = is.read();
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private static InputStream getInputStreamFromJar(InputStream jarInputStream, String prefix, String suffix) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(jarInputStream);
        while ((entry = zis.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.startsWith(prefix) || !entryName.endsWith(suffix)) continue;
            return new ReaderInputStream((Reader)new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException("Could not find '" + prefix + "/*/" + suffix + "' in the jar.");
    }

    private File appendFileToJar(String content, String contentPath, String jarPath) {
        File originalJarFile = new File(jarPath);
        File appendedJarFile = new File(jarPath + ".tmp");
        try (ZipFile war = new ZipFile(originalJarFile);
             ZipOutputStream append = new ZipOutputStream(new FileOutputStream(appendedJarFile));){
            this.copyEntriesFromExistingWar(war, append);
            ZipEntry e = new ZipEntry(contentPath);
            append.putNextEntry(e);
            append.write(content.getBytes());
            append.closeEntry();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return appendedJarFile;
    }

    private void copyEntriesFromExistingWar(ZipFile war, ZipOutputStream append) throws IOException {
        Enumeration<? extends ZipEntry> entries = war.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            append.putNextEntry(e);
            if (!e.isDirectory()) {
                IOUtil.copy((InputStream)war.getInputStream(e), (OutputStream)append);
            }
            append.closeEntry();
        }
    }

    protected String toFileName(GAV gav, String fileName) {
        return gav.getGroupId() + "-" + gav.getArtifactId() + "-" + gav.getVersion() + "-" + Math.random() + "." + fileName;
    }

    public String generatePOM(GAV gav) {
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersion());
        model.setModelVersion("4.0.0");
        StringWriter stringWriter = new StringWriter();
        try {
            new MavenXpp3Writer().write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return stringWriter.toString();
    }

    public static String generatePomProperties(GAV gav) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(gav.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(gav.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(gav.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    public String getPomXmlPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/" + POM_XML;
    }

    public String getPomPropertiesPath(GAV gav) {
        return "META-INF/maven/" + gav.getGroupId() + "/" + gav.getArtifactId() + "/" + POM_PROPERTIES;
    }

    public String generateParentPOM(GAV gav) {
        Model model = new Model();
        model.setGroupId(gav.getGroupId());
        model.setArtifactId(gav.getArtifactId());
        model.setVersion(gav.getVersion());
        model.setPackaging(POM);
        model.setModelVersion("4.0.0");
        StringWriter stringWriter = new StringWriter();
        try {
            new MavenXpp3Writer().write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return stringWriter.toString();
    }

    public boolean containsArtifact(GAV gav) {
        return this.containsArtifact(gav, repo -> true);
    }

    public boolean containsArtifact(GAV gav, Predicate<ArtifactRepository> filter) {
        return this.repositories.stream().filter(filter).anyMatch(artifactRepository -> artifactRepository.containsArtifact(gav));
    }

    public File getArtifactFileFromRepository(GAV gav) {
        List artifacts = this.repositories.stream().map(artifactRepository -> artifactRepository.getArtifactFileFromRepository(gav)).filter(artifact -> artifact != null).collect(Collectors.toList());
        return (File)artifacts.get(0);
    }

    protected static String zipEntryToString(ZipFile zip, ZipEntry entry) throws IOException {
        InputStream is = zip.getInputStream(entry);
        InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        int c = isr.read();
        while (c != -1) {
            sb.append((char)c);
            c = isr.read();
        }
        return sb.toString();
    }

    private static /* synthetic */ void lambda$deployPom$5(Artifact finalPomArtifact, ArtifactRepository artifactRepository) {
        artifactRepository.deploy(null, finalPomArtifact);
    }

    private static /* synthetic */ void lambda$deployArtifact$4(String pomXML, Artifact finalJarArtifact, Artifact finalPomXMLArtifact, ArtifactRepository repository) {
        repository.deploy(pomXML, finalJarArtifact, finalPomXMLArtifact);
    }

    private static /* synthetic */ void lambda$deployParentPom$3(String pomXML, Artifact finalPomXMLArtifact, ArtifactRepository artifactRepository) {
        artifactRepository.deploy(pomXML, finalPomXMLArtifact);
    }
}

