/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;

@Portable
public class DefaultPermissionCollection
implements PermissionCollection {
    private TreeSet<Permission> permissionSet = new TreeSet();

    @Override
    public Collection<Permission> collection() {
        return this.permissionSet;
    }

    @Override
    public PermissionCollection add(Permission ... permissions) {
        for (Permission p : permissions) {
            Permission existing = this.get(p.getName());
            if (existing != null) {
                this.remove(p);
            }
            if (this.implies(p)) continue;
            this.permissionSet.add(p);
        }
        return this;
    }

    @Override
    public PermissionCollection remove(Permission ... permissions) {
        for (Permission p : permissions) {
            this.permissionSet.remove(p);
        }
        return this;
    }

    @Override
    public Permission get(String name) {
        for (Permission p : this.permissionSet) {
            if (!this.equalsName(name, p.getName())) continue;
            return p;
        }
        return null;
    }

    protected boolean equalsName(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    @Override
    public boolean implies(Permission permission) {
        for (Permission p : this.permissionSet) {
            if (!p.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean impliesName(Permission permission) {
        for (Permission p : this.permissionSet) {
            if (!p.impliesName(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PermissionCollection merge(PermissionCollection other, int priority) {
        if (other == null || other.collection().isEmpty()) {
            return this;
        }
        PermissionCollection result = priority > 0 ? other.clone() : this.clone();
        PermissionCollection target = priority > 0 ? this : other;
        for (Permission p : target.collection()) {
            this.addToCollectionIf(result, p, priority == 0);
        }
        return result;
    }

    private void addToCollectionIf(PermissionCollection result, Permission p, boolean grantedWins) {
        Permission existing = result.get(p.getName());
        if (existing == null && !result.impliesName(p)) {
            result.add(p);
        } else if (grantedWins && AuthorizationResult.ACCESS_GRANTED.equals((Object)p.getResult())) {
            Iterator<Permission> it = result.collection().iterator();
            while (it.hasNext()) {
                Permission next = it.next();
                if (!p.impliesName(next)) continue;
                it.remove();
            }
            result.add(p);
        }
    }

    @Override
    public DefaultPermissionCollection clone() {
        DefaultPermissionCollection clone = new DefaultPermissionCollection();
        for (Permission p : this.permissionSet) {
            clone.add(p.clone());
        }
        return clone;
    }

    public PermissionCollection invert(Permission target) {
        target.setResult(target.getResult().invert());
        Iterator<Permission> it = this.permissionSet.iterator();
        while (it.hasNext()) {
            Permission p = it.next();
            if (target.equals(p) || !target.implies(p)) continue;
            it.remove();
        }
        return this;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Permission p : this.permissionSet) {
            out.append(p).append("\n");
        }
        return out.toString();
    }
}

