/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.MISSING_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInputDataException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.utils.ConverterTypeUtil;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreProcess {
    private static final Logger logger = LoggerFactory.getLogger(PreProcess.class);

    private PreProcess() {
    }

    public static ProcessingDTO preProcess(KiePMMLModel model, PMMLContext context) {
        List<MiningField> notTargetMiningFields = model.getMiningFields() != null ? model.getMiningFields().stream().filter(miningField -> !PreProcess.isTarget(miningField)).collect(Collectors.toList()) : Collections.emptyList();
        PMMLRequestData requestData = context.getRequestData();
        PreProcess.convertInputData(notTargetMiningFields, requestData);
        PreProcess.verifyFixInvalidValues(notTargetMiningFields, requestData);
        PreProcess.verifyAddMissingValues(notTargetMiningFields, requestData);
        ProcessingDTO toReturn = PreProcess.createProcessingDTO(model, requestData.getMappedRequestParams());
        PreProcess.executeTransformations(toReturn, requestData);
        return toReturn;
    }

    static void convertInputData(List<MiningField> notTargetMiningFields, PMMLRequestData requestData) {
        logger.debug("convertInputData {} {}", notTargetMiningFields, (Object)requestData);
        Collection requestParams = requestData.getRequestParams();
        notTargetMiningFields.forEach(miningField -> {
            ParameterInfo parameterInfo = requestParams.stream().filter(paramInfo -> miningField.getName().equals(paramInfo.getName())).findFirst().orElse(null);
            if (parameterInfo != null) {
                Object originalValue = parameterInfo.getValue();
                Object requiredValue = miningField.getDataType().getActualValue(originalValue);
                parameterInfo.setType(miningField.getDataType().getMappedClass());
                parameterInfo.setValue(requiredValue);
            }
        });
    }

    static void verifyFixInvalidValues(List<MiningField> notTargetMiningFields, PMMLRequestData requestData) {
        logger.debug("verifyInvalidValues {} {}", notTargetMiningFields, (Object)requestData);
        Collection requestParams = requestData.getRequestParams();
        ArrayList toRemove = new ArrayList();
        notTargetMiningFields.forEach(miningField -> {
            ParameterInfo parameterInfo = requestParams.stream().filter(paramInfo -> miningField.getName().equals(paramInfo.getName())).findFirst().orElse(null);
            if (parameterInfo != null) {
                boolean match = PreProcess.isMatching(parameterInfo, miningField);
                if (!match) {
                    PreProcess.manageInvalidValues(miningField, parameterInfo, toRemove);
                }
                toRemove.forEach(arg_0 -> ((PMMLRequestData)requestData).removeRequestParam(arg_0));
            }
        });
    }

    static void verifyAddMissingValues(List<MiningField> notTargetMiningFields, PMMLRequestData requestData) {
        logger.debug("verifyMissingValues {} {}", notTargetMiningFields, (Object)requestData);
        Collection requestParams = requestData.getRequestParams();
        notTargetMiningFields.forEach(miningField -> {
            ParameterInfo parameterInfo = requestParams.stream().filter(paramInfo -> miningField.getName().equals(paramInfo.getName())).findFirst().orElse(null);
            if (parameterInfo == null) {
                PreProcess.manageMissingValues(miningField, requestData);
            }
        });
    }

    static ProcessingDTO createProcessingDTO(KiePMMLModel model, Map<String, ParameterInfo> mappedRequestParams) {
        List<KiePMMLNameValue> kiePMMLNameValues = PreProcess.getKiePMMLNameValuesFromParameterInfos(mappedRequestParams.values());
        return new ProcessingDTO(model, kiePMMLNameValues);
    }

    static void executeTransformations(ProcessingDTO processingDTO, PMMLRequestData requestData) {
        logger.debug("executeTransformations {} {}", (Object)processingDTO, (Object)requestData);
        for (KiePMMLDerivedField derivedField : processingDTO.getDerivedFields()) {
            Object derivedValue = derivedField.evaluate(processingDTO);
            if (derivedValue == null) continue;
            requestData.addRequestParam(derivedField.getName(), derivedValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(derivedField.getName(), derivedValue));
        }
    }

    static List<KiePMMLNameValue> getKiePMMLNameValuesFromParameterInfos(Collection<ParameterInfo> parameterInfos) {
        return parameterInfos.stream().map(parameterInfo -> new KiePMMLNameValue(parameterInfo.getName(), parameterInfo.getValue())).collect(Collectors.toList());
    }

    static void manageInvalidValues(MiningField miningField, ParameterInfo parameterInfo, List<ParameterInfo> toRemove) {
        INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod = miningField.getInvalidValueTreatmentMethod() != null ? miningField.getInvalidValueTreatmentMethod() : INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID;
        Object originalValue = parameterInfo.getValue();
        switch (invalidValueTreatmentMethod) {
            case RETURN_INVALID: {
                throw new KiePMMLInputDataException("Invalid value " + originalValue + " for " + miningField.getName());
            }
            case AS_MISSING: {
                toRemove.add(parameterInfo);
                break;
            }
            case AS_IS: {
                break;
            }
            case AS_VALUE: {
                String invalidValueReplacement = miningField.getInvalidValueReplacement();
                if (invalidValueReplacement == null) {
                    throw new KiePMMLInputDataException("Missing required invalidValueReplacement for " + miningField.getName());
                }
                Object requiredValue = miningField.getDataType().getActualValue((Object)invalidValueReplacement);
                parameterInfo.setType(miningField.getDataType().getMappedClass());
                parameterInfo.setValue(requiredValue);
                break;
            }
            default: {
                throw new KiePMMLException("Unmanaged INVALID_VALUE_TREATMENT_METHOD " + invalidValueTreatmentMethod);
            }
        }
    }

    static void manageMissingValues(MiningField miningField, PMMLRequestData requestData) {
        MISSING_VALUE_TREATMENT_METHOD missingValueTreatmentMethod = miningField.getMissingValueTreatmentMethod() != null ? miningField.getMissingValueTreatmentMethod() : MISSING_VALUE_TREATMENT_METHOD.RETURN_INVALID;
        switch (missingValueTreatmentMethod) {
            case RETURN_INVALID: {
                throw new KiePMMLInputDataException("Missing required value for " + miningField.getName());
            }
            case AS_IS: 
            case AS_MEAN: 
            case AS_MODE: 
            case AS_MEDIAN: 
            case AS_VALUE: {
                String missingValueReplacement = miningField.getMissingValueReplacement();
                if (missingValueReplacement == null) break;
                Object requiredValue = miningField.getDataType().getActualValue((Object)missingValueReplacement);
                requestData.addRequestParam(miningField.getName(), requiredValue);
                break;
            }
            default: {
                throw new KiePMMLException("Unmanaged INVALID_VALUE_TREATMENT_METHOD " + missingValueTreatmentMethod);
            }
        }
    }

    static boolean isMatching(ParameterInfo parameterInfo, MiningField miningField) {
        boolean toReturn = true;
        Object originalValue = parameterInfo.getValue();
        if (miningField.getAllowedValues() != null && !miningField.getAllowedValues().isEmpty()) {
            toReturn = miningField.getAllowedValues().stream().anyMatch(allowedValue -> {
                Object allowedObject = ConverterTypeUtil.convert(originalValue.getClass(), (Object)allowedValue);
                return originalValue.equals(allowedObject);
            });
        } else if (miningField.getIntervals() != null && !miningField.getIntervals().isEmpty()) {
            double originalValueNumber = ((Number)originalValue).doubleValue();
            toReturn = miningField.getIntervals().stream().anyMatch(interval -> originalValueNumber >= interval.getLeftMargin().doubleValue() && originalValueNumber <= interval.getRightMargin().doubleValue());
        }
        return toReturn;
    }

    private static boolean isTarget(MiningField miningField) {
        FIELD_USAGE_TYPE fieldUsageType = miningField.getUsageType() != null ? miningField.getUsageType() : FIELD_USAGE_TYPE.ACTIVE;
        return fieldUsageType == FIELD_USAGE_TYPE.TARGET || fieldUsageType == FIELD_USAGE_TYPE.PREDICTED;
    }
}

