/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.time.Duration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaServerProducer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerProducer.class);
    private static KafkaServerProducer instance;
    private Producer<String, byte[]> producer;
    private Supplier<Producer<String, byte[]>> producerSupplier;
    private KafkaEventProcessorFactory factory;
    private Lock producerLock = new ReentrantLock();

    public static void init(KafkaEventProcessorFactory factory, Supplier<Producer<String, byte[]>> producerSupplier) {
        instance = new KafkaServerProducer(factory, producerSupplier);
    }

    public static void cleanup(Duration duration) {
        if (instance != null) {
            instance.close(duration);
            instance = null;
        }
    }

    public static void publish(ProcessInstance processInstance, String name, Object value) {
        if (instance != null) {
            instance.sendEvent(processInstance, name, value);
        }
    }

    private KafkaServerProducer(KafkaEventProcessorFactory factory, Supplier<Producer<String, byte[]>> producerSupplier) {
        this.factory = factory;
        this.producerSupplier = producerSupplier;
    }

    private void close(Duration duration) {
        this.producerLock.lock();
        try {
            if (this.producer != null) {
                this.producer.close(duration);
                this.producer = null;
            }
        }
        finally {
            this.producerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ProcessInstance processInstance, String name, Object value) {
        this.producerLock.lock();
        try {
            if (this.producer == null) {
                this.producer = this.producerSupplier.get();
            }
        }
        finally {
            this.producerLock.unlock();
        }
        try {
            String topic = KafkaServerUtils.topicFromSignal(name);
            logger.debug("Publishing event {}  to topic {}", value, (Object)topic);
            this.producer.send(new ProducerRecord(topic, (Object)this.factory.getEventWriter(topic).writeEvent(processInstance, value)), (m, e) -> {
                if (e != null) {
                    this.logError(value, e);
                }
            });
        }
        catch (Exception e2) {
            this.logError(value, e2);
        }
    }

    private void logError(Object value, Exception e) {
        logger.error("Error publishing event {}", value, (Object)e);
    }
}

