/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.List;
import org.drools.compiler.lang.api.CEDescrBuilder;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrLhsFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRhsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrRulesFactory {
    public static final String STATUS_HOLDER = "$statusHolder";
    public static final String BREAK_LABEL = "match";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrRulesFactory.class.getName());
    final PackageDescrBuilder builder;

    private KiePMMLDescrRulesFactory(PackageDescrBuilder builder) {
        this.builder = builder;
    }

    public static KiePMMLDescrRulesFactory factory(PackageDescrBuilder builder) {
        return new KiePMMLDescrRulesFactory(builder);
    }

    public void declareRules(List<KiePMMLDroolsRule> rules) {
        logger.trace("declareRules {}", rules);
        rules.forEach(this::declareRule);
    }

    protected void declareRule(KiePMMLDroolsRule rule) {
        logger.trace("declareRule {}", (Object)rule);
        RuleDescrBuilder ruleBuilder = this.builder.newRule().name(rule.getName());
        if (rule.getAgendaGroup() != null) {
            this.declareAgendaGroup(ruleBuilder, rule.getAgendaGroup());
        }
        if (rule.getActivationGroup() != null) {
            this.declareActivationGroup(ruleBuilder, rule.getActivationGroup());
        }
        KiePMMLDescrLhsFactory.factory((CEDescrBuilder<RuleDescrBuilder, AndDescr>)ruleBuilder.lhs()).declareLhs(rule);
        KiePMMLDescrRhsFactory.factory(ruleBuilder).declareRhs(rule);
    }

    protected void declareAgendaGroup(RuleDescrBuilder ruleBuilder, String agendaGroup) {
        ruleBuilder.attribute("agenda-group").type(AttributeDescr.Type.STRING).value(agendaGroup);
    }

    protected void declareActivationGroup(RuleDescrBuilder ruleBuilder, String activationGroup) {
        ruleBuilder.attribute("activation-group").type(AttributeDescr.Type.STRING).value(activationGroup);
    }
}

