/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.util.ArrayList;
import java.util.Collection;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.CoreCondition;
import org.dashbuilder.dataprovider.sql.model.FunctionColumn;
import org.dashbuilder.dataprovider.sql.model.LogicalCondition;
import org.dashbuilder.dataprovider.sql.model.SimpleColumn;
import org.dashbuilder.dataprovider.sql.model.SortColumn;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.sort.SortOrder;

public class Column {
    protected String name;
    protected String alias;
    protected ColumnType type;
    protected int length;

    public Column(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getAlias() {
        return this.alias;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public Column setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public Column setType(ColumnType type) {
        this.type = type;
        return this;
    }

    public Column setLength(int length) {
        this.length = length;
        return this;
    }

    public Column as(String alias) {
        this.setAlias(alias);
        return this;
    }

    public Column lower() {
        return new FunctionColumn("lower", this);
    }

    public SortColumn asc() {
        return new SortColumn(this, SortOrder.ASCENDING);
    }

    public SortColumn desc() {
        return new SortColumn(this, SortOrder.DESCENDING);
    }

    public Column function(AggregateFunctionType functionType) {
        SimpleColumn simpleColumn = new SimpleColumn(this.name, this.type, this.length);
        simpleColumn.setFunctionType(functionType);
        return simpleColumn;
    }

    public Condition isNull() {
        return new CoreCondition(this, CoreFunctionType.IS_NULL, new Object[0]);
    }

    public Condition notNull() {
        return new CoreCondition(this, CoreFunctionType.NOT_NULL, new Object[0]);
    }

    public Condition equalsTo(Object param) {
        return new CoreCondition(this, CoreFunctionType.EQUALS_TO, param);
    }

    public Condition in(Collection params) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Object param : params) {
            conditions.add(this.equalsTo(param));
        }
        return new LogicalCondition(LogicalExprType.OR, conditions);
    }

    public Condition inSql(Collection params) {
        return new CoreCondition(this, CoreFunctionType.IN, params);
    }

    public Condition notInSql(Collection params) {
        return new CoreCondition(this, CoreFunctionType.NOT_IN, params);
    }

    public Condition notEquals(Object param) {
        return new CoreCondition(this, CoreFunctionType.NOT_EQUALS_TO, param);
    }

    public Condition like(String param) {
        return new CoreCondition(this, CoreFunctionType.LIKE_TO, param);
    }

    public Condition greaterThan(Object param) {
        return new CoreCondition(this, CoreFunctionType.GREATER_THAN, param);
    }

    public Condition greaterOrEquals(Object param) {
        return new CoreCondition(this, CoreFunctionType.GREATER_OR_EQUALS_TO, param);
    }

    public Condition lowerThan(Object param) {
        return new CoreCondition(this, CoreFunctionType.LOWER_THAN, param);
    }

    public Condition lowerOrEquals(Object param) {
        return new CoreCondition(this, CoreFunctionType.LOWER_OR_EQUALS_TO, param);
    }

    public Condition between(Object from, Object to) {
        return new CoreCondition(this, CoreFunctionType.BETWEEN, from, to);
    }

    public Column year() {
        return new FunctionColumn("year", this);
    }

    public Column month() {
        return new FunctionColumn("month", this);
    }

    public Column day() {
        return new FunctionColumn("day", this);
    }

    public Column hour() {
        return new FunctionColumn("hour", this);
    }

    public Column minute() {
        return new FunctionColumn("minute", this);
    }

    public Column second() {
        return new FunctionColumn("second", this);
    }
}

