/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.regression.RegressionModel;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.dto.RegressionCompilationDTO;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableRegressionFactory;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionTableClassificationFactory {
    public static final String KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE_JAVA = "KiePMMLRegressionTableClassificationTemplate.tmpl";
    public static final String KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE = "KiePMMLRegressionTableClassificationTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionTableClassificationFactory.class.getName());
    private static final String MAIN_CLASS_NOT_FOUND = "Main class not found";
    private static final String KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE_JAVA = "KiePMMLGetProbabilityMapMethodTemplate.tmpl";
    private static final String KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE = "KiePMMLGetProbabilityMapMethodTemplate";
    private static AtomicInteger classArity = new AtomicInteger(0);
    private static CompilationUnit templateEvaluate;
    private static CompilationUnit cloneEvaluate;

    private KiePMMLRegressionTableClassificationFactory() {
    }

    public static Map<String, KiePMMLTableSourceCategory> getRegressionTables(RegressionCompilationDTO compilationDTO) {
        logger.trace("getRegressionTables {}", compilationDTO.getRegressionTables());
        LinkedHashMap<String, KiePMMLTableSourceCategory> toReturn = KiePMMLRegressionTableRegressionFactory.getRegressionTables(compilationDTO);
        Map.Entry<String, String> regressionTableEntry = KiePMMLRegressionTableClassificationFactory.getRegressionTable(compilationDTO, toReturn);
        toReturn.put(regressionTableEntry.getKey(), new KiePMMLTableSourceCategory(regressionTableEntry.getValue(), ""));
        return toReturn;
    }

    public static Map.Entry<String, String> getRegressionTable(RegressionCompilationDTO compilationDTO, LinkedHashMap<String, KiePMMLTableSourceCategory> regressionTablesMap) {
        logger.trace("getRegressionTable {}", regressionTablesMap);
        String className = "KiePMMLRegressionTableClassification" + classArity.addAndGet(1);
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)compilationDTO.getPackageName(), (String)KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE);
        ClassOrInterfaceDeclaration tableTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        boolean isBinary = compilationDTO.isBinary(regressionTablesMap.size());
        KiePMMLRegressionTableClassificationFactory.populateGetProbabilityMapMethod(compilationDTO.getModelNormalizationMethod(), isBinary, tableTemplate);
        KiePMMLRegressionTableClassificationFactory.populateIsBinaryMethod(isBinary, tableTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)tableTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", tableTemplate.getName())));
        KiePMMLRegressionTableClassificationFactory.setConstructor(compilationDTO, constructorDeclaration, tableTemplate.getName());
        KiePMMLRegressionTableClassificationFactory.addMapPopulation(constructorDeclaration.getBody(), regressionTablesMap);
        KiePMMLRegressionTableRegressionFactory.populateGetTargetCategory(tableTemplate, null);
        return new AbstractMap.SimpleEntry<String, String>(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
    }

    static void setConstructor(RegressionCompilationDTO compilationDTO, ConstructorDeclaration constructorDeclaration, SimpleName generatedClassName) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"targetField", (Expression)new StringLiteralExpr(compilationDTO.getTargetFieldName()));
        REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod = compilationDTO.getDefaultREGRESSION_NORMALIZATION_METHOD();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"regressionNormalizationMethod", (Expression)new NameExpr(regressionNormalizationMethod.getClass().getSimpleName() + "." + regressionNormalizationMethod.name()));
        OP_TYPE opType = compilationDTO.getOP_TYPE();
        if (opType != null) {
            CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"opType", (Expression)new NameExpr(opType.getClass().getSimpleName() + "." + opType.name()));
        }
    }

    static void addMapPopulation(BlockStmt body, LinkedHashMap<String, KiePMMLTableSourceCategory> regressionTablesMap) {
        regressionTablesMap.forEach((className, tableSourceCategory) -> {
            ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
            objectCreationExpr.setType(className);
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(tableSourceCategory.getCategory()), objectCreationExpr});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("categoryTableMap"), "put", expressions));
        });
    }

    static void populateGetProbabilityMapMethod(RegressionModel.NormalizationMethod normalizationMethod, boolean isBinary, ClassOrInterfaceDeclaration tableTemplate) {
        try {
            String normalizationName = normalizationMethod.name();
            if (RegressionModel.NormalizationMethod.NONE.equals((Object)normalizationMethod) && isBinary) {
                normalizationName = normalizationName + "Binary";
            }
            String methodName = String.format("get%sProbabilityMap", normalizationName);
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0);
            CommonCodegenUtils.addMethod((MethodDeclaration)toReturn, (ClassOrInterfaceDeclaration)tableTemplate, (String)"getProbabilityMap");
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }

    static void populateIsBinaryMethod(boolean isBinary, ClassOrInterfaceDeclaration tableTemplate) {
        try {
            MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("isBinary").get(0);
            BlockStmt blockStmt = new BlockStmt();
            blockStmt.addStatement((Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(isBinary)));
            methodDeclaration.setBody(blockStmt);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }
}

