/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.api.generator.CasePrefixCannotBeGeneratedException;
import org.jbpm.casemgmt.impl.generator.CaseIdExpressionFunctions;
import org.jbpm.casemgmt.impl.generator.CaseIdInfo;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.jbpm.shared.services.impl.commands.RemoveObjectCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.mvel2.CompileException;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCaseIdGenerator
implements CaseIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TableCaseIdGenerator.class);
    private boolean removeOnUnregister = Boolean.parseBoolean(System.getProperty("org.jbpm.casemgmt.table.generator.clean", "false"));
    private static final String IDENTIFIER = "DB";
    private TransactionalCommandService commandService;

    public TableCaseIdGenerator(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public void register(String prefix) {
        CaseIdInfo caseIdInfo = this.findCaseIdInfoByPrefix(prefix);
        if (caseIdInfo == null) {
            logger.debug("Case id prefix {} not yet registered", (Object)prefix);
            caseIdInfo = new CaseIdInfo();
            caseIdInfo.setCaseIdPrefix(prefix);
            caseIdInfo.setCurrentValue(new Long(0L));
            this.commandService.execute((Command)new PersistObjectCommand(new Object[]{caseIdInfo}));
        } else {
            logger.debug("Case id prefix {} already registered and it's current value is {}", (Object)prefix, (Object)caseIdInfo.getCurrentValue());
        }
    }

    public void unregister(String prefix) {
        if (this.removeOnUnregister) {
            CaseIdInfo caseIdInfo = this.findCaseIdInfoByPrefix(prefix);
            if (caseIdInfo != null) {
                this.commandService.execute((Command)new RemoveObjectCommand(new Object[]{caseIdInfo}));
                logger.debug("Removed permanently case id info for prefix {}", (Object)prefix);
            }
        } else {
            logger.debug("Skipping remove of case id info for prefix {}", (Object)prefix);
        }
    }

    public String resolveCaseIdPrefix(String expression, Map<String, Object> optionalParameters) {
        try {
            return !expression.isEmpty() ? (String)TemplateRuntime.eval((String)expression, (Object)CaseIdExpressionFunctions.CASE_ID_FUNCTIONS, optionalParameters) : "";
        }
        catch (CompileException e) {
            throw new CasePrefixCannotBeGeneratedException("Case Id Prefix cannot be generated", (Throwable)e);
        }
    }

    public String generate(String prefix, Map<String, Object> optionalParameters) {
        CaseIdInfo caseIdInfo = (CaseIdInfo)this.commandService.execute((Command)new IncrementAndGetCaseIdCommand(prefix));
        logger.debug("Next sequence value for case id prefix {} is {}", (Object)prefix, (Object)caseIdInfo.getCurrentValue());
        long nextVal = caseIdInfo.getCurrentValue();
        String paddedNumber = String.format("%010d", nextVal);
        return prefix + "-" + paddedNumber;
    }

    protected CaseIdInfo findCaseIdInfoByPrefix(String prefix) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("prefix", prefix);
        params.put("firstResult", 0);
        params.put("maxResults", 1);
        List caseIdInfos = (List)this.commandService.execute((Command)new QueryNameCommand("findCaseIdInfoByPrefix", params));
        if (caseIdInfos.isEmpty()) {
            return null;
        }
        return (CaseIdInfo)caseIdInfos.get(0);
    }

    private class IncrementAndGetCaseIdCommand
    implements ExecutableCommand<CaseIdInfo> {
        private static final long serialVersionUID = 8670412133363766162L;
        private String prefix;

        public IncrementAndGetCaseIdCommand(String prefix) {
            this.prefix = prefix;
        }

        public CaseIdInfo execute(Context context) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("prefix", this.prefix);
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            CaseIdInfo caseIdInfo = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                caseIdInfo = (CaseIdInfo)ctx.queryAndLockWithParametersInTransaction("findCaseIdInfoByPrefix", params, true, CaseIdInfo.class);
                if (caseIdInfo != null) {
                    caseIdInfo.setCurrentValue(caseIdInfo.getCurrentValue() + 1L);
                    ctx.merge((Object)caseIdInfo);
                }
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            return caseIdInfo;
        }
    }
}

