/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLRowFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLInlineTableFactory {
    static final String KIE_PMML_INLINETABLE_TEMPLATE_JAVA = "KiePMMLInlineTableTemplate.tmpl";
    static final String KIE_PMML_INLINETABLE_TEMPLATE = "KiePMMLInlineTableTemplate";
    static final String GETKIEPMMLINLINETABLE = "getKiePMMLInlineTable";
    static final String INLINETABLE = "inlineTable";
    static final ClassOrInterfaceDeclaration INLINETABLE_TEMPLATE;

    private KiePMMLInlineTableFactory() {
    }

    static BlockStmt getInlineTableVariableDeclaration(String variableName, InlineTable inlineTable) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)INLINETABLE_TEMPLATE.getMethodsByName(GETKIEPMMLINLINETABLE).get(0)).clone();
        BlockStmt inlineTableBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(inlineTableBody, INLINETABLE).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", INLINETABLE, inlineTableBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList arguments = new NodeList();
        for (Row row : inlineTable.getRows()) {
            String nestedVariableName = String.format("%s_%s", variableName, counter);
            arguments.add((Node)new NameExpr(nestedVariableName));
            BlockStmt toAdd = KiePMMLRowFactory.getRowVariableDeclaration(nestedVariableName, row);
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            ++counter;
        }
        ObjectCreationExpr objectCreationExpr = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", INLINETABLE, toReturn)))).asObjectCreationExpr();
        objectCreationExpr.getArguments().set(0, (Node)new StringLiteralExpr(variableName));
        ((Expression)objectCreationExpr.getArguments().get(2)).asMethodCallExpr().setArguments(arguments);
        inlineTableBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_INLINETABLE_TEMPLATE_JAVA);
        INLINETABLE_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_INLINETABLE_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLInlineTableTemplate"));
        ((MethodDeclaration)INLINETABLE_TEMPLATE.getMethodsByName(GETKIEPMMLINLINETABLE).get(0)).clone();
    }
}

