/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcess {
    private static final Logger logger = LoggerFactory.getLogger(PostProcess.class);

    private PostProcess() {
    }

    public static void postProcess(PMML4Result toReturn, KiePMMLModel model, ProcessingDTO processingDTO) {
        PostProcess.executeTargets(toReturn, processingDTO);
        PostProcess.updateTargetValueType(model, toReturn);
        PostProcess.populateProcessingDTO(toReturn, model, processingDTO);
        PostProcess.populateOutputFields(toReturn, processingDTO);
    }

    static void populateProcessingDTO(PMML4Result pmml4Result, KiePMMLModel model, ProcessingDTO toPopulate) {
        pmml4Result.getResultVariables().forEach((key, value) -> toPopulate.addKiePMMLNameValue(new KiePMMLNameValue(key, value)));
        Map sortedByValue = model.getOutputFieldsMap().entrySet().stream().filter(entry -> entry.getValue() instanceof Double && (Double)entry.getValue() > 0.0).map(entry -> new AbstractMap.SimpleEntry<String, Double>((String)entry.getKey(), (Double)entry.getValue())).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        ArrayList orderedReasonCodes = new ArrayList(sortedByValue.keySet());
        toPopulate.addOrderedReasonCodes(orderedReasonCodes);
        toPopulate.setAffinity(model.getAffinity());
        toPopulate.setEntityId(model.getEntityId());
        toPopulate.setPredictedDisplayValue(model.getPredictedDisplayValue());
        toPopulate.setProbabilityMap(model.getProbabilityMap());
    }

    static void executeTargets(PMML4Result toModify, ProcessingDTO processingDTO) {
        logger.debug("executeTargets {} {}", (Object)toModify, (Object)processingDTO);
        if (!toModify.getResultCode().equals(ResultCode.OK.getName())) {
            return;
        }
        String targetFieldName = toModify.getResultObjectName();
        Map resultVariables = toModify.getResultVariables();
        processingDTO.getKiePMMLTargets().stream().filter(kiePMMLTarget -> kiePMMLTarget.getField() != null && kiePMMLTarget.getField().equals(targetFieldName)).findFirst().ifPresent(kiePMMLTarget -> {
            Object prediction = resultVariables.get(targetFieldName);
            logger.debug("Original prediction {}", prediction);
            Object modifiedPrediction = kiePMMLTarget.modifyPrediction(resultVariables.get(targetFieldName));
            logger.debug("Modified prediction {}", modifiedPrediction);
            resultVariables.put(targetFieldName, modifiedPrediction);
        });
    }

    static void updateTargetValueType(KiePMMLModel model, PMML4Result toUpdate) {
        DATA_TYPE dataType = model.getMiningFields().stream().filter(miningField -> model.getTargetField().equals(miningField.getName())).map(MiningField::getDataType).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find DATA_TYPE for " + model.getTargetField()));
        Object prediction = toUpdate.getResultVariables().get(model.getTargetField());
        if (prediction != null) {
            Object convertedPrediction = dataType.getActualValue(prediction);
            toUpdate.getResultVariables().put(model.getTargetField(), convertedPrediction);
        }
    }

    static void populateOutputFields(PMML4Result toUpdate, ProcessingDTO processingDTO) {
        logger.debug("populateOutputFields {} {}", (Object)toUpdate, (Object)processingDTO);
        for (KiePMMLOutputField outputField : processingDTO.getOutputFields()) {
            Object variableValue = outputField.evaluate(processingDTO);
            if (variableValue == null) continue;
            String variableName = outputField.getName();
            toUpdate.addResultVariable(variableName, variableValue);
            processingDTO.addKiePMMLNameValue(new KiePMMLNameValue(variableName, variableValue));
        }
    }
}

