/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.panels.MaximizeToggleButtonPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.listbar.ListBarWidget;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PartDefinition;

public abstract class AbstractSimpleWorkbenchPanelView<P extends WorkbenchPanelPresenter>
extends AbstractDockingWorkbenchPanelView<P> {
    @Inject
    protected ListBarWidget listBar;

    @PostConstruct
    void setup() {
        this.setupListBar();
        this.getPartViewContainer().add(this.listBar);
    }

    protected void setupListBar() {
        this.listBar.setDndManager(this.dndManager);
        this.listBar.disableDnd();
        this.dndManager.unregisterDropController(this);
        this.addOnFocusHandler(this.listBar);
        this.addSelectionHandler(this.listBar);
        this.listBar.asWidget().getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        Layouts.setToFillParent(this.listBar.asWidget());
        MaximizeToggleButtonPresenter maximizeButton = this.listBar.getMaximizeButton();
        maximizeButton.setVisible(true);
        maximizeButton.setMaximizeCommand(new Command(){

            public void execute() {
                AbstractSimpleWorkbenchPanelView.this.maximize();
            }
        });
        maximizeButton.setUnmaximizeCommand(new Command(){

            public void execute() {
                AbstractSimpleWorkbenchPanelView.this.unmaximize();
            }
        });
    }

    public void enableDnd() {
        this.listBar.enableDnd();
    }

    public void init(P presenter) {
        this.presenter = presenter;
        this.listBar.setPresenter((WorkbenchPanelPresenter)presenter);
    }

    @Override
    public P getPresenter() {
        return (P)this.presenter;
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        if (this.listBar.getPartsSize() != 0) {
            throw new RuntimeException("Uberfire Panel Invalid State: This panel support only one part.");
        }
        this.listBar.addPart(view);
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        this.listBar.changeTitle(part, title, titleDecoration);
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        return this.listBar.selectPart(part);
    }

    @Override
    public boolean removePart(PartDefinition part) {
        return this.listBar.remove(part);
    }

    @Override
    public void setFocus(boolean hasFocus) {
        this.listBar.setFocus(hasFocus);
    }

    public void onResize() {
        if (this.isAttached()) {
            this.presenter.onResize(this.getOffsetWidth(), this.getOffsetHeight());
        }
        if (this.getWidget() instanceof RequiresResize) {
            super.onResize();
        }
    }

    @Override
    public void maximize() {
        MaximizeToggleButtonPresenter maximizeButton = this.listBar.getMaximizeButton();
        maximizeButton.disable();
        this.layoutSelection.get().maximize((Widget)this.getPartViewContainer(), () -> maximizeButton.enable());
        maximizeButton.setMaximized(true);
    }

    @Override
    public void unmaximize() {
        MaximizeToggleButtonPresenter maximizeButton = this.listBar.getMaximizeButton();
        maximizeButton.disable();
        this.layoutSelection.get().unmaximize((Widget)this.getPartViewContainer(), () -> maximizeButton.enable());
        maximizeButton.setMaximized(false);
    }

    @Override
    public void setElementId(String elementId) {
        super.setElementId(elementId);
        this.listBar.getMaximizeButton().getView().asWidget().ensureDebugId(elementId + "-maximizeButton");
    }

    @Override
    public Collection<PartDefinition> getParts() {
        return this.listBar.getParts();
    }
}

