/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;

public class PipelineExecutorTaskDefImpl
implements PipelineExecutorTaskDef {
    private String pipeline;
    private List<String> stages = new ArrayList<String>();
    private Input input;
    private ProviderId providerId;
    private ProviderType providerType;

    public PipelineExecutorTaskDefImpl() {
    }

    private PipelineExecutorTaskDefImpl(Pipeline pipeline) {
        this.pipeline = pipeline.getName();
        pipeline.getStages().forEach(stage -> this.stages.add(stage.getName()));
    }

    public PipelineExecutorTaskDefImpl(Pipeline pipeline, Input input) {
        this(pipeline);
        this.input = input;
    }

    public PipelineExecutorTaskDefImpl(Pipeline pipeline, Input input, ProviderId providerId) {
        this(pipeline);
        this.input = input;
        this.providerId = providerId;
    }

    public PipelineExecutorTaskDefImpl(Pipeline pipeline, Input input, ProviderType providerType) {
        this(pipeline);
        this.input = input;
        this.providerType = providerType;
    }

    @Override
    public String getPipeline() {
        return this.pipeline;
    }

    @Override
    public List<String> getStages() {
        return this.stages;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public ProviderId getProviderId() {
        return this.providerId;
    }

    @Override
    public ProviderType getProviderType() {
        return this.providerId != null ? this.providerId.getProviderType() : this.providerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineExecutorTaskDefImpl taskDef = (PipelineExecutorTaskDefImpl)o;
        if (this.pipeline != null ? !this.pipeline.equals(taskDef.pipeline) : taskDef.pipeline != null) {
            return false;
        }
        if (this.stages != null ? !this.stages.equals(taskDef.stages) : taskDef.stages != null) {
            return false;
        }
        if (this.input != null ? !this.input.equals(taskDef.input) : taskDef.input != null) {
            return false;
        }
        if (this.providerId != null ? !this.providerId.equals(taskDef.providerId) : taskDef.providerId != null) {
            return false;
        }
        return this.providerType != null ? this.providerType.equals(taskDef.providerType) : taskDef.providerType == null;
    }

    public int hashCode() {
        int result = this.pipeline != null ? this.pipeline.hashCode() : 0;
        result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
        result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
        result = 31 * result + (this.providerId != null ? this.providerId.hashCode() : 0);
        result = 31 * result + (this.providerType != null ? this.providerType.hashCode() : 0);
        return result;
    }
}

