/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.pmml.api.enums.Named;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.models.clustering.model.KiePMMLCluster;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLComparisonMeasure;
import org.kie.pmml.models.clustering.model.KiePMMLMissingValueWeights;

public abstract class KiePMMLClusteringModel
extends KiePMMLModel {
    protected ModelClass modelClass;
    protected List<KiePMMLCluster> clusters = new ArrayList<KiePMMLCluster>();
    protected List<KiePMMLClusteringField> clusteringFields = new ArrayList<KiePMMLClusteringField>();
    protected KiePMMLComparisonMeasure comparisonMeasure;
    protected KiePMMLMissingValueWeights missingValueWeights;

    protected KiePMMLClusteringModel(String modelName) {
        super(modelName, Collections.emptyList());
    }

    public Object evaluate(Object knowledgeBase, Map<String, Object> requestData, PMMLContext context) {
        double adjustmentFactor = this.computeAdjustmentFactor(requestData);
        Double[] inputs = new Double[this.clusteringFields.size()];
        for (int i = 0; i < this.clusteringFields.size(); ++i) {
            String fieldName = this.clusteringFields.get(i).getField();
            inputs[i] = requestData.containsKey(fieldName) ? (Double)requestData.get(fieldName) : null;
        }
        double[] aggregates = new double[this.clusters.size()];
        for (int i = 0; i < this.clusters.size(); ++i) {
            aggregates[i] = this.comparisonMeasure.getAggregateFunction().apply(this.clusteringFields, this.comparisonMeasure.getCompareFunction(), inputs, this.clusters.get(i).getValuesArray(), adjustmentFactor);
        }
        int selectedIndex = this.findMinIndex(aggregates);
        KiePMMLCluster selectedCluster = this.clusters.get(selectedIndex);
        int selectedEntityId = selectedIndex + 1;
        selectedCluster.getName().ifPresent(arg_0 -> ((PMMLContext)context).setPredictedDisplayValue(arg_0));
        context.setEntityId((Object)selectedEntityId);
        context.setAffinity((Object)aggregates[selectedIndex]);
        return selectedCluster.getId().orElseGet(() -> Integer.toString(selectedEntityId));
    }

    private double computeAdjustmentFactor(Map<String, Object> requestData) {
        double numerator = 1.0;
        double denumerator = 1.0;
        for (int i = 0; i < this.clusteringFields.size(); ++i) {
            double weight = this.missingValueWeightFor(i);
            double nonMissingFactor = requestData.containsKey(this.clusteringFields.get(i).getField()) ? 1.0 : 0.0;
            numerator *= weight;
            denumerator *= weight * nonMissingFactor;
        }
        return numerator / denumerator;
    }

    private int findMinIndex(double[] values) {
        int minIndex = 0;
        double min = values[minIndex];
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            minIndex = i;
            min = values[i];
        }
        return minIndex;
    }

    private double missingValueWeightFor(int fieldNumber) {
        return Optional.ofNullable(this.missingValueWeights).map(KiePMMLMissingValueWeights::getValues).filter(v -> v.size() >= fieldNumber).map(v -> (Double)v.get(fieldNumber)).orElse(1.0);
    }

    public static enum ModelClass implements Named
    {
        CENTER_BASED("centerBased"),
        DISTRIBUTION_BASED("distributionBased");

        private final String name;

        private ModelClass(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

