/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.AddCoverageListenerCommand;
import org.drools.scenariosimulation.backend.fluent.CoverageAgendaListener;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ValueWrapper;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.builder.fluent.KieSessionFluent;
import org.kie.internal.command.RegistryContext;

public class RuleStatefulScenarioExecutableBuilder
implements RuleScenarioExecutableBuilder {
    private final KieSessionFluent kieSessionFluent;
    private final ExecutableBuilder executableBuilder;
    private final Map<FactIdentifier, List<FactCheckerHandle>> internalConditions = new HashMap<FactIdentifier, List<FactCheckerHandle>>();
    private String agendaGroupName = null;
    private static final String DEFAULT_APPLICATION = "defaultApplication";
    protected static final BiFunction<String, KieContainer, KieSessionConfiguration> forcePseudoClock = (sn, kc) -> {
        KieSessionConfiguration kieSessionConfiguration = kc.getKieSessionConfiguration(sn);
        if (kieSessionConfiguration == null) {
            throw new ScenarioException("Impossible to find a KieSession with name " + sn);
        }
        kieSessionConfiguration.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        return kieSessionConfiguration;
    };

    protected RuleStatefulScenarioExecutableBuilder(KieContainer kieContainer, String kieSessionName) {
        this.executableBuilder = this.createExecutableBuilder();
        this.kieSessionFluent = ((ExecutableBuilder)this.executableBuilder.newApplicationContext(DEFAULT_APPLICATION)).setKieContainer(kieContainer).newSessionCustomized(kieSessionName, forcePseudoClock);
    }

    protected RuleStatefulScenarioExecutableBuilder(KieContainer kieContainer) {
        this(kieContainer, null);
    }

    @Override
    public void addInternalCondition(Class<?> clazz, Function<Object, ValueWrapper> checkFunction, ScenarioResult scenarioResult) {
        this.internalConditions.computeIfAbsent(scenarioResult.getFactIdentifier(), key -> new ArrayList()).add(new FactCheckerHandle(clazz, checkFunction, scenarioResult));
    }

    @Override
    public void setActiveAgendaGroup(String agendaGroupName) {
        this.agendaGroupName = agendaGroupName;
        this.kieSessionFluent.setActiveAgendaGroup(agendaGroupName);
    }

    @Override
    public void setActiveRuleFlowGroup(String ruleFlowGroup) {
        this.agendaGroupName = ruleFlowGroup;
        this.kieSessionFluent.setActiveRuleFlowGroup(ruleFlowGroup);
    }

    @Override
    public void insert(Object element) {
        this.kieSessionFluent.insert(element);
    }

    @Override
    public Map<String, Object> run() {
        Objects.requireNonNull(this.executableBuilder, "Executable builder is null, please invoke create(KieContainer, )");
        CoverageAgendaListener coverageAgendaListener = new CoverageAgendaListener();
        this.kieSessionFluent.addCommand((ExecutableCommand)new AddCoverageListenerCommand(coverageAgendaListener));
        ((KieSessionFluent)this.kieSessionFluent.addCommand((ExecutableCommand & Serializable)context -> {
            KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            return this.getAvailableRules(kieSession.getKieBase(), this.agendaGroupName);
        })).out("RULES_AVAILABLE");
        this.kieSessionFluent.fireAllRules();
        this.internalConditions.values().forEach(factToCheck -> this.kieSessionFluent.addCommand((ExecutableCommand)new ValidateFactCommand((List<FactCheckerHandle>)factToCheck)));
        ((ExecutableBuilder)this.kieSessionFluent.dispose()).end();
        RequestContext execute = (RequestContext)this.createExecutableRunner().execute(this.executableBuilder.getExecutable());
        HashMap<String, Object> toReturn = new HashMap<String, Object>(execute.getOutputs());
        toReturn.put("COVERAGE_LISTENER", (Object)coverageAgendaListener);
        return toReturn;
    }

    protected ExecutableBuilder createExecutableBuilder() {
        return ExecutableBuilder.create();
    }

    protected ExecutableRunner<RequestContext> createExecutableRunner() {
        return ExecutableRunner.create();
    }
}

